
with

installs as
(
  select base.time::timestamp::date as the_day, base.extension_id , base.url,
  case when ap.is_affiliate then 'Affiliate'
  when ap.is_partner then 'Partner'
  else 'None'
  end as Category, count(distinct base.user_id) as installs
  from tahoe.extension_install_button_click as base
  left join rollups.affiliates_partners_daily_channel_summary as ap
  on ap.day = base.time::timestamp::date and base.user_id = ap.channel_id
  where base.time_utc >= current_timestamp -7
  group by 1,2,3,4
)
,


views as
(
  select base.time::timestamp::date as the_day, i.extension_id, i.url,
  case when ap.is_affiliate then 'Affiliate'
  when ap.is_partner then 'Partner'
  else 'None'
  end as Category, count(distinct base.user_id) as views
  from logs.pageview as base
  join installs as i
  on base.time::timestamp::date = i.the_day and i.url = base.url
  left join rollups.affiliates_partners_daily_channel_summary as ap
  on ap.day = base.time::timestamp::date and base.user_id = ap.channel_id
  where base.time_utc >= current_timestamp -7
  group by 1,2,3,4

)
,

activations as
(
  select base.time::timestamp::date as the_day, i.extension_id,
  case when ap.is_affiliate then 'Affiliate'
  when ap.is_partner then 'Partner'
  else 'None'
  end as Category,
  count(distinct base.user_id) as activations
  from logs.extension_activate as base
  join installs as i
  on base.time::timestamp::date = i.the_day and i.extension_id = base.extension_id
  left join rollups.affiliates_partners_daily_channel_summary as ap
  on ap.day = base.time::timestamp::date and base.user_id = ap.channel_id
  where base.time_utc >= current_timestamp -7
  group by 1,2,3

)
,

total_installs as (
  select the_day, extension_id, category, sum(installs) as installs
  from installs
  group by 1,2,3
),

total_views as(
  select the_day, extension_id, category, sum(views) as views
  from views
  group by 1,2,3
)
,
total_activations as(
  select the_day, extension_id, category, sum(activations) as activations
  from activations
  group by 1,2,3

),

final as(
  select i.the_day, i.extension_id, extensions.extension_name, i.category, v.views, i.installs, a.activations,
  i.installs::float/v.views as conversion_views_installs,
  a.activations::float/i.installs as conversion_installs_activations
  from total_installs as i, total_views as v, total_activations as a, analysis.released_extensions_latest as extensions
  where i.the_day = v.the_day and v.the_day = a.the_day and i.extension_id = v.extension_id
  and v.extension_id = a.extension_id and i.extension_id = extensions.extension_id
  and i.category = v.category and v.category = a.category

)

select *
from final
