{% form %}

start_day:
  type: text
  default: '2018-06-14 00:00:00'

end_day:
  type: text
  default: '2018-06-16 00:00:00'

config_required:
  type: select
  default: 'true/false'
  options: ['true', 'false', 'true/false']

{% endform %}



 WITH

 time_constants AS (
  SELECT '{{ start_day }}'::timestamp AS start_day, '{{ end_day }}'::timestamp AS end_day
),

 all_extensions AS
 ( select distinct extension_id, extension_name
   from analysis.released_extensions_latest
 ),

 extensions_config AS
 ( select distinct config.extension_id, extns.extension_name, 1 as config
   from tahoe.extension_ebs_config_success as config
   join all_extensions as extns
   on config.extension_id = extns.extension_id
 ),

 extensions AS
 ( select base.extension_id, base.extension_name,case when ec.config is not null then true else false end as bool_config_required
  from all_extensions as base
  left join extensions_config as ec
  on base.extension_id = ec.extension_id
 ),


configurations AS
(select count(distinct channel_id) as configurations, extension_id
  from tahoe.extension_ebs_config_success
  where date>=(SELECT start_day FROM time_constants) AND date<(SELECT end_day FROM time_constants)
  group by extension_id

),

 the_logs AS (
  SELECT the_day, extension_id, channel_id, bool_extension_activated, bool_extension_installed
  FROM rollups.extension_daily_channel_presence
  WHERE the_day>=(SELECT start_day FROM time_constants) AND the_day<(SELECT end_day FROM time_constants)
  GROUP BY 1,2,3,4,5
),

the_net_in as

(SELECT the_day, extension_id, SUM(CASE WHEN bool_extension_activated THEN 1 ELSE 0 END) AS net_activations
, SUM(CASE WHEN bool_extension_installed THEN 1 ELSE 0 END) AS net_installs
FROM the_logs
GROUP BY 1,2
ORDER BY 1,2
),

the_net_out as
(
SELECT the_day, extension_id, SUM(CASE WHEN bool_extension_activated THEN 0 ELSE 1 END) AS net_deactivations
, SUM(CASE WHEN bool_extension_installed THEN 0 ELSE 1 END) AS net_uninstalls
FROM the_logs
GROUP BY 1,2
ORDER BY 1,2
),

final AS
(select tn.the_day, base.extension_name, base.extension_id, base.bool_config_required,
case when tn.net_installs is not null then tn.net_installs else 0 end as installs,
case when c.configurations is not null then c.configurations else 0 end as configurations,
case when tn.net_activations is not null then tn.net_activations else 0 end as activations,
case when tno.net_uninstalls is not null then tno.net_uninstalls else 0 end as uninstalls,
case when tno.net_deactivations is not null then tno.net_deactivations else 0 end as deactivations
from extensions as base
left join the_net_in as tn
on base.extension_id = tn.extension_id
left join configurations as c
on base.extension_id = c.extension_id
left join the_net_out as tno
on base.extension_id = tno.extension_id and tn.the_day = tno.the_day
),

filtered as
(
  select *
  from final
  {% if config_required == 'true' %}
   WHERE bool_config_required = true
  {% elsif config_required == 'false' %}
   WHERE bool_config_required = false
  {% else %}
   WHERE bool_config_required = true or bool_config_required = false
  {% endif %}
)

 select *
 from filtered
 where the_day is not null
