
{% form %}

start_day:
  type: text
  default: '2018-06-14 00:00:00'

end_day:
  type: text
  default: '2018-06-16 00:00:00'

{% endform %}



 WITH

 time_constants AS (
  SELECT '{{ start_day }}'::timestamp AS start_day, '{{ end_day }}'::timestamp AS end_day
),

the_urls_we_want AS (
  SELECT distinct url
  FROM tahoe.extension_install_button_click
  where date>=(SELECT start_day FROM time_constants) AND date<(SELECT end_day FROM time_constants)
),

pages as(
SELECT
CASE WHEN base.url LIKE '%www.twitch.tv/%/dashboard/extensions/manage%' THEN 'Extension Manager Page'
WHEN base.url LIKE '%www.twitch.tv/%/dashboard/extensions/whitelisted%' THEN 'Whitelisted'
WHEN base.url LIKE '%www.twitch.tv/%/dashboard/extensions%' THEN 'Discovery'
WHEN base.url LIKE '%www.twitch.tv/ext/categories%' THEN 'Category Page'
WHEN base.url LIKE '%www.twitch.tv/ext/search%' THEN 'Search Page'
WHEN base.url LIKE '%www.twitch.tv/ext%' THEN 'Extension Detail Page'
ELSE null
END AS page, base.url, content, medium
FROM logs.pageview as base, the_urls_we_want as tuww
WHERE base.time>=(SELECT start_day FROM time_constants) AND base.time<(SELECT end_day FROM time_constants) and base.url = tuww.url
)

select page, case when medium is null then 'unknown' else medium end as source, count(1) as the_count
from pages
group by 1,2
