--QA the 'extension_start_buy' and 'extension_confirm_buy' events


WITH the_timeframe AS (
SELECT
'2017-11-07 00:00:00'::TIMESTAMP AS start_time
, '2017-11-20 00:00:00'::TIMESTAMP AS end_time
, 155528531 AS user_id
, 'a_dot_burr' AS login
)

, extension_start_buy_logs AS (
SELECT "time" AS the_time, 'extension_start_buy' AS user_action --stuff about the event
, device_id, login, user_id, channel, channel_id, url --stuff about the user and channel
, developer_name, extension_id, extension_version, extension_anchor --stuff about the extension and dev
, asin, sku, vendor_code, item_name, item_price::FLOAT, item_price_currency, item_description, item_description_short --stuff about the item
FROM logs.extension_start_buy
WHERE "time">=(SELECT start_time FROM the_timeframe)
AND "time"<(SELECT end_time FROM the_timeframe)
--AND login = (SELECT login FROM the_timeframe)
--AND login_id=(SELECT user_id FROM the_timeframe)
)

, extension_confirm_buy_logs AS (
SELECT "time" AS the_time, 'extension_confirm_buy' AS user_action --stuff about the event
, device_id, login, user_id, channel, channel_id, url --stuff about the user and channel
, developer_name, extension_id, extension_version, extension_anchor --stuff about the extension and dev
, asin, sku, vendor_code, item_name, item_price::FLOAT, item_price_currency, item_description, item_description_short --stuff about the item
FROM logs.extension_confirm_buy
WHERE "time">=(SELECT start_time FROM the_timeframe)
AND "time"<(SELECT end_time FROM the_timeframe)
--AND login = (SELECT login FROM the_timeframe)
--AND login_id=(SELECT user_id FROM the_timeframe)
)

, extension_complete_buy_logs AS (
SELECT "time" AS the_time, 'extension_complete_buy' AS user_action --stuff about the event
, '' AS device_id, '' AS login, user_id, '' AS channel, channel_id, '' AS url --stuff about the user and channel
, '' AS developer_name, '' AS extension_id, '' AS extension_version, '' AS extension_anchor --stuff about the extension and dev
, asin, sku, vendor_code, '' AS item_name, -1 AS item_price, '' AS item_price_currency, '' AS item_description, '' AS item_description_short --stuff about the item
FROM logs.extension_complete_buy
WHERE "time">=(SELECT start_time FROM the_timeframe)
AND "time"<(SELECT end_time FROM the_timeframe)
--AND login = (SELECT login FROM the_timeframe)
--AND login_id=(SELECT user_id FROM the_timeframe)
)

SELECT * FROM extension_start_buy_logs
UNION ALL SELECT * FROM extension_confirm_buy_logs
UNION ALL SELECT * FROM extension_complete_buy_logs
ORDER BY user_id, the_time
