-- --   the_day                                TIMESTAMP WITHOUT TIME ZONE sortkey
-- --   , extension_id                         VARCHAR(32) distkey
-- --   , extension_version                    VARCHAR(25)
-- --   , extension_anchor                     VARCHAR(50)
-- --   , channel_id                           BIGINT
-- --   , flag_install_activate_status         VARCHAR(25)
-- --   , time_most_recent_install             TIMESTAMP WITHOUT TIME ZONE
-- --   , time_most_recent_activate            TIMESTAMP WITHOUT TIME ZONE
-- --   , time_most_recent_anchor_changed      TIMESTAMP WITHOUT TIME ZONE
-- --   , time_most_recent_deactivate          TIMESTAMP WITHOUT TIME ZONE
-- --   , time_most_recent_uninstall           TIMESTAMP WITHOUT TIME ZONE
-- --   , time_most_recent_delete              TIMESTAMP WITHOUT TIME ZONE
-- --   , bool_extension_installed             BOOLEAN
-- --   , bool_extension_activated             BOOLEAN
--
-- --
-- --
-- -- --TEST DATA FOR a_dot_burr
-- -- SELECT * FROM analysis.dsds_281_extension_daily_channel_presence_all_anchor
-- -- WHERE channel_id = 155528531 AND the_day>='2018-01-01'::TIMESTAMP ORDER BY the_day;
-- --
-- --CHECK LOG FOR PERSON WHO HAD OP.GG League of Legends Extension
-- SELECT *
-- FROM analysis.dsds_281_extension_daily_channel_presence_all_anchor
-- WHERE the_day>='2018-01-01'::TIMESTAMP AND the_day<'2018-03-01'::TIMESTAMP
-- AND extension_id = 'lgpf9j7y8n1ja9onkb6w7bxfkhk2zl' --OP.gg for league of legends
-- AND channel_id = 11805560
-- ORDER BY the_day;
--
--
--
--
--
--
-- --
-- -- -- SELECT *
-- -- -- FROM analysis.dsds_281_extension_daily_version
-- -- -- WHERE extension_id = 'nfed9xntpykkdh4t51i3jl6woovex4'
-- -- -- ORDER BY the_day;
-- --
-- WITH
-- the_data AS (
--   SELECT *  FROM analysis.dsds_281_extension_daily_version
-- )
-- , weird_extension_id AS (
--   SELECT *
--   FROM (
--     SELECT extension_id, the_day, COUNT(1) AS rows, COUNT(DISTINCT extension_version) AS versions
--     FROM the_data
--     GROUP BY 1,2
--   )
--   WHERE rows>1
-- )
-- -- SELECT *
-- -- FROM weird_extension_id
-- -- ORDER BY 1,2;
--
-- SELECT *
-- FROM analysis.dsds_281_extension_daily_version
-- WHERE extension_id IN (SELECT extension_id FROM weird_extension_id)
-- AND the_day IN (SELECT the_day FROM weird_extension_id);
-- --
-- -- SELECT MAX(the_day) FROM analysis.dsds_281_extension_daily_version;
-- --
-- -- --
-- -- --CHECK extension_anchor
-- -- SELECT the_day
-- --   , SUM(CASE WHEN extension_anchor IS NULL THEN 1 ELSE 0 END) AS count_null_extension_anchor
-- --   , SUM(CASE WHEN extension_anchor NOT IN ('component','panel','video_overlay') AND extension_anchor IS NOT NULL THEN 1 ELSE 0 END) AS count_error_extension_anchor
-- --   , SUM(CASE WHEN extension_anchor ='component' THEN 1 ELSE 0 END) AS count_component_extensions
-- --   , SUM(CASE WHEN extension_anchor ='panel' THEN 1 ELSE 0 END) AS count_panel_extensions
-- --   , SUM(CASE WHEN extension_anchor ='video_overlay' THEN 1 ELSE 0 END) AS count_overlay_extensions
-- -- FROM analysis.dsds_281_extension_daily_channel_presence_all_anchor
-- -- WHERE the_day>='2018-07-01'::TIMESTAMP
-- -- GROUP BY 1
-- -- ORDER BY 1
-- -- ;
-- -- --
-- -- --
-- -- --CHECK ACTIVE extension_anchor
-- -- SELECT the_day
-- --   , SUM(CASE WHEN extension_anchor IS NULL THEN 1 ELSE 0 END) AS count_null_extension_anchor
-- --   , SUM(CASE WHEN extension_anchor NOT IN ('component','panel','video_overlay') AND extension_anchor IS NOT NULL THEN 1 ELSE 0 END) AS count_error_extension_anchor
-- --   , SUM(CASE WHEN extension_anchor ='component' THEN 1 ELSE 0 END) AS count_component_extensions
-- --   , SUM(CASE WHEN extension_anchor ='panel' THEN 1 ELSE 0 END) AS count_panel_extensions
-- --   , SUM(CASE WHEN extension_anchor ='video_overlay' THEN 1 ELSE 0 END) AS count_overlay_extensions
-- -- FROM analysis.dsds_281_extension_daily_channel_presence_all_anchor
-- -- WHERE the_day>='2018-07-01'::TIMESTAMP
-- -- AND bool_extension_activated IS TRUE
-- -- GROUP BY 1
-- -- ORDER BY 1
-- -- ;
--
-- --
--
--
-- --
-- --
-- --CHECK THAT ACTIVATED EXTENSIONS HAVE VALUE FOR extension_anchor, some are still null, but thats a known issue
-- WITH
-- all_released_extension_versions AS (
--   SELECT extension_id, extension_version, extension_name, extension_anchor
--     , BOOL_OR(is_component_enabled) AS is_component_enabled
--     , BOOL_OR(is_overlay_enabled) AS is_overlay_enabled
--     , BOOL_OR(is_panel_enabled) AS is_panel_enabled
--     , BOOL_OR(is_mobile_enabled) AS is_mobile_enabled
--     , BOOL_OR(is_bits_enabled) AS is_bits_enabled
--   FROM analysis.extensions_metadata_full
--   WHERE extension_state='Released'
--   --GROUP BY 1,2,3,4,5,6,7,8,9
--   GROUP BY 1,2,3,4
-- )
-- , all_released_extensions AS (
--   SELECT extension_id, MAX(extension_version) AS extension_version, extension_name
--     --, is_component_enabled, is_overlay_enabled, is_panel_enabled, is_mobile_enabled, is_bits_enabled
--   FROM all_released_extension_versions
--   GROUP BY 1,3
-- )
-- SELECT base.extension_anchor, CASE WHEN rel.extension_name IS NOT NULL THEN 'released' ELSE 'not_released' END AS extension_type
-- --, REPLACE(rel.extension_name, ',', '') AS extension_name
--   , COUNT(1) AS rows, MIN(the_day) AS min_day, MAX(the_day) AS max_day
-- FROM (
--   SELECT the_day, channel_id, extension_id, extension_version, extension_anchor, flag_install_activate_status
--   FROM analysis.dsds_281_extension_daily_channel_presence_all_anchor
--   WHERE bool_extension_activated IS TRUE AND
--     (extension_anchor IS NOT NULL OR extension_anchor NOT IN ('video_overlay', 'panel', 'component'))
--     AND (the_day >= '2018-08-01'::TIMESTAMP)
--     --ORDER BY 2, 1, 3
-- ) base
-- LEFT JOIN all_released_extensions AS rel ON base.extension_id = rel.extension_id
-- GROUP BY 1,2
-- ORDER BY 1,2
-- ;
--
--
--
--CHECK TO SEE IF THERE ARE DUPLICATES
WITH
the_data AS (
  SELECT *  FROM analysis.dsds_281_extension_daily_channel_presence_all_anchor
  WHERE the_day >= '2019-01-01'::TIMESTAMP
  --the_day = '2018-07-01'::TIMESTAMP OR
  --group by 1,2,3,4,5,6,7,8,9,10,11,12,13,14
)
, weird_channel_id AS (
  SELECT *
  FROM (
    SELECT channel_id, extension_id, the_day, COUNT(1) AS rows
    FROM the_data
    GROUP BY 1,2,3
  )
  WHERE rows>1
)
SELECT extension_id, SUM(rows) AS rows, COUNT(DISTINCT channel_id) AS channels, COUNT(DISTINCT the_day) AS days
, MIN(the_day) AS min_day, MAX(the_day) AS max_day
FROM weird_channel_id GROUP BY 1 ORDER BY 2 DESC;
-- --
-- -- SELECT * FROM the_data
-- -- WHERE channel_id IN (SELECT channel_id FROM weird_channel_id)
-- -- OR extension_id IN (SELECT extension_id FROM weird_channel_id)
-- -- ORDER BY channel_id, extension_id, time_most_recent_activate
-- -- ;
--
--
-- --
-- -- SELECT the_day, COUNT(1) AS rows
-- -- FROM analysis.dsds_281_extension_daily_channel_presence_all_anchor
-- -- GROUP BY 1
-- -- ORDER BY 1
-- -- ;
--
-- -- SELECT the_day, extension_id, bool_extension_activated, COUNT(DISTINCT channel_id) AS channels, COUNT(1) AS rows
-- -- FROM rollups.extension_daily_channel_presence
-- -- WHERE extension_id = 'h7683cdyci11yov0tlac9f6lkvgtzi'
-- -- AND the_day>='2018-07-01'::TIMESTAMP
-- -- GROUP BY 1,2,3
-- -- ORDER BY 1,2,3
-- -- ;
--
--
-- --CHECK TO SEE IF VALID extension_version exists for all rows
-- WITH
-- the_data AS (
--   SELECT *  FROM analysis.dsds_281_extension_daily_channel_presence_all_anchor
--   WHERE the_day >= '2018-01-01'::TIMESTAMP
--   AND bool_extension_activated IS TRUE AND extension_id = 'h7683cdyci11yov0tlac9f6lkvgtzi'
--   --the_day = '2018-07-01'::TIMESTAMP OR
--   --group by 1,2,3,4,5,6,7,8,9,10,11,12,13,14
-- )
-- , weird_data AS (
--   SELECT the_day, extension_id, extension_version, COUNT(1) AS rows
--   FROM the_data
--   WHERE extension_version IS NULL OR extension_version = '0.0.0' --in rollup we assigned 0.0.0 to nulls in processing
--   GROUP BY 1,2,3
-- )
-- -- SELECT extension_id, extension_version, SUM(rows) AS rows
-- -- , COUNT(DISTINCT the_day) AS days, MIN(the_day) AS min_day, MAX(the_day) AS max_day
-- -- FROM weird_data
-- -- GROUP BY 1,2
-- -- ORDER BY 3 DESC;
-- --
-- SELECT the_day, COUNT(DISTINCT base.extension_id) AS extensions, SUM(rows) AS rows, COUNT(DISTINCT extension_name) AS released_extensions
-- FROM weird_data AS base
-- LEFT JOIN analysis.released_extensions_latest AS rel ON base.extension_id = rel.extension_id
-- GROUP BY 1
-- ORDER BY 1;
--
--
-- -- , extension_null_version AS (
-- --   SELECT the_day, extension_id, extension_version FROM weird_data WHERE the_day >= '2018-08-26'::TIMESTAMP
-- --   GROUP BY 1,2,3
-- -- )
-- -- SELECT base.the_day,base.extension_id, rel.extension_name, base.extension_version
-- -- FROM extension_null_version AS base
-- -- LEFT JOIN analysis.released_extensions_latest AS rel ON base.extension_id = rel.extension_id
-- -- ORDER BY 1,2;
--
--
--
-- --
-- -- SELECT base.*
-- -- FROM the_data AS base
-- -- RIGHT JOIN weird_data AS weird ON base.the_day = weird.the_day AND base.extension_id = weird.extension_id
-- -- ORDER BY the_day, extension_id, channel_id, time_most_recent_activate
-- -- ;
--
--
-- --
-- -- SELECT *  FROM analysis.dsds_281_extension_daily_channel_presence_all_anchor
-- -- WHERE the_day = '2018-07-30'::TIMESTAMP
-- -- AND extension_id = 'h7683cdyci11yov0tlac9f6lkvgtzi'
-- -- LIMIT 100
-- -- ;


--
-- WITH
-- all_released_extension_versions AS (
--   SELECT extension_id, extension_version, extension_name, extension_anchor
--     , BOOL_OR(is_component_enabled) AS is_component_enabled
--     , BOOL_OR(is_overlay_enabled) AS is_overlay_enabled
--     , BOOL_OR(is_panel_enabled) AS is_panel_enabled
--     , BOOL_OR(is_mobile_enabled) AS is_mobile_enabled
--     , BOOL_OR(is_bits_enabled) AS is_bits_enabled
--   FROM analysis.extensions_metadata_full
--   WHERE extension_state='Released'
--   --GROUP BY 1,2,3,4,5,6,7,8,9
--   GROUP BY 1,2,3,4
-- )
-- , all_released_extensions AS (
--   SELECT extension_id, MAX(extension_version) AS extension_version, extension_name
--     --, is_component_enabled, is_overlay_enabled, is_panel_enabled, is_mobile_enabled, is_bits_enabled
--   FROM all_released_extension_versions
--   GROUP BY 1,3
-- )
-- SELECT base.extension_id, base.extension_version, CASE WHEN rel.extension_name IS NOT NULL THEN 'released' ELSE 'not_released' END AS extension_type
-- , REPLACE(rel.extension_name, ',', '') AS extension_name
--   , COUNT(1) AS rows, MIN(the_day) AS min_day, MAX(the_day) AS max_day
-- FROM (
--   SELECT the_day, channel_id, extension_id, extension_version, extension_anchor, flag_install_activate_status
--   FROM analysis.dsds_281_extension_daily_channel_presence_all_anchor
--   WHERE bool_extension_activated IS TRUE
--     AND (extension_version IS NULL OR extension_version = '0.0.0')
--     AND (the_day >= '2018-01-01'::TIMESTAMP)
--     --ORDER BY 2, 1, 3
-- ) base
-- LEFT JOIN all_released_extensions AS rel ON base.extension_id = rel.extension_id
-- GROUP BY 1,2,3,4
-- ORDER BY 3,4,1,2
-- ;




--CHECK THAT ACTIVATED EXTENSIONS HAVE VALUE FOR extension_anchor, some are still null, but thats a known issue
WITH
all_released_extension_versions AS (
  SELECT extension_id, extension_version, extension_name, extension_anchor
    , BOOL_OR(is_component_enabled) AS is_component_enabled
    , BOOL_OR(is_overlay_enabled) AS is_overlay_enabled
    , BOOL_OR(is_panel_enabled) AS is_panel_enabled
    , BOOL_OR(is_mobile_enabled) AS is_mobile_enabled
    , BOOL_OR(is_bits_enabled) AS is_bits_enabled
  FROM analysis.extensions_metadata_full
  WHERE extension_state='Released'
  --GROUP BY 1,2,3,4,5,6,7,8,9
  GROUP BY 1,2,3,4
)
, all_released_extensions AS (
  SELECT extension_id, MAX(extension_version) AS extension_version, extension_name
    --, is_component_enabled, is_overlay_enabled, is_panel_enabled, is_mobile_enabled, is_bits_enabled
  FROM all_released_extension_versions
  GROUP BY 1,3
)
SELECT base.extension_anchor, CASE WHEN rel.extension_name IS NOT NULL THEN 'released' ELSE 'not_released' END AS extension_type
--, REPLACE(rel.extension_name, ',', '') AS extension_name
  , COUNT(1) AS rows, MIN(the_day) AS min_day, MAX(the_day) AS max_day
FROM (
  SELECT the_day, channel_id, extension_id, extension_version, extension_anchor, flag_install_activate_status
  FROM analysis.dsds_281_extension_daily_channel_presence_all_anchor
  WHERE bool_extension_activated IS TRUE
    AND (extension_anchor IS NULL OR extension_anchor NOT IN ('video_overlay', 'panel', 'component'))
    AND (the_day >= '2018-01-01'::TIMESTAMP)
    --ORDER BY 2, 1, 3
) base
LEFT JOIN all_released_extensions AS rel ON base.extension_id = rel.extension_id
GROUP BY 1,2
ORDER BY 1,2
;


--CHECK THE DATA FOR EACH DAY OF ROLLUP
SELECT the_day, COUNT(1) AS rows
FROM analysis.dsds_281_extension_daily_channel_presence_all_anchor
WHERE bool_extension_activated IS TRUE
AND the_day>='2018-08-01'::TIMESTAMP
GROUP BY 1
ORDER BY 1
;
