-- CREATE A SNIPPET TO GET THE CURRENT RELEASED EXTENSIONS
-- USED TO INFER extension_anchor FOR A GIVEN EXTENSION ACTIVATE EVENT WHEN RETURNING NULL DATA
WITH
all_released_extension_versions AS (
  SELECT extension_id, extension_version, extension_name, extension_anchor
    , BOOL_OR(is_component_enabled) AS is_component_enabled
    , BOOL_OR(is_overlay_enabled) AS is_overlay_enabled
    , BOOL_OR(is_panel_enabled) AS is_panel_enabled
    , BOOL_OR(is_mobile_enabled) AS is_mobile_enabled
    , BOOL_OR(is_bits_enabled) AS is_bits_enabled
  FROM analysis.extensions_metadata_full
  WHERE extension_state='Released'
  GROUP BY 1,2,3,4
)

, multi AS (
  SELECT * FROM (
  SELECT extension_id, extension_version, extension_name, COUNT(1) AS rows
  FROM all_released_extension_versions
  GROUP BY 1,2,3
)
WHERE rows>1
)

SELECT * FROM multi

-- -- SELECT * FROM all_released_extension_versions WHERE extension_id IN (SELECT extension_id FROM multi) ORDER BY extension_id, extension_version;
--
-- SELECT * FROM all_released_extension_versions --WHERE extension_id IN (SELECT extension_id FROM multi)
-- WHERE extension_id = '24u62kim5mn0slhwigdt7v4ybkwef5'
-- ORDER BY 1,2,3,4,5,6

--
-- SELECT extension_anchor, COUNT(DISTINCT extension_id) AS extensions, COUNT(1) AS rows, COUNT(DISTINCT extension_id+extension_anchor) AS extension_and_anchor
-- FROM analysis.dsds_281_historical_extensions
-- GROUP BY 1
-- ORDER BY 1
-- ;
--
-- SELEcT * FROM (
-- SELECT extension_id, COUNT(1) AS rows, COUNT(DISTINCT extension_anchor) AS anchors
-- FROM analysis.dsds_281_historical_extensions
-- GROUP BY 1
-- )
-- WHERE rows>1
-- ORDER BY 1
--
-- ;

--
-- WITH
-- the_data AS (
--   SELECT true::BOOLEAN as the_bool
--   UNION ALL SELECT false::BOOLEAN as the_bool
--   UNION ALL SELECT null AS the_bool
-- )
--
-- SELECT CASE WHEN the_bool FROM the_data
