-- SELECT *
-- FROM tahoe.extension_delete
-- WHERE extension_id = 'lgpf9j7y8n1ja9onkb6w7bxfkhk2zl' --op.gg
-- AND "date"='2017-11-10'::DATE
-- ;
--
-- SELECT * FROM (
-- SELECT extension_id, extension_version, COUNT(DISTINCT state) AS states, COUNT(1) AS rows
-- , MIN(time) AS min_time, MAX(time) AS max_time
-- FROM tahoe.extension_delete
-- GROUP BY 1, 2
-- )
-- WHERE states>1 OR rows>1
-- ORDER BY 1, 2
-- ;




--
-- SELECT
--   (SELECT start_date::DATE FROM the_basetable_date) AS start_date
--   , (SELECT end_date::DATE FROM the_basetable_date) AS end_date
--   , "time"::TIMESTAMP, extension_id::VARCHAR, extension_version::VARCHAR, user_id::BIGINT
-- FROM tahoe.extension_delete
-- WHERE extension_id IS NOT NULL AND extension_version IS NOT NULL
--   AND (SELECT start_date FROM the_basetable_date)<="time" AND "time"<(SELECT end_date FROM the_basetable_date)
--   AND (SELECT start_date FROM the_basetable_date)<="date" AND "date"<(SELECT end_date FROM the_basetable_date)
-- GROUP BY 1,2,3,4,5,6



--get raw delete logs and remove duplicates, used when extension_version IS NOT the value 'N/A' (which we assign to 0.0.0)


WITH
the_parameter_constants AS (
  SELECT
    -- DATE_TRUNC('day', (SYSDATE - INTERVAL '7 hours')) - INTERVAL '1 day' AS range_start
    -- , DATE_TRUNC('day', (SYSDATE - INTERVAL '7 hours')) AS range_end

    -- '2018-08-23'::TIMESTAMP AS range_start
    -- , '2018-08-24'::TIMESTAMP AS range_end

    '2018-01-01'::TIMESTAMP AS range_start
    , '2018-01-02'::TIMESTAMP AS range_end
    -- $1::TIMESTAMP AS range_start
    -- , DATEADD(day, 1, $1::TIMESTAMP) AS range_end
)
--used to get the time frame to look at the the activation/deactivation/uninstall/delete logs
, the_basetable_date AS (
  SELECT
    '2017-05-01'::TIMESTAMP AS start_date --start from may 1st to capture all possible events
    , date::TIMESTAMP AS end_date
  FROM metadata.date
  WHERE date>=(SELECT range_start FROM the_parameter_constants) AND date<(SELECT range_end FROM the_parameter_constants)
  GROUP BY 1,2
)

--get raw delete logs and remove duplicates, used when extension_version IS NOT the value 'N/A' (which we assign to 0.0.0)
, delete_logs_v1 AS (
  SELECT
    (SELECT start_date::DATE FROM the_basetable_date) AS start_date
    , (SELECT end_date::DATE FROM the_basetable_date) AS end_date
    , "time"::TIMESTAMP, extension_id::VARCHAR, extension_version::VARCHAR, user_id::BIGINT
  FROM tahoe.extension_delete
  WHERE extension_id IS NOT NULL AND extension_version IS NOT NULL
    AND (SELECT start_date FROM the_basetable_date)<="time" AND "time"<(SELECT end_date FROM the_basetable_date)
    AND (SELECT start_date FROM the_basetable_date)<="date" AND "date"<(SELECT end_date FROM the_basetable_date)
    AND state IN ('Deleted') --there is non 'Deleted' data in this table for op.gg league of legends extensions for date=2017-11-10
  GROUP BY 1,2,3,4,5,6
)

SELECT * FROM (
  SELECT extension_id, extension_version, COUNT(1) AS rows
  , MIN(time) AS min_time, MAX(time) AS max_time
  FROM delete_logs_v1
  GROUP BY 1, 2
)
WHERE rows>1
ORDER BY 1, 2
;
