


--
-- channel_id |          extension_id          | extension_anchor
-- ------------+--------------------------------+------------------
--      35512 | asppxuf1di6v7hwfucmogjg9eh32au |
--      35512 | rh6jq1q334hqc2rr1qlzqbvwlfl3x0 | panel
--      35512 | rh6jq1q334hqc2rr1qlzqbvwlfl3x0 |
--      35512 | wi08ebtatdc7oj83wtl9uxwz807l8b | panel

-- 2018-08-22 15:15:00 (CHECK IF PANEL EXTENSIONS REMOVED VIA EDIT PANELS STILL FIRES)
-- a_dot_burr activated stream elements leaderboard and stream avatar as panels (theres some replacement behavior before this)
-- then used edit panels to remove the slot for stream Avatar
-- then used incognito window to open up a_dot_burr's channel
-- check if stream avatar is firing a render event and view event?
--

WITH
the_extensions_constants AS (
  SELECT 'uaw3vx1k0ttq74u9b2zfvt768eebh1' AS extension_id
)
-- get a per day per extension_id per extension_version count of render records
, extension_render_aggregate_step0 AS (
  SELECT DATE_TRUNC('day',"time") AS the_day, base.extension_id, base.extension_version, COUNT(1) AS records
  , REPLACE(rel.extension_name, ',', '') AS extension_name
  FROM logs.extension_render AS base
  LEFT JOIN analysis.released_extensions_latest AS rel ON base.extension_id = rel.extension_id
  WHERE base.extension_id = (SELECT extension_id FROM the_extensions_constants)
  GROUP BY 1,2,3,5
)
-- for each day and extension_id combo, get the max count of records
, extension_render_aggregate_step1 AS (
  SELECT the_day, extension_id, MAX(records) AS max_records
  FROM extension_render_aggregate_step0
  GROUP BY 1,2
)
-- for each day and extension_id, return 1 row that is the one with the most records, this will help determine what extension_version it is that day
, extension_render_aggregate_step2 AS (
  SELECT step0.the_day, step0.extension_id, step0.extension_version, step0.records, step1.max_records, step0.extension_name
  FROM extension_render_aggregate_step0 AS step0
  LEFT JOIN extension_render_aggregate_step1 AS step1
    ON step0.the_day = step1.the_day AND step0.extension_id = step1.extension_id
  WHERE step0.records = step1.max_records
)





SELECT *
FROM extension_render_aggregate_step2
ORDER BY 2,1,3
