

WITH
the_parameter_constants AS (
  SELECT
    DATE_TRUNC('day', (SYSDATE - INTERVAL '7 hours')) - INTERVAL '1 day' AS range_start
    --'2018-01-01'::TIMESTAMP AS range_start
    , DATE_TRUNC('day', (SYSDATE - INTERVAL '7 hours')) AS range_end
    -- $1::TIMESTAMP AS range_start
    -- , DATEADD(day, 1, $1::TIMESTAMP) AS range_end
)
--used as table to left join the activation/deactivation/uninstall/delete logs against
, the_basetable_date AS (
  SELECT
    '2017-05-01'::TIMESTAMP AS start_date --start from may 1st to capture all possible events
    , date::TIMESTAMP AS end_date
  FROM metadata.date
  WHERE date>=(SELECT range_start FROM the_parameter_constants) AND date<(SELECT range_end FROM the_parameter_constants)
  GROUP BY 1,2
)
, the_extensions_constants AS (
  --SELECT 'fe5a78xkj1lnk9wefpk295p6x3dsvl' AS extension_id --stream avatar
  SELECT 'h7683cdyci11yov0tlac9f6lkvgtzi' AS extension_id --Spotify: Now Playing
)

--join the raw extension_install log against our base table that contains date ranges
, delete_logs_step0 AS (
  SELECT
    (SELECT start_date::DATE FROM the_basetable_date) AS start_date
    , (SELECT end_date::DATE FROM the_basetable_date) AS end_date
    , "time"::TIMESTAMP, extension_id::VARCHAR, extension_version::VARCHAR, user_id::BIGINT
  FROM tahoe.extension_delete
  WHERE extension_id IS NOT NULL AND extension_version IS NOT NULL
  AND (SELECT start_date FROM the_basetable_date)<="time" AND "time"<(SELECT end_date FROM the_basetable_date)
  --AND extension_id IN (SELECT extension_id FROM the_extensions_constants)
  GROUP BY 1,2,3,4,5,6
)

SELECT * FROM delete_logs_step0
ORDER BY 1,2,4,5

-- --processing to deal with same event firing duplicate rows with one being normal extension_version and another being extension_version='N/A'
-- , delete_logs_step1 AS (
--   SELECT start_date, end_date, "time", extension_id
--   , MAX(CASE WHEN extension_version='N/A' THEN '0.0.0' ELSE extension_version END) AS extension_version --this is to deal with same event firing duplicate events with one being regular extension_version and another being extension_version='N/A'
--   , user_id
--   FROM delete_logs_step0
--   GROUP BY 1,2,3,4,6
-- )


--
-- --for each user and extension, get the last timestamp that an install action occurred (for the given start_date to end_date range)
-- , delete_logs_step2 AS (
--   SELECT
--     final.start_date, final.end_date, final.extension_id, final.extension_version, final.channel_id, final.last_time_uninstall
--   FROM (
--     SELECT
--       *, MAX(last_time_delete) OVER (PARTITION BY start_date, end_date, channel_id, extension_id) AS max_last_time_delete
--     FROM (
--       SELECT
--         start_date, end_date, extension_id, extension_version, channel_id, MAX(time) AS last_time_delete
--       FROM delete_logs_step1
--       GROUP BY 1,2,3,4,5
--     ) t
--   ) AS final
--   WHERE last_time_delete = max_last_time_delete --only get the activate record that matches the max timestamp (i.e. they activate/reactivate multiple times within same day)
-- )

-- --CHECK FOR DUPLICATE RECORDS WITH SAME CHANNEL EXTENSION DATE COMBO
-- , weird_channel_id AS (
--   SELECT *
--   FROM (
--     SELECT channel_id, extension_id, start_date, end_date, COUNT(1) AS rows
--     FROM uninstall_logs_step2
--     GROUP BY 1,2,3,4
--   )
--   WHERE rows>1
-- )
--
-- SELECT * FROM uninstall_logs_step2 WHERE channel_id IN (SELECT channel_id FROM weird_channel_id)
-- ORDER BY channel_id, last_time_uninstall
--
-- SELECT extension_id, extension_version, COUNT(1) AS rows, COUNT(DISTINCT channel_id) AS channels
-- , MIN(last_time_delete) AS min_time, MAX(last_time_delete) AS max_time
-- FROM delete_logs_step2
-- GROUP BY 1,2
-- ORDER BY 1,2
