WITH
the_parameter_constants AS (
  SELECT
    DATE_TRUNC('day', (SYSDATE - INTERVAL '7 hours'))  AS range_start
    , DATE_TRUNC('day', (SYSDATE - INTERVAL '7 hours')) + INTERVAL '1 day' AS range_end
    -- $1::TIMESTAMP AS range_start
    -- , DATEADD(day, 1, $1::TIMESTAMP) AS range_end
)
--used to get the time frame to look at the the activation/deactivation/uninstall/delete logs
, the_basetable_date AS (
  SELECT
    DATE_TRUNC('day', (SYSDATE - INTERVAL '7 hours')) - INTERVAL '1 day' AS start_date
    , date::TIMESTAMP AS end_date
  FROM metadata.date
  WHERE date>=(SELECT range_start FROM the_parameter_constants) AND date<(SELECT range_end FROM the_parameter_constants)
  GROUP BY 1,2
)





-- get a per day per extension_id per extension_version count of render records
, extension_render_aggregate_step0 AS (
  SELECT DATE_TRUNC('day',"time") AS the_day, base.extension_id, base.extension_version, COUNT(1) AS records
  FROM tahoe.extension_render AS base
  WHERE extension_id IS NOT NULL AND extension_version IS NOT NULL
    AND (SELECT start_date FROM the_basetable_date)<="time" AND "time"<(SELECT end_date FROM the_basetable_date)
    AND (SELECT start_date FROM the_basetable_date)<="date" AND "date"<(SELECT end_date FROM the_basetable_date)
  GROUP BY 1,2,3
)
-- for each day and extension_id combo, get the max count of records
, extension_render_aggregate_step1 AS (
  SELECT the_day, extension_id, MAX(records) AS max_records
  FROM extension_render_aggregate_step0
  GROUP BY 1,2
)
-- for each day and extension_id, return 1 row that is the one with the most records, this will help determine what extension_version it is that day
, extension_render_aggregate_step2 AS (
  SELECT step0.the_day, step0.extension_id, step0.extension_version
  FROM extension_render_aggregate_step0 AS step0
  LEFT JOIN extension_render_aggregate_step1 AS step1
    ON step0.the_day = step1.the_day AND step0.extension_id = step1.extension_id
  WHERE step0.records = step1.max_records
)





, final_data AS (
  SELECT * FROM extension_render_aggregate_step2
)
SELECT * FROM final_data
