-- do3e1cmcmos4a17ynwdkvnf7gbqj6d
-- Sub gifting leaderboard -> look at pre and post sub numbers for streamers that activated it
-- Sub gifting leaderboard -> Look at LIRIK’s sub gifting
WITH
the_constants AS (
  SELECT '2018-07-01'::TIMESTAMP AS start_time
    , '2018-08-01'::TIMESTAMP AS end_time
    , 'do3e1cmcmos4a17ynwdkvnf7gbqj6d'::VARCHAR AS extension_id
)

, channels_with_extension AS (
  SELECT *
  FROM (
    SELECT channel_id, MIN(the_day) day_first_active
    FROM analysis.dsds_281_extension_daily_channel_presence_all_anchor
    WHERE extension_id = (SELECT extension_id FROM the_constants)
    AND bool_extension_activated IS TRUE
    GROUP BY 1
  )
  --WHERE day_first_active<(SELECT start_time FROM the_constants) AND day_first_active>=(SELECT start_time - INTERVAL '1 month' FROM the_constants)
)

, sub_gift_logs AS (
  SELECT chan.day_first_active, base."time", base.purchaser_user_id, base.recipient_user_id, base.channel_id, base.channel
    , CASE WHEN chan.day_first_active>=base."time" THEN 'gift_w_no_extension'
    ELSE 'gift_with_extension' END AS gift_status
  FROM logs.subscription_purchase_success AS base
  INNER JOIN channels_with_extension AS chan ON base.channel_id = chan.channel_id
    AND chan.day_first_active - INTERVAL '31 days'<=base."time" AND base."time"< chan.day_first_active + INTERVAL '30 days'
  WHERE base.is_gift IS TRUE
    -- AND base.channel_id = 23161357 --LIRIK
)

, final_data AS (
  SELECT channel_id, channel, gift_status, AVG(gift_subs_per_day::FLOAT) AS avg_gift_subs_per_day
  FROM (
    SELECT channel_id, channel, gift_status, DATE_TRUNC('day',"time") AS the_day, COUNT(1) AS gift_subs_per_day
    FROM sub_gift_logs
    GROUP BY 1,2,3,4
  --ORDER BY 1,2
  )
  GROUP BY 1,2,3
  ORDER BY 1,2,3
)

, the_channels_we_want AS (
  SELECT channel_id
  FROM (
    SELECT channel_id, COUNT(1) AS rows
    FROM final_data
    GROUP BY 1
  )
  WHERE rows=2
)

SELECT gift_status, AVG(gift_subs_per_day::FLOAT) AS avg_gift_subs_per_day
FROM (
SELECT channel_id, channel, gift_status, DATE_TRUNC('day',"time") AS the_day, COUNT(1) AS gift_subs_per_day
FROM sub_gift_logs
WHERE channel_id IN (SELECT channel_id FROM the_channels_we_want)
GROUP BY 1,2,3,4
)
GROUP BY 1
-- -- FOR LIRIK, 30 day pre post
-- channel_id | channel |     gift_status     | avg_gift_subs_per_day
-- ------------+---------+---------------------+-----------------------
--   23161357 | lirik   | gift_w_no_extension |                    10
--   23161357 | lirik   | gift_with_extension |      40.6333333333333



-- gift_status     | avg_gift_subs_per_day
-- ---------------------+-----------------------
-- gift_w_no_extension |      5.77374701670644
-- gift_with_extension |      5.82634435125802
