-- DROP TABLE IF EXISTS    analysis.dsds292_metric_new_net_activations;
--
-- CREATE TABLE analysis.dsds292_metric_new_net_activations AS

--
-- WITH
-- the_constants_timeframe AS (
--   SELECT '2018-08-01 00:00:00'::TIMESTAMP the_time_slot_mbr
-- )
--
-- , the_constants_mbr AS (
--   SELECT year, month, MIN(date)::TIMESTAMP AS start_time, MAX(date)::TIMESTAMP + INTERVAL '1 day' - INTERVAL '1 second' AS end_time
--   , DATEADD(month, 1, MIN(date)::TIMESTAMP) - INTERVAL '1 day' AS join_key_the_date
--   FROM metadata.date AS base
--   WHERE base.date>=(SELECT the_time_slot_mbr FROM the_constants_timeframe)
--   AND base.date<(SELECT DATEADD(month, 1, the_time_slot_mbr)  FROM the_constants_timeframe)
--   GROUP BY 1,2
-- )
--
--
--
-- , extension_daily_channel_presence_log AS (
--   SELECT *
--   , DATE_TRUNC('month', time_most_recent_activate) AS month_most_recent_activate
--   , DATE_TRUNC('month', time_most_recent_deactivate) AS month_most_recent_deactivate
--   FROM analysis.dsds_281_extension_daily_channel_presence_all_anchor
--   WHERE bool_extension_activated IS TRUE
--   AND the_day>=(SELECT DATEADD(day, -1, the_time_slot_mbr) FROM the_constants_timeframe )
--   AND the_day<(SELECT DATEADD(month, 1, the_time_slot_mbr)  FROM the_constants_timeframe)
-- )
-- , the_activate_logs AS (
--   SELECT mbr.year, mbr.month, mbr.start_time, mbr.end_time, the_log.the_day
--   , the_log.channel_id
--   , the_log.extension_id
--   , the_log.time_most_recent_activate
--   , the_log.time_most_recent_deactivate
--   , the_log.month_most_recent_activate
--   , the_log.month_most_recent_deactivate
--   , the_log.bool_extension_activated
--   FROM the_constants_mbr AS mbr
--   LEFT JOIN extension_daily_channel_presence_log AS the_log ON 1=1
-- )
--
--
--
-- , the_activate_logs_1 AS (
--   SELECT *
--   FROM the_activate_logs
--   WHERE the_day=(SELECT DATEADD(day, -1, DATEADD(month, 0, the_time_slot_mbr)) FROM the_constants_timeframe)
-- )
-- , the_activate_logs_2 AS (
--   SELECT *
--   FROM the_activate_logs
--   WHERE the_day=(SELECT DATEADD(day, -1, DATEADD(month, 1, the_time_slot_mbr)) FROM the_constants_timeframe)
-- )
--
-- -- SELECT bool_extension_activated, MIN(the_day), MAX(the_day)
-- -- , COUNT(DISTINCT channel_id) AS channels
-- -- , COUNT(DISTINCT extension_id) AS extenions
-- -- FROM the_activate_logs_2
-- -- GROUP BY 1
--
--
--
-- , full_join_logs AS (
--   SELECT
--   NVL(base1.year, base2.year) AS year
--   , NVL(base1.month, base2.month) AS month
--   , NVL(base1.start_time, base2.start_time) AS start_time
--   , NVL(base1.end_time, base2.end_time) AS end_time
--   --, NVL(base1.the_day, base2.the_day) AS the_day
--   , NVL(base1.channel_id, base2.channel_id) AS channel_id
--   , NVL(base1.extension_id, base2.extension_id) AS extension_id
--
--   , base1.extension_id AS extension_id_prev
--   , base1.channel_id AS channel_id_prev
--   -- , base1.time_most_recent_activate AS time_most_recent_activate_prev
--   -- , base1.time_most_recent_deactivate AS time_most_recent_deactivate_prev
--   -- , base1.month_most_recent_activate AS month_most_recent_activate_prev
--   -- , base1.month_most_recent_deactivate AS month_most_recent_deactivate_prev
--
--   -- , NVL(base2.start_time, ADD_MONTHS(base1.start_time, 1)) AS start_time
--   , base2.extension_id AS extension_id_now
--   , base2.channel_id AS channel_id_now
--   -- , base2.time_most_recent_activate
--   -- , base2.time_most_recent_deactivate
--   -- , base2.month_most_recent_activate
--   -- , base2.month_most_recent_deactivate
--
--   FROM the_activate_logs_1 AS base1
--   FULL OUTER JOIN the_activate_logs_2 AS base2
--     ON base1.extension_id = base2.extension_id AND base1.channel_id = base2.channel_id
--   -- ORDER BY base1.channel_id, base1.year, base1.month
-- )
--
-- , final_data AS (
--   SELECT *
--   --given a full outer join of month(t-1) with month(t) and only for bool_extension_activated==TRUE
--   , CASE
--
--   -- IF extension_id = extension_id_prev THEN 0 for new net activations (was activated previous month and still activated this month)
--   WHEN extension_id_now = extension_id_prev THEN 0
--
--   -- IF extension_id==NULL AND extension_id_prev!=NULL THEN -1 for new net activations (was activated previous month and not activated this month anymore)
--   WHEN extension_id_now IS NULL AND extension_id_prev IS NOT NULL THEN -1
--
--   -- IF extension_id!=NULL AND extension_id_prev==NULL THEN -1 for new net activations (was activated previous month and not activated this month anymore)
--   WHEN extension_id_now IS NOT NULL AND extension_id_prev IS NULL THEN 1
--
--   -- -- IF month(time_most_recent_activate) > month(start_time) THEN 999 for new net activations [this should be an unexpected side effect error]
--   -- WHEN month_most_recent_activate > start_time THEN 999
--
--   ELSE 1000 --THIS SHOULDNT HAPPEN?
--   END AS metric_new_net_activations
--   FROM full_join_logs AS base
-- )
--
SELECT * FROM analysis.dsds292_metric_new_net_activations WHERE channel_id = 155528531
ORDER BY start_time
;
