-- DROP TABLE IF EXISTS    analysis.dsds292_metric_new_net_activations_daily;
--
-- CREATE TABLE analysis.dsds292_metric_new_net_activations_daily (
--     the_day                     TIMESTAMP WITHOUT TIME ZONE sortkey
--     , channel_id                   VARCHAR distkey
--     , extension_id                 VARCHAR
--     , metric_new_net_activations   INT
--
-- );

--THEN CREATE A the_temp_table BASED ON THAT SCHEMA
CREATE TEMP TABLE the_temp_table (LIKE analysis.dsds292_metric_new_net_activations_daily);

PREPARE the_insert_function (VARCHAR) AS
INSERT INTO the_temp_table (

  WITH
  the_constants_timeframe AS (
    SELECT $1::TIMESTAMP as the_time_slot_mbr
  )

  , extension_daily_channel_presence_log AS (
      SELECT the_day, channel_id, extension_id
      FROM analysis.dsds_281_extension_daily_channel_presence_all_anchor
      WHERE bool_extension_activated IS TRUE
      AND the_day>= (select the_time_slot_mbr::date -1 FROM the_constants_timeframe )
      AND the_day<(SELECT the_time_slot_mbr::date +1  FROM the_constants_timeframe)
      -- AND channel_id = '227436643'
    )

  , the_activate_logs_1 AS (
      SELECT *
      FROM extension_daily_channel_presence_log
      WHERE the_day=(SELECT the_time_slot_mbr::date -1 FROM the_constants_timeframe)
    )

    , the_activate_logs_2 AS (
      SELECT *
      FROM extension_daily_channel_presence_log
      WHERE the_day=(SELECT the_time_slot_mbr::date FROM the_constants_timeframe)
    )

    , full_join_logs AS (
      SELECT base1.the_day as prev_day, base2.the_day as today, NVL(base2.channel_id, base1.channel_id) as channel_id
      , base1.extension_id as extension_id_prev, base2.extension_id as extension_id_now, NVL(base1.extension_id, base2.extension_id) as extension_id
      FROM the_activate_logs_1 as base1
      full outer JOIN  the_activate_logs_2 as base2
      on base1.channel_id = base2.channel_id and base1.extension_id = base2.extension_id
    )

  , final_data AS (
      SELECT case when today is null then prev_day+1 else today end as the_day, channel_id, extension_id
      --given a full outer join of month(t-1) with month(t) and only for bool_extension_activated==TRUE
      , CASE

      -- IF extension_id = extension_id_prev THEN 0 for new net activations (was activated previous month and still activated this month)
      WHEN extension_id_now = extension_id_prev THEN 0

      -- IF extension_id==NULL AND extension_id_prev!=NULL THEN -1 for new net activations (was activated previous month and not activated this month anymore)
      WHEN extension_id_now IS NULL AND extension_id_prev IS NOT NULL THEN -1

      -- IF extension_id!=NULL AND extension_id_prev==NULL THEN -1 for new net activations (was activated previous month and not activated this month anymore)
      WHEN extension_id_now IS NOT NULL AND extension_id_prev IS NULL THEN 1

      -- -- IF month(time_most_recent_activate) > month(start_time) THEN 999 for new net activations [this should be an unexpected side effect error]
      -- WHEN month_most_recent_activate > start_time THEN 999

      ELSE 1000 --THIS SHOULDNT HAPPEN?
      END AS metric_new_net_activations
      FROM full_join_logs AS base
    )
  SELECT * FROM final_data

);

PREPARE the_delete_function (VARCHAR) AS
DELETE FROM analysis.dsds292_metric_new_net_activations_daily
WHERE analysis.dsds292_metric_new_net_activations_daily.the_day = $1::TIMESTAMP::date
;

--RUN THE STUFF
-- EXECUTE the_delete_function ('2017-08-01');
-- EXECUTE the_delete_function ('2017-08-02');
-- EXECUTE the_delete_function ('2017-08-03');
-- EXECUTE the_delete_function ('2017-08-04');
-- EXECUTE the_delete_function ('2017-08-05');
-- EXECUTE the_delete_function ('2017-08-06');
-- EXECUTE the_delete_function ('2017-08-07');
-- EXECUTE the_delete_function ('2017-08-08');
-- EXECUTE the_delete_function ('2017-08-09');
-- EXECUTE the_delete_function ('2017-08-10');
-- EXECUTE the_delete_function ('2017-08-11');
-- EXECUTE the_delete_function ('2017-08-12');
-- EXECUTE the_delete_function ('2017-08-13');
-- EXECUTE the_delete_function ('2017-08-14');
-- EXECUTE the_delete_function ('2017-08-15');
-- EXECUTE the_delete_function ('2017-08-16');
-- EXECUTE the_delete_function ('2017-08-17');
-- EXECUTE the_delete_function ('2017-08-18');
-- EXECUTE the_delete_function ('2017-08-19');
-- EXECUTE the_delete_function ('2017-08-20');
-- EXECUTE the_delete_function ('2017-08-21');
-- EXECUTE the_delete_function ('2017-08-22');
-- EXECUTE the_delete_function ('2017-08-23');
-- EXECUTE the_delete_function ('2017-08-24');
-- EXECUTE the_delete_function ('2017-08-25');
-- EXECUTE the_delete_function ('2017-08-26');
-- EXECUTE the_delete_function ('2017-08-27');
-- EXECUTE the_delete_function ('2017-08-28');
-- EXECUTE the_delete_function ('2017-08-29');
-- EXECUTE the_delete_function ('2017-08-30');
-- EXECUTE the_delete_function ('2017-08-31');
--
-- EXECUTE the_delete_function ('2017-09-01');
-- EXECUTE the_delete_function ('2017-09-02');
-- EXECUTE the_delete_function ('2017-09-03');
-- EXECUTE the_delete_function ('2017-09-04');
-- EXECUTE the_delete_function ('2017-09-05');
-- EXECUTE the_delete_function ('2017-09-06');
-- EXECUTE the_delete_function ('2017-09-07');
-- EXECUTE the_delete_function ('2017-09-08');
-- EXECUTE the_delete_function ('2017-09-09');
-- EXECUTE the_delete_function ('2017-09-10');
-- EXECUTE the_delete_function ('2017-09-11');
-- EXECUTE the_delete_function ('2017-09-12');
-- EXECUTE the_delete_function ('2017-09-13');
-- EXECUTE the_delete_function ('2017-09-14');
-- EXECUTE the_delete_function ('2017-09-15');
-- EXECUTE the_delete_function ('2017-09-16');
-- EXECUTE the_delete_function ('2017-09-17');
-- EXECUTE the_delete_function ('2017-09-18');
-- EXECUTE the_delete_function ('2017-09-19');
-- EXECUTE the_delete_function ('2017-09-20');
-- EXECUTE the_delete_function ('2017-09-21');
-- EXECUTE the_delete_function ('2017-09-22');
-- EXECUTE the_delete_function ('2017-09-23');
-- EXECUTE the_delete_function ('2017-09-24');
-- EXECUTE the_delete_function ('2017-09-25');
-- EXECUTE the_delete_function ('2017-09-26');
-- EXECUTE the_delete_function ('2017-09-27');
-- EXECUTE the_delete_function ('2017-09-28');
-- EXECUTE the_delete_function ('2017-09-29');
-- EXECUTE the_delete_function ('2017-09-30');
--
-- EXECUTE the_delete_function ('2017-10-01');
-- EXECUTE the_delete_function ('2017-10-02');
-- EXECUTE the_delete_function ('2017-10-03');
-- EXECUTE the_delete_function ('2017-10-04');
-- EXECUTE the_delete_function ('2017-10-05');
-- EXECUTE the_delete_function ('2017-10-06');
-- EXECUTE the_delete_function ('2017-10-07');
-- EXECUTE the_delete_function ('2017-10-08');
-- EXECUTE the_delete_function ('2017-10-09');
-- EXECUTE the_delete_function ('2017-10-10');
-- EXECUTE the_delete_function ('2017-10-11');
-- EXECUTE the_delete_function ('2017-10-12');
-- EXECUTE the_delete_function ('2017-10-13');
-- EXECUTE the_delete_function ('2017-10-14');
-- EXECUTE the_delete_function ('2017-10-15');
-- EXECUTE the_delete_function ('2017-10-16');
-- EXECUTE the_delete_function ('2017-10-17');
-- EXECUTE the_delete_function ('2017-10-18');
-- EXECUTE the_delete_function ('2017-10-19');
-- EXECUTE the_delete_function ('2017-10-20');
-- EXECUTE the_delete_function ('2017-10-21');
-- EXECUTE the_delete_function ('2017-10-22');
-- EXECUTE the_delete_function ('2017-10-23');
-- EXECUTE the_delete_function ('2017-10-24');
-- EXECUTE the_delete_function ('2017-10-25');
-- EXECUTE the_delete_function ('2017-10-26');
-- EXECUTE the_delete_function ('2017-10-27');
-- EXECUTE the_delete_function ('2017-10-28');
-- EXECUTE the_delete_function ('2017-10-29');
-- EXECUTE the_delete_function ('2017-10-30');
-- EXECUTE the_delete_function ('2017-10-31');
--
-- EXECUTE the_delete_function ('2017-11-01');
-- EXECUTE the_delete_function ('2017-11-02');
-- EXECUTE the_delete_function ('2017-11-03');
-- EXECUTE the_delete_function ('2017-11-04');
-- EXECUTE the_delete_function ('2017-11-05');
-- EXECUTE the_delete_function ('2017-11-06');
-- EXECUTE the_delete_function ('2017-11-07');
-- EXECUTE the_delete_function ('2017-11-08');
-- EXECUTE the_delete_function ('2017-11-09');
-- EXECUTE the_delete_function ('2017-11-10');
-- EXECUTE the_delete_function ('2017-11-11');
-- EXECUTE the_delete_function ('2017-11-12');
-- EXECUTE the_delete_function ('2017-11-13');
-- EXECUTE the_delete_function ('2017-11-14');
-- EXECUTE the_delete_function ('2017-11-15');
-- EXECUTE the_delete_function ('2017-11-16');
-- EXECUTE the_delete_function ('2017-11-17');
-- EXECUTE the_delete_function ('2017-11-18');
-- EXECUTE the_delete_function ('2017-11-19');
-- EXECUTE the_delete_function ('2017-11-20');
-- EXECUTE the_delete_function ('2017-11-21');
-- EXECUTE the_delete_function ('2017-11-22');
-- EXECUTE the_delete_function ('2017-11-23');
-- EXECUTE the_delete_function ('2017-11-24');
-- EXECUTE the_delete_function ('2017-11-25');
-- EXECUTE the_delete_function ('2017-11-26');
-- EXECUTE the_delete_function ('2017-11-27');
-- EXECUTE the_delete_function ('2017-11-28');
-- EXECUTE the_delete_function ('2017-11-29');
-- EXECUTE the_delete_function ('2017-11-30');
--
-- EXECUTE the_delete_function ('2017-12-01');
-- EXECUTE the_delete_function ('2017-12-02');
-- EXECUTE the_delete_function ('2017-12-03');
-- EXECUTE the_delete_function ('2017-12-04');
-- EXECUTE the_delete_function ('2017-12-05');
-- EXECUTE the_delete_function ('2017-12-06');
-- EXECUTE the_delete_function ('2017-12-07');
-- EXECUTE the_delete_function ('2017-12-08');
-- EXECUTE the_delete_function ('2017-12-09');
-- EXECUTE the_delete_function ('2017-12-10');
-- EXECUTE the_delete_function ('2017-12-11');
-- EXECUTE the_delete_function ('2017-12-12');
-- EXECUTE the_delete_function ('2017-12-13');
-- EXECUTE the_delete_function ('2017-12-14');
-- EXECUTE the_delete_function ('2017-12-15');
-- EXECUTE the_delete_function ('2017-12-16');
-- EXECUTE the_delete_function ('2017-12-17');
-- EXECUTE the_delete_function ('2017-12-18');
-- EXECUTE the_delete_function ('2017-12-19');
-- EXECUTE the_delete_function ('2017-12-20');
-- EXECUTE the_delete_function ('2017-12-21');
-- EXECUTE the_delete_function ('2017-12-22');
-- EXECUTE the_delete_function ('2017-12-23');
-- EXECUTE the_delete_function ('2017-12-24');
-- EXECUTE the_delete_function ('2017-12-25');
-- EXECUTE the_delete_function ('2017-12-26');
-- EXECUTE the_delete_function ('2017-12-27');
-- EXECUTE the_delete_function ('2017-12-28');
-- EXECUTE the_delete_function ('2017-12-29');
-- EXECUTE the_delete_function ('2017-12-30');
-- EXECUTE the_delete_function ('2017-12-31');
-- --
-- EXECUTE the_delete_function ('2018-01-01');
-- EXECUTE the_delete_function ('2018-01-02');
-- EXECUTE the_delete_function ('2018-01-03');
-- EXECUTE the_delete_function ('2018-01-04');
-- EXECUTE the_delete_function ('2018-01-05');
-- EXECUTE the_delete_function ('2018-01-06');
-- EXECUTE the_delete_function ('2018-01-07');
-- EXECUTE the_delete_function ('2018-01-08');
-- EXECUTE the_delete_function ('2018-01-09');
-- EXECUTE the_delete_function ('2018-01-10');
-- EXECUTE the_delete_function ('2018-01-11');
-- EXECUTE the_delete_function ('2018-01-12');
-- EXECUTE the_delete_function ('2018-01-13');
-- EXECUTE the_delete_function ('2018-01-14');
-- EXECUTE the_delete_function ('2018-01-15');
-- EXECUTE the_delete_function ('2018-01-16');
-- EXECUTE the_delete_function ('2018-01-17');
-- EXECUTE the_delete_function ('2018-01-18');
-- EXECUTE the_delete_function ('2018-01-19');
-- EXECUTE the_delete_function ('2018-01-20');
-- EXECUTE the_delete_function ('2018-01-21');
-- EXECUTE the_delete_function ('2018-01-22');
-- EXECUTE the_delete_function ('2018-01-23');
-- EXECUTE the_delete_function ('2018-01-24');
-- EXECUTE the_delete_function ('2018-01-25');
-- EXECUTE the_delete_function ('2018-01-26');
-- EXECUTE the_delete_function ('2018-01-27');
-- EXECUTE the_delete_function ('2018-01-28');
-- EXECUTE the_delete_function ('2018-01-29');
-- EXECUTE the_delete_function ('2018-01-30');
-- EXECUTE the_delete_function ('2018-01-31');
--
--
--
-- EXECUTE the_delete_function ('2018-02-01');
-- EXECUTE the_delete_function ('2018-02-02');
-- EXECUTE the_delete_function ('2018-02-03');
-- EXECUTE the_delete_function ('2018-02-04');
-- EXECUTE the_delete_function ('2018-02-05');
-- EXECUTE the_delete_function ('2018-02-06');
-- EXECUTE the_delete_function ('2018-02-07');
-- EXECUTE the_delete_function ('2018-02-08');
-- EXECUTE the_delete_function ('2018-02-09');
-- EXECUTE the_delete_function ('2018-02-10');
-- EXECUTE the_delete_function ('2018-02-11');
-- EXECUTE the_delete_function ('2018-02-12');
-- EXECUTE the_delete_function ('2018-02-13');
-- EXECUTE the_delete_function ('2018-02-14');
-- EXECUTE the_delete_function ('2018-02-15');
-- EXECUTE the_delete_function ('2018-02-16');
-- EXECUTE the_delete_function ('2018-02-17');
-- EXECUTE the_delete_function ('2018-02-18');
-- EXECUTE the_delete_function ('2018-02-19');
-- EXECUTE the_delete_function ('2018-02-20');
-- EXECUTE the_delete_function ('2018-02-21');
-- EXECUTE the_delete_function ('2018-02-22');
-- EXECUTE the_delete_function ('2018-02-23');
-- EXECUTE the_delete_function ('2018-02-24');
-- EXECUTE the_delete_function ('2018-02-25');
-- EXECUTE the_delete_function ('2018-02-26');
-- EXECUTE the_delete_function ('2018-02-27');
-- EXECUTE the_delete_function ('2018-02-28');
--
-- EXECUTE the_delete_function ('2018-03-01');
-- EXECUTE the_delete_function ('2018-03-02');
-- EXECUTE the_delete_function ('2018-03-03');
-- EXECUTE the_delete_function ('2018-03-04');
-- EXECUTE the_delete_function ('2018-03-05');
-- EXECUTE the_delete_function ('2018-03-06');
-- EXECUTE the_delete_function ('2018-03-07');
-- EXECUTE the_delete_function ('2018-03-08');
-- EXECUTE the_delete_function ('2018-03-09');
-- EXECUTE the_delete_function ('2018-03-10');
-- EXECUTE the_delete_function ('2018-03-11');
-- EXECUTE the_delete_function ('2018-03-12');
-- EXECUTE the_delete_function ('2018-03-13');
-- EXECUTE the_delete_function ('2018-03-14');
-- EXECUTE the_delete_function ('2018-03-15');
-- EXECUTE the_delete_function ('2018-03-16');
-- EXECUTE the_delete_function ('2018-03-17');
-- EXECUTE the_delete_function ('2018-03-18');
-- EXECUTE the_delete_function ('2018-03-19');
-- EXECUTE the_delete_function ('2018-03-20');
-- EXECUTE the_delete_function ('2018-03-21');
-- EXECUTE the_delete_function ('2018-03-22');
-- EXECUTE the_delete_function ('2018-03-23');
-- EXECUTE the_delete_function ('2018-03-24');
-- EXECUTE the_delete_function ('2018-03-25');
-- EXECUTE the_delete_function ('2018-03-26');
-- EXECUTE the_delete_function ('2018-03-27');
-- EXECUTE the_delete_function ('2018-03-28');
-- EXECUTE the_delete_function ('2018-03-29');
-- EXECUTE the_delete_function ('2018-03-30');
-- EXECUTE the_delete_function ('2018-03-31');
--
-- EXECUTE the_delete_function ('2018-04-01');
-- EXECUTE the_delete_function ('2018-04-02');
-- EXECUTE the_delete_function ('2018-04-03');
-- EXECUTE the_delete_function ('2018-04-04');
-- EXECUTE the_delete_function ('2018-04-05');
-- EXECUTE the_delete_function ('2018-04-06');
-- EXECUTE the_delete_function ('2018-04-07');
-- EXECUTE the_delete_function ('2018-04-08');
-- EXECUTE the_delete_function ('2018-04-09');
-- EXECUTE the_delete_function ('2018-04-10');
-- EXECUTE the_delete_function ('2018-04-11');
-- EXECUTE the_delete_function ('2018-04-12');
-- EXECUTE the_delete_function ('2018-04-13');
-- EXECUTE the_delete_function ('2018-04-14');
-- EXECUTE the_delete_function ('2018-04-15');
-- EXECUTE the_delete_function ('2018-04-16');
-- EXECUTE the_delete_function ('2018-04-17');
-- EXECUTE the_delete_function ('2018-04-18');
-- EXECUTE the_delete_function ('2018-04-19');
-- EXECUTE the_delete_function ('2018-04-20');
-- EXECUTE the_delete_function ('2018-04-21');
-- EXECUTE the_delete_function ('2018-04-22');
-- EXECUTE the_delete_function ('2018-04-23');
-- EXECUTE the_delete_function ('2018-04-24');
-- EXECUTE the_delete_function ('2018-04-25');
-- EXECUTE the_delete_function ('2018-04-26');
-- EXECUTE the_delete_function ('2018-04-27');
-- EXECUTE the_delete_function ('2018-04-28');
-- EXECUTE the_delete_function ('2018-04-29');
-- EXECUTE the_delete_function ('2018-04-30');
--
-- EXECUTE the_delete_function ('2018-05-01');
-- EXECUTE the_delete_function ('2018-05-02');
-- EXECUTE the_delete_function ('2018-05-03');
-- EXECUTE the_delete_function ('2018-05-04');
-- EXECUTE the_delete_function ('2018-05-05');
-- EXECUTE the_delete_function ('2018-05-06');
-- EXECUTE the_delete_function ('2018-05-07');
-- EXECUTE the_delete_function ('2018-05-08');
-- EXECUTE the_delete_function ('2018-05-09');
-- EXECUTE the_delete_function ('2018-05-10');
-- EXECUTE the_delete_function ('2018-05-11');
-- EXECUTE the_delete_function ('2018-05-12');
-- EXECUTE the_delete_function ('2018-05-13');
-- EXECUTE the_delete_function ('2018-05-14');
-- EXECUTE the_delete_function ('2018-05-15');
-- EXECUTE the_delete_function ('2018-05-16');
-- EXECUTE the_delete_function ('2018-05-17');
-- EXECUTE the_delete_function ('2018-05-18');
-- EXECUTE the_delete_function ('2018-05-19');
-- EXECUTE the_delete_function ('2018-05-20');
-- EXECUTE the_delete_function ('2018-05-21');
-- EXECUTE the_delete_function ('2018-05-22');
-- EXECUTE the_delete_function ('2018-05-23');
-- EXECUTE the_delete_function ('2018-05-24');
-- EXECUTE the_delete_function ('2018-05-25');
-- EXECUTE the_delete_function ('2018-05-26');
-- EXECUTE the_delete_function ('2018-05-27');
-- EXECUTE the_delete_function ('2018-05-28');
-- EXECUTE the_delete_function ('2018-05-29');
-- EXECUTE the_delete_function ('2018-05-30');
-- EXECUTE the_delete_function ('2018-05-31');
--
-- EXECUTE the_delete_function ('2018-06-01');
-- EXECUTE the_delete_function ('2018-06-02');
-- EXECUTE the_delete_function ('2018-06-03');
-- EXECUTE the_delete_function ('2018-06-04');
-- EXECUTE the_delete_function ('2018-06-05');
-- EXECUTE the_delete_function ('2018-06-06');
-- EXECUTE the_delete_function ('2018-06-07');
-- EXECUTE the_delete_function ('2018-06-08');
-- EXECUTE the_delete_function ('2018-06-09');
-- EXECUTE the_delete_function ('2018-06-10');
-- EXECUTE the_delete_function ('2018-06-11');
-- EXECUTE the_delete_function ('2018-06-12');
-- EXECUTE the_delete_function ('2018-06-13');
-- EXECUTE the_delete_function ('2018-06-14');
-- EXECUTE the_delete_function ('2018-06-15');
-- EXECUTE the_delete_function ('2018-06-16');
-- EXECUTE the_delete_function ('2018-06-17');
-- EXECUTE the_delete_function ('2018-06-18');
-- EXECUTE the_delete_function ('2018-06-19');
-- EXECUTE the_delete_function ('2018-06-20');
-- EXECUTE the_delete_function ('2018-06-21');
-- EXECUTE the_delete_function ('2018-06-22');
-- EXECUTE the_delete_function ('2018-06-23');
-- EXECUTE the_delete_function ('2018-06-24');
-- EXECUTE the_delete_function ('2018-06-25');
-- EXECUTE the_delete_function ('2018-06-26');
-- EXECUTE the_delete_function ('2018-06-27');
-- EXECUTE the_delete_function ('2018-06-28');
-- EXECUTE the_delete_function ('2018-06-29');
-- EXECUTE the_delete_function ('2018-06-30');
--
-- EXECUTE the_delete_function ('2018-07-01');
-- EXECUTE the_delete_function ('2018-07-02');
-- EXECUTE the_delete_function ('2018-07-03');
-- EXECUTE the_delete_function ('2018-07-04');
-- EXECUTE the_delete_function ('2018-07-05');
-- EXECUTE the_delete_function ('2018-07-06');
-- EXECUTE the_delete_function ('2018-07-07');
-- EXECUTE the_delete_function ('2018-07-08');
-- EXECUTE the_delete_function ('2018-07-09');
-- EXECUTE the_delete_function ('2018-07-10');
-- EXECUTE the_delete_function ('2018-07-11');
-- EXECUTE the_delete_function ('2018-07-12');
-- EXECUTE the_delete_function ('2018-07-13');
-- EXECUTE the_delete_function ('2018-07-14');
-- EXECUTE the_delete_function ('2018-07-15');
-- EXECUTE the_delete_function ('2018-07-16');
-- EXECUTE the_delete_function ('2018-07-17');
-- EXECUTE the_delete_function ('2018-07-18');
-- EXECUTE the_delete_function ('2018-07-19');
-- EXECUTE the_delete_function ('2018-07-20');
-- EXECUTE the_delete_function ('2018-07-21');
-- EXECUTE the_delete_function ('2018-07-22');
-- EXECUTE the_delete_function ('2018-07-23');
-- EXECUTE the_delete_function ('2018-07-24');
-- EXECUTE the_delete_function ('2018-07-25');
-- EXECUTE the_delete_function ('2018-07-26');
-- EXECUTE the_delete_function ('2018-07-27');
-- EXECUTE the_delete_function ('2018-07-28');
-- EXECUTE the_delete_function ('2018-07-29');
-- EXECUTE the_delete_function ('2018-07-30');
-- EXECUTE the_delete_function ('2018-07-31');
-- --
-- EXECUTE the_delete_function ('2018-08-01');
-- EXECUTE the_delete_function ('2018-08-02');
-- EXECUTE the_delete_function ('2018-08-03');
-- EXECUTE the_delete_function ('2018-08-04');
-- EXECUTE the_delete_function ('2018-08-05');
-- EXECUTE the_delete_function ('2018-08-06');
-- EXECUTE the_delete_function ('2018-08-07');
-- EXECUTE the_delete_function ('2018-08-08');
-- EXECUTE the_delete_function ('2018-08-09');
-- EXECUTE the_delete_function ('2018-08-10');
-- EXECUTE the_delete_function ('2018-08-11');
-- EXECUTE the_delete_function ('2018-08-12');
-- EXECUTE the_delete_function ('2018-08-13');
-- EXECUTE the_delete_function ('2018-08-14');
-- EXECUTE the_delete_function ('2018-08-15');
-- EXECUTE the_delete_function ('2018-08-16');
-- EXECUTE the_delete_function ('2018-08-17');
-- EXECUTE the_delete_function ('2018-08-18');
-- EXECUTE the_delete_function ('2018-08-19');
-- EXECUTE the_delete_function ('2018-08-20');
-- EXECUTE the_delete_function ('2018-08-21');
-- EXECUTE the_delete_function ('2018-08-22');
-- EXECUTE the_delete_function ('2018-08-23');
-- EXECUTE the_delete_function ('2018-08-24');
-- EXECUTE the_delete_function ('2018-08-25');
-- EXECUTE the_delete_function ('2018-08-26');
-- EXECUTE the_delete_function ('2018-08-27');
-- EXECUTE the_delete_function ('2018-08-28');
-- EXECUTE the_delete_function ('2018-08-29');
-- EXECUTE the_delete_function ('2018-08-30');
-- EXECUTE the_delete_function ('2018-08-31');
--
-- EXECUTE the_delete_function ('2018-09-01');
-- EXECUTE the_delete_function ('2018-09-02');
-- EXECUTE the_delete_function ('2018-09-03');
-- EXECUTE the_delete_function ('2018-09-04');
-- EXECUTE the_delete_function ('2018-09-05');
-- EXECUTE the_delete_function ('2018-09-06');
-- EXECUTE the_delete_function ('2018-09-07');
-- EXECUTE the_delete_function ('2018-09-08');
-- EXECUTE the_delete_function ('2018-09-09');
-- EXECUTE the_delete_function ('2018-09-10');
-- EXECUTE the_delete_function ('2018-09-11');
-- EXECUTE the_delete_function ('2018-09-12');
-- EXECUTE the_delete_function ('2018-09-13');
-- EXECUTE the_delete_function ('2018-09-14');
-- EXECUTE the_delete_function ('2018-09-15');
-- EXECUTE the_delete_function ('2018-09-16');
-- EXECUTE the_delete_function ('2018-09-17');
-- EXECUTE the_delete_function ('2018-09-18');
-- EXECUTE the_delete_function ('2018-09-19');
-- EXECUTE the_delete_function ('2018-09-20');
-- EXECUTE the_delete_function ('2018-09-21');
-- EXECUTE the_delete_function ('2018-09-22');
-- EXECUTE the_delete_function ('2018-09-23');
-- EXECUTE the_delete_function ('2018-09-24');
-- EXECUTE the_delete_function ('2018-09-25');
-- EXECUTE the_delete_function ('2018-09-26');
-- EXECUTE the_delete_function ('2018-09-27');
-- EXECUTE the_delete_function ('2018-09-28');
-- EXECUTE the_delete_function ('2018-09-29');
-- EXECUTE the_delete_function ('2018-09-30');
--
-- EXECUTE the_delete_function ('2018-10-01');
-- EXECUTE the_delete_function ('2018-10-02');
-- EXECUTE the_delete_function ('2018-10-03');
-- EXECUTE the_delete_function ('2018-10-04');
-- EXECUTE the_delete_function ('2018-10-05');
-- EXECUTE the_delete_function ('2018-10-06');
-- EXECUTE the_delete_function ('2018-10-07');
-- EXECUTE the_delete_function ('2018-10-08');
-- EXECUTE the_delete_function ('2018-10-09');
-- EXECUTE the_delete_function ('2018-10-10');
-- EXECUTE the_delete_function ('2018-10-11');
-- EXECUTE the_delete_function ('2018-10-12');
-- EXECUTE the_delete_function ('2018-10-13');
-- EXECUTE the_delete_function ('2018-10-14');
-- EXECUTE the_delete_function ('2018-10-15');
-- EXECUTE the_delete_function ('2018-10-16');
-- EXECUTE the_delete_function ('2018-10-17');
-- EXECUTE the_delete_function ('2018-10-18');
-- EXECUTE the_delete_function ('2018-10-19');
-- EXECUTE the_delete_function ('2018-10-20');
-- EXECUTE the_delete_function ('2018-10-21');
-- EXECUTE the_delete_function ('2018-10-22');
-- EXECUTE the_delete_function ('2018-10-23');
-- EXECUTE the_delete_function ('2018-10-24');
-- EXECUTE the_delete_function ('2018-10-25');
-- EXECUTE the_delete_function ('2018-10-26');
-- EXECUTE the_delete_function ('2018-10-27');
-- EXECUTE the_delete_function ('2018-10-28');
-- EXECUTE the_delete_function ('2018-10-29');
-- EXECUTE the_delete_function ('2018-10-30');
-- EXECUTE the_delete_function ('2018-10-31');
--
-- EXECUTE the_delete_function ('2018-11-01');
-- EXECUTE the_delete_function ('2018-11-02');
-- EXECUTE the_delete_function ('2018-11-03');
-- EXECUTE the_delete_function ('2018-11-04');
-- EXECUTE the_delete_function ('2018-11-05');
-- EXECUTE the_delete_function ('2018-11-06');
-- EXECUTE the_delete_function ('2018-11-07');
-- EXECUTE the_delete_function ('2018-11-08');
-- EXECUTE the_delete_function ('2018-11-09');
-- EXECUTE the_delete_function ('2018-11-10');
-- EXECUTE the_delete_function ('2018-11-11');
-- EXECUTE the_delete_function ('2018-11-12');
-- EXECUTE the_delete_function ('2018-11-13');
-- EXECUTE the_delete_function ('2018-11-14');
-- EXECUTE the_delete_function ('2018-11-15');
-- EXECUTE the_delete_function ('2018-11-16');
-- EXECUTE the_delete_function ('2018-11-17');
-- EXECUTE the_delete_function ('2018-11-18');
-- EXECUTE the_delete_function ('2018-11-19');
-- EXECUTE the_delete_function ('2018-11-20');
-- EXECUTE the_delete_function ('2018-11-21');
-- EXECUTE the_delete_function ('2018-11-22');
-- EXECUTE the_delete_function ('2018-11-23');
-- EXECUTE the_delete_function ('2018-11-24');
-- EXECUTE the_delete_function ('2018-11-25');
-- EXECUTE the_delete_function ('2018-11-26');

EXECUTE the_delete_function ('2018-01-18');
EXECUTE the_delete_function ('2018-01-19');
EXECUTE the_delete_function ('2018-01-20');
EXECUTE the_delete_function ('2018-01-21');
EXECUTE the_delete_function ('2018-01-22');


-- EXECUTE the_insert_function ('2017-08-01');
-- EXECUTE the_insert_function ('2017-08-02');
-- EXECUTE the_insert_function ('2017-08-03');
-- EXECUTE the_insert_function ('2017-08-04');
-- EXECUTE the_insert_function ('2017-08-05');
-- EXECUTE the_insert_function ('2017-08-06');
-- EXECUTE the_insert_function ('2017-08-07');
-- EXECUTE the_insert_function ('2017-08-08');
-- EXECUTE the_insert_function ('2017-08-09');
-- EXECUTE the_insert_function ('2017-08-10');
-- EXECUTE the_insert_function ('2017-08-11');
-- EXECUTE the_insert_function ('2017-08-12');
-- EXECUTE the_insert_function ('2017-08-13');
-- EXECUTE the_insert_function ('2017-08-14');
-- EXECUTE the_insert_function ('2017-08-15');
-- EXECUTE the_insert_function ('2017-08-16');
-- EXECUTE the_insert_function ('2017-08-17');
-- EXECUTE the_insert_function ('2017-08-18');
-- EXECUTE the_insert_function ('2017-08-19');
-- EXECUTE the_insert_function ('2017-08-20');
-- EXECUTE the_insert_function ('2017-08-21');
-- EXECUTE the_insert_function ('2017-08-22');
-- EXECUTE the_insert_function ('2017-08-23');
-- EXECUTE the_insert_function ('2017-08-24');
-- EXECUTE the_insert_function ('2017-08-25');
-- EXECUTE the_insert_function ('2017-08-26');
-- EXECUTE the_insert_function ('2017-08-27');
-- EXECUTE the_insert_function ('2017-08-28');
-- EXECUTE the_insert_function ('2017-08-29');
-- EXECUTE the_insert_function ('2017-08-30');
-- EXECUTE the_insert_function ('2017-08-31');

-- EXECUTE the_insert_function ('2017-09-01');
-- EXECUTE the_insert_function ('2017-09-02');
-- EXECUTE the_insert_function ('2017-09-03');
-- EXECUTE the_insert_function ('2017-09-04');
-- EXECUTE the_insert_function ('2017-09-05');
-- EXECUTE the_insert_function ('2017-09-06');
-- EXECUTE the_insert_function ('2017-09-07');
-- EXECUTE the_insert_function ('2017-09-08');
-- EXECUTE the_insert_function ('2017-09-09');
-- EXECUTE the_insert_function ('2017-09-10');
-- EXECUTE the_insert_function ('2017-09-11');
-- EXECUTE the_insert_function ('2017-09-12');
-- EXECUTE the_insert_function ('2017-09-13');
-- EXECUTE the_insert_function ('2017-09-14');
-- EXECUTE the_insert_function ('2017-09-15');
-- EXECUTE the_insert_function ('2017-09-16');
-- EXECUTE the_insert_function ('2017-09-17');
-- EXECUTE the_insert_function ('2017-09-18');
-- EXECUTE the_insert_function ('2017-09-19');
-- EXECUTE the_insert_function ('2017-09-20');
-- EXECUTE the_insert_function ('2017-09-21');
-- EXECUTE the_insert_function ('2017-09-22');
-- EXECUTE the_insert_function ('2017-09-23');
-- EXECUTE the_insert_function ('2017-09-24');
-- EXECUTE the_insert_function ('2017-09-25');
-- EXECUTE the_insert_function ('2017-09-26');
-- EXECUTE the_insert_function ('2017-09-27');
-- EXECUTE the_insert_function ('2017-09-28');
-- EXECUTE the_insert_function ('2017-09-29');
-- EXECUTE the_insert_function ('2017-09-30');
--
-- EXECUTE the_insert_function ('2017-10-01');
-- EXECUTE the_insert_function ('2017-10-02');
-- EXECUTE the_insert_function ('2017-10-03');
-- EXECUTE the_insert_function ('2017-10-04');
-- EXECUTE the_insert_function ('2017-10-05');
-- EXECUTE the_insert_function ('2017-10-06');
-- EXECUTE the_insert_function ('2017-10-07');
-- EXECUTE the_insert_function ('2017-10-08');
-- EXECUTE the_insert_function ('2017-10-09');
-- EXECUTE the_insert_function ('2017-10-10');
-- EXECUTE the_insert_function ('2017-10-11');
-- EXECUTE the_insert_function ('2017-10-12');
-- EXECUTE the_insert_function ('2017-10-13');
-- EXECUTE the_insert_function ('2017-10-14');
-- EXECUTE the_insert_function ('2017-10-15');
-- EXECUTE the_insert_function ('2017-10-16');
-- EXECUTE the_insert_function ('2017-10-17');
-- EXECUTE the_insert_function ('2017-10-18');
-- EXECUTE the_insert_function ('2017-10-19');
-- EXECUTE the_insert_function ('2017-10-20');
-- EXECUTE the_insert_function ('2017-10-21');
-- EXECUTE the_insert_function ('2017-10-22');
-- EXECUTE the_insert_function ('2017-10-23');
-- EXECUTE the_insert_function ('2017-10-24');
-- EXECUTE the_insert_function ('2017-10-25');
-- EXECUTE the_insert_function ('2017-10-26');
-- EXECUTE the_insert_function ('2017-10-27');
-- EXECUTE the_insert_function ('2017-10-28');
-- EXECUTE the_insert_function ('2017-10-29');
-- EXECUTE the_insert_function ('2017-10-30');
-- EXECUTE the_insert_function ('2017-10-31');
--
-- EXECUTE the_insert_function ('2017-11-01');
-- EXECUTE the_insert_function ('2017-11-02');
-- EXECUTE the_insert_function ('2017-11-03');
-- EXECUTE the_insert_function ('2017-11-04');
-- EXECUTE the_insert_function ('2017-11-05');
-- EXECUTE the_insert_function ('2017-11-06');
-- EXECUTE the_insert_function ('2017-11-07');
-- EXECUTE the_insert_function ('2017-11-08');
-- EXECUTE the_insert_function ('2017-11-09');
-- EXECUTE the_insert_function ('2017-11-10');
-- EXECUTE the_insert_function ('2017-11-11');
-- EXECUTE the_insert_function ('2017-11-12');
-- EXECUTE the_insert_function ('2017-11-13');
-- EXECUTE the_insert_function ('2017-11-14');
-- EXECUTE the_insert_function ('2017-11-15');
-- EXECUTE the_insert_function ('2017-11-16');
-- EXECUTE the_insert_function ('2017-11-17');
-- EXECUTE the_insert_function ('2017-11-18');
-- EXECUTE the_insert_function ('2017-11-19');
-- EXECUTE the_insert_function ('2017-11-20');
-- EXECUTE the_insert_function ('2017-11-21');
-- EXECUTE the_insert_function ('2017-11-22');
-- EXECUTE the_insert_function ('2017-11-23');
-- EXECUTE the_insert_function ('2017-11-24');
-- EXECUTE the_insert_function ('2017-11-25');
-- EXECUTE the_insert_function ('2017-11-26');
-- EXECUTE the_insert_function ('2017-11-27');
-- EXECUTE the_insert_function ('2017-11-28');
-- EXECUTE the_insert_function ('2017-11-29');
-- EXECUTE the_insert_function ('2017-11-30');
--
-- EXECUTE the_insert_function ('2017-12-01');
-- EXECUTE the_insert_function ('2017-12-02');
-- EXECUTE the_insert_function ('2017-12-03');
-- EXECUTE the_insert_function ('2017-12-04');
-- EXECUTE the_insert_function ('2017-12-05');
-- EXECUTE the_insert_function ('2017-12-06');
-- EXECUTE the_insert_function ('2017-12-07');
-- EXECUTE the_insert_function ('2017-12-08');
-- EXECUTE the_insert_function ('2017-12-09');
-- EXECUTE the_insert_function ('2017-12-10');
-- EXECUTE the_insert_function ('2017-12-11');
-- EXECUTE the_insert_function ('2017-12-12');
-- EXECUTE the_insert_function ('2017-12-13');
-- EXECUTE the_insert_function ('2017-12-14');
-- EXECUTE the_insert_function ('2017-12-15');
-- EXECUTE the_insert_function ('2017-12-16');
-- EXECUTE the_insert_function ('2017-12-17');
-- EXECUTE the_insert_function ('2017-12-18');
-- EXECUTE the_insert_function ('2017-12-19');
-- EXECUTE the_insert_function ('2017-12-20');
-- EXECUTE the_insert_function ('2017-12-21');
-- EXECUTE the_insert_function ('2017-12-22');
-- EXECUTE the_insert_function ('2017-12-23');
-- EXECUTE the_insert_function ('2017-12-24');
-- EXECUTE the_insert_function ('2017-12-25');
-- EXECUTE the_insert_function ('2017-12-26');
-- EXECUTE the_insert_function ('2017-12-27');
-- EXECUTE the_insert_function ('2017-12-28');
-- EXECUTE the_insert_function ('2017-12-29');
-- EXECUTE the_insert_function ('2017-12-30');
-- EXECUTE the_insert_function ('2017-12-31');
--
-- EXECUTE the_insert_function ('2018-01-01');
-- EXECUTE the_insert_function ('2018-01-02');
-- EXECUTE the_insert_function ('2018-01-03');
-- EXECUTE the_insert_function ('2018-01-04');
-- EXECUTE the_insert_function ('2018-01-05');
-- EXECUTE the_insert_function ('2018-01-06');
-- EXECUTE the_insert_function ('2018-01-07');
-- EXECUTE the_insert_function ('2018-01-08');
-- EXECUTE the_insert_function ('2018-01-09');
-- EXECUTE the_insert_function ('2018-01-10');
-- EXECUTE the_insert_function ('2018-01-11');
-- EXECUTE the_insert_function ('2018-01-12');
-- EXECUTE the_insert_function ('2018-01-13');
-- EXECUTE the_insert_function ('2018-01-14');
-- EXECUTE the_insert_function ('2018-01-15');
-- EXECUTE the_insert_function ('2018-01-16');
-- EXECUTE the_insert_function ('2018-01-17');
-- EXECUTE the_insert_function ('2018-01-18');
-- EXECUTE the_insert_function ('2018-01-19');
-- EXECUTE the_insert_function ('2018-01-20');
-- EXECUTE the_insert_function ('2018-01-21');
-- EXECUTE the_insert_function ('2018-01-22');
-- EXECUTE the_insert_function ('2018-01-23');
-- EXECUTE the_insert_function ('2018-01-24');
-- EXECUTE the_insert_function ('2018-01-25');
-- EXECUTE the_insert_function ('2018-01-26');
-- EXECUTE the_insert_function ('2018-01-27');
-- EXECUTE the_insert_function ('2018-01-28');
-- EXECUTE the_insert_function ('2018-01-29');
-- EXECUTE the_insert_function ('2018-01-30');
-- EXECUTE the_insert_function ('2018-01-31');
--
--
--
-- EXECUTE the_insert_function ('2018-02-01');
-- EXECUTE the_insert_function ('2018-02-02');
-- EXECUTE the_insert_function ('2018-02-03');
-- EXECUTE the_insert_function ('2018-02-04');
-- EXECUTE the_insert_function ('2018-02-05');
-- EXECUTE the_insert_function ('2018-02-06');
-- EXECUTE the_insert_function ('2018-02-07');
-- EXECUTE the_insert_function ('2018-02-08');
-- EXECUTE the_insert_function ('2018-02-09');
-- EXECUTE the_insert_function ('2018-02-10');
-- EXECUTE the_insert_function ('2018-02-11');
-- EXECUTE the_insert_function ('2018-02-12');
-- EXECUTE the_insert_function ('2018-02-13');
-- EXECUTE the_insert_function ('2018-02-14');
-- EXECUTE the_insert_function ('2018-02-15');
-- EXECUTE the_insert_function ('2018-02-16');
-- EXECUTE the_insert_function ('2018-02-17');
-- EXECUTE the_insert_function ('2018-02-18');
-- EXECUTE the_insert_function ('2018-02-19');
-- EXECUTE the_insert_function ('2018-02-20');
-- EXECUTE the_insert_function ('2018-02-21');
-- EXECUTE the_insert_function ('2018-02-22');
-- EXECUTE the_insert_function ('2018-02-23');
-- EXECUTE the_insert_function ('2018-02-24');
-- EXECUTE the_insert_function ('2018-02-25');
-- EXECUTE the_insert_function ('2018-02-26');
-- EXECUTE the_insert_function ('2018-02-27');
-- EXECUTE the_insert_function ('2018-02-28');
--
-- EXECUTE the_insert_function ('2018-03-01');
-- EXECUTE the_insert_function ('2018-03-02');
-- EXECUTE the_insert_function ('2018-03-03');
-- EXECUTE the_insert_function ('2018-03-04');
-- EXECUTE the_insert_function ('2018-03-05');
-- EXECUTE the_insert_function ('2018-03-06');
-- EXECUTE the_insert_function ('2018-03-07');
-- EXECUTE the_insert_function ('2018-03-08');
-- EXECUTE the_insert_function ('2018-03-09');
-- EXECUTE the_insert_function ('2018-03-10');
-- EXECUTE the_insert_function ('2018-03-11');
-- EXECUTE the_insert_function ('2018-03-12');
-- EXECUTE the_insert_function ('2018-03-13');
-- EXECUTE the_insert_function ('2018-03-14');
-- EXECUTE the_insert_function ('2018-03-15');
-- EXECUTE the_insert_function ('2018-03-16');
-- EXECUTE the_insert_function ('2018-03-17');
-- EXECUTE the_insert_function ('2018-03-18');
-- EXECUTE the_insert_function ('2018-03-19');
-- EXECUTE the_insert_function ('2018-03-20');
-- EXECUTE the_insert_function ('2018-03-21');
-- EXECUTE the_insert_function ('2018-03-22');
-- EXECUTE the_insert_function ('2018-03-23');
-- EXECUTE the_insert_function ('2018-03-24');
-- EXECUTE the_insert_function ('2018-03-25');
-- EXECUTE the_insert_function ('2018-03-26');
-- EXECUTE the_insert_function ('2018-03-27');
-- EXECUTE the_insert_function ('2018-03-28');
-- EXECUTE the_insert_function ('2018-03-29');
-- EXECUTE the_insert_function ('2018-03-30');
-- EXECUTE the_insert_function ('2018-03-31');
--
-- EXECUTE the_insert_function ('2018-04-01');
-- EXECUTE the_insert_function ('2018-04-02');
-- EXECUTE the_insert_function ('2018-04-03');
-- EXECUTE the_insert_function ('2018-04-04');
-- EXECUTE the_insert_function ('2018-04-05');
-- EXECUTE the_insert_function ('2018-04-06');
-- EXECUTE the_insert_function ('2018-04-07');
-- EXECUTE the_insert_function ('2018-04-08');
-- EXECUTE the_insert_function ('2018-04-09');
-- EXECUTE the_insert_function ('2018-04-10');
-- EXECUTE the_insert_function ('2018-04-11');
-- EXECUTE the_insert_function ('2018-04-12');
-- EXECUTE the_insert_function ('2018-04-13');
-- EXECUTE the_insert_function ('2018-04-14');
-- EXECUTE the_insert_function ('2018-04-15');
-- EXECUTE the_insert_function ('2018-04-16');
-- EXECUTE the_insert_function ('2018-04-17');
-- EXECUTE the_insert_function ('2018-04-18');
-- EXECUTE the_insert_function ('2018-04-19');
-- EXECUTE the_insert_function ('2018-04-20');
-- EXECUTE the_insert_function ('2018-04-21');
-- EXECUTE the_insert_function ('2018-04-22');
-- EXECUTE the_insert_function ('2018-04-23');
-- EXECUTE the_insert_function ('2018-04-24');
-- EXECUTE the_insert_function ('2018-04-25');
-- EXECUTE the_insert_function ('2018-04-26');
-- EXECUTE the_insert_function ('2018-04-27');
-- EXECUTE the_insert_function ('2018-04-28');
-- EXECUTE the_insert_function ('2018-04-29');
-- EXECUTE the_insert_function ('2018-04-30');
--
-- EXECUTE the_insert_function ('2018-05-01');
-- EXECUTE the_insert_function ('2018-05-02');
-- EXECUTE the_insert_function ('2018-05-03');
-- EXECUTE the_insert_function ('2018-05-04');
-- EXECUTE the_insert_function ('2018-05-05');
-- EXECUTE the_insert_function ('2018-05-06');
-- EXECUTE the_insert_function ('2018-05-07');
-- EXECUTE the_insert_function ('2018-05-08');
-- EXECUTE the_insert_function ('2018-05-09');
-- EXECUTE the_insert_function ('2018-05-10');
-- EXECUTE the_insert_function ('2018-05-11');
-- EXECUTE the_insert_function ('2018-05-12');
-- EXECUTE the_insert_function ('2018-05-13');
-- EXECUTE the_insert_function ('2018-05-14');
-- EXECUTE the_insert_function ('2018-05-15');
-- EXECUTE the_insert_function ('2018-05-16');
-- EXECUTE the_insert_function ('2018-05-17');
-- EXECUTE the_insert_function ('2018-05-18');
-- EXECUTE the_insert_function ('2018-05-19');
-- EXECUTE the_insert_function ('2018-05-20');
-- EXECUTE the_insert_function ('2018-05-21');
-- EXECUTE the_insert_function ('2018-05-22');
-- EXECUTE the_insert_function ('2018-05-23');
-- EXECUTE the_insert_function ('2018-05-24');
-- EXECUTE the_insert_function ('2018-05-25');
-- EXECUTE the_insert_function ('2018-05-26');
-- EXECUTE the_insert_function ('2018-05-27');
-- EXECUTE the_insert_function ('2018-05-28');
-- EXECUTE the_insert_function ('2018-05-29');
-- EXECUTE the_insert_function ('2018-05-30');
-- EXECUTE the_insert_function ('2018-05-31');
--
-- EXECUTE the_insert_function ('2018-06-01');
-- EXECUTE the_insert_function ('2018-06-02');
-- EXECUTE the_insert_function ('2018-06-03');
-- EXECUTE the_insert_function ('2018-06-04');
-- EXECUTE the_insert_function ('2018-06-05');
-- EXECUTE the_insert_function ('2018-06-06');
-- EXECUTE the_insert_function ('2018-06-07');
-- EXECUTE the_insert_function ('2018-06-08');
-- EXECUTE the_insert_function ('2018-06-09');
-- EXECUTE the_insert_function ('2018-06-10');
-- EXECUTE the_insert_function ('2018-06-11');
-- EXECUTE the_insert_function ('2018-06-12');
-- EXECUTE the_insert_function ('2018-06-13');
-- EXECUTE the_insert_function ('2018-06-14');
-- EXECUTE the_insert_function ('2018-06-15');
-- EXECUTE the_insert_function ('2018-06-16');
-- EXECUTE the_insert_function ('2018-06-17');
-- EXECUTE the_insert_function ('2018-06-18');
-- EXECUTE the_insert_function ('2018-06-19');
-- EXECUTE the_insert_function ('2018-06-20');
-- EXECUTE the_insert_function ('2018-06-21');
-- EXECUTE the_insert_function ('2018-06-22');
-- EXECUTE the_insert_function ('2018-06-23');
-- EXECUTE the_insert_function ('2018-06-24');
-- EXECUTE the_insert_function ('2018-06-25');
-- EXECUTE the_insert_function ('2018-06-26');
-- EXECUTE the_insert_function ('2018-06-27');
-- EXECUTE the_insert_function ('2018-06-28');
-- EXECUTE the_insert_function ('2018-06-29');
-- EXECUTE the_insert_function ('2018-06-30');
--
-- EXECUTE the_insert_function ('2018-07-01');
-- EXECUTE the_insert_function ('2018-07-02');
-- EXECUTE the_insert_function ('2018-07-03');
-- EXECUTE the_insert_function ('2018-07-04');
-- EXECUTE the_insert_function ('2018-07-05');
-- EXECUTE the_insert_function ('2018-07-06');
-- EXECUTE the_insert_function ('2018-07-07');
-- EXECUTE the_insert_function ('2018-07-08');
-- EXECUTE the_insert_function ('2018-07-09');
-- EXECUTE the_insert_function ('2018-07-10');
-- EXECUTE the_insert_function ('2018-07-11');
-- EXECUTE the_insert_function ('2018-07-12');
-- EXECUTE the_insert_function ('2018-07-13');
-- EXECUTE the_insert_function ('2018-07-14');
-- EXECUTE the_insert_function ('2018-07-15');
-- EXECUTE the_insert_function ('2018-07-16');
-- EXECUTE the_insert_function ('2018-07-17');
-- EXECUTE the_insert_function ('2018-07-18');
-- EXECUTE the_insert_function ('2018-07-19');
-- EXECUTE the_insert_function ('2018-07-20');
-- EXECUTE the_insert_function ('2018-07-21');
-- EXECUTE the_insert_function ('2018-07-22');
-- EXECUTE the_insert_function ('2018-07-23');
-- EXECUTE the_insert_function ('2018-07-24');
-- EXECUTE the_insert_function ('2018-07-25');
-- EXECUTE the_insert_function ('2018-07-26');
-- EXECUTE the_insert_function ('2018-07-27');
-- EXECUTE the_insert_function ('2018-07-28');
-- EXECUTE the_insert_function ('2018-07-29');
-- EXECUTE the_insert_function ('2018-07-30');
-- EXECUTE the_insert_function ('2018-07-31');
-- --
-- EXECUTE the_insert_function ('2018-08-01');
-- EXECUTE the_insert_function ('2018-08-02');
-- EXECUTE the_insert_function ('2018-08-03');
-- EXECUTE the_insert_function ('2018-08-04');
-- EXECUTE the_insert_function ('2018-08-05');
-- EXECUTE the_insert_function ('2018-08-06');
-- EXECUTE the_insert_function ('2018-08-07');
-- EXECUTE the_insert_function ('2018-08-08');
-- EXECUTE the_insert_function ('2018-08-09');
-- EXECUTE the_insert_function ('2018-08-10');
-- EXECUTE the_insert_function ('2018-08-11');
-- EXECUTE the_insert_function ('2018-08-12');
-- EXECUTE the_insert_function ('2018-08-13');
-- EXECUTE the_insert_function ('2018-08-14');
-- EXECUTE the_insert_function ('2018-08-15');
-- EXECUTE the_insert_function ('2018-08-16');
-- EXECUTE the_insert_function ('2018-08-17');
-- EXECUTE the_insert_function ('2018-08-18');
-- EXECUTE the_insert_function ('2018-08-19');
-- EXECUTE the_insert_function ('2018-08-20');
-- EXECUTE the_insert_function ('2018-08-21');
-- EXECUTE the_insert_function ('2018-08-22');
-- EXECUTE the_insert_function ('2018-08-23');
-- EXECUTE the_insert_function ('2018-08-24');
-- EXECUTE the_insert_function ('2018-08-25');
-- EXECUTE the_insert_function ('2018-08-26');
-- EXECUTE the_insert_function ('2018-08-27');
-- EXECUTE the_insert_function ('2018-08-28');
-- EXECUTE the_insert_function ('2018-08-29');
-- EXECUTE the_insert_function ('2018-08-30');
-- EXECUTE the_insert_function ('2018-08-31');
--
-- EXECUTE the_insert_function ('2018-09-01');
-- EXECUTE the_insert_function ('2018-09-02');
-- EXECUTE the_insert_function ('2018-09-03');
-- EXECUTE the_insert_function ('2018-09-04');
-- EXECUTE the_insert_function ('2018-09-05');
-- EXECUTE the_insert_function ('2018-09-06');
-- EXECUTE the_insert_function ('2018-09-07');
-- EXECUTE the_insert_function ('2018-09-08');
-- EXECUTE the_insert_function ('2018-09-09');
-- EXECUTE the_insert_function ('2018-09-10');
-- EXECUTE the_insert_function ('2018-09-11');
-- EXECUTE the_insert_function ('2018-09-12');
-- EXECUTE the_insert_function ('2018-09-13');
-- EXECUTE the_insert_function ('2018-09-14');
-- EXECUTE the_insert_function ('2018-09-15');
-- EXECUTE the_insert_function ('2018-09-16');
-- EXECUTE the_insert_function ('2018-09-17');
-- EXECUTE the_insert_function ('2018-09-18');
-- EXECUTE the_insert_function ('2018-09-19');
-- EXECUTE the_insert_function ('2018-09-20');
-- EXECUTE the_insert_function ('2018-09-21');
-- EXECUTE the_insert_function ('2018-09-22');
-- EXECUTE the_insert_function ('2018-09-23');
-- EXECUTE the_insert_function ('2018-09-24');
-- EXECUTE the_insert_function ('2018-09-25');
-- EXECUTE the_insert_function ('2018-09-26');
-- EXECUTE the_insert_function ('2018-09-27');
-- EXECUTE the_insert_function ('2018-09-28');
-- EXECUTE the_insert_function ('2018-09-29');
-- EXECUTE the_insert_function ('2018-09-30');
--
-- EXECUTE the_insert_function ('2018-10-01');
-- EXECUTE the_insert_function ('2018-10-02');
-- EXECUTE the_insert_function ('2018-10-03');
-- EXECUTE the_insert_function ('2018-10-04');
-- EXECUTE the_insert_function ('2018-10-05');
-- EXECUTE the_insert_function ('2018-10-06');
-- EXECUTE the_insert_function ('2018-10-07');
-- EXECUTE the_insert_function ('2018-10-08');
-- EXECUTE the_insert_function ('2018-10-09');
-- EXECUTE the_insert_function ('2018-10-10');
-- EXECUTE the_insert_function ('2018-10-11');
-- EXECUTE the_insert_function ('2018-10-12');
-- EXECUTE the_insert_function ('2018-10-13');
-- EXECUTE the_insert_function ('2018-10-14');
-- EXECUTE the_insert_function ('2018-10-15');
-- EXECUTE the_insert_function ('2018-10-16');
-- EXECUTE the_insert_function ('2018-10-17');
-- EXECUTE the_insert_function ('2018-10-18');
-- EXECUTE the_insert_function ('2018-10-19');
-- EXECUTE the_insert_function ('2018-10-20');
-- EXECUTE the_insert_function ('2018-10-21');
-- EXECUTE the_insert_function ('2018-10-22');
-- EXECUTE the_insert_function ('2018-10-23');
-- EXECUTE the_insert_function ('2018-10-24');
-- EXECUTE the_insert_function ('2018-10-25');
-- EXECUTE the_insert_function ('2018-10-26');
-- EXECUTE the_insert_function ('2018-10-27');
-- EXECUTE the_insert_function ('2018-10-28');
-- EXECUTE the_insert_function ('2018-10-29');
-- EXECUTE the_insert_function ('2018-10-30');
-- EXECUTE the_insert_function ('2018-10-31');
--
-- EXECUTE the_insert_function ('2018-11-01');
-- EXECUTE the_insert_function ('2018-11-02');
-- EXECUTE the_insert_function ('2018-11-03');
-- EXECUTE the_insert_function ('2018-11-04');
-- EXECUTE the_insert_function ('2018-11-05');
-- EXECUTE the_insert_function ('2018-11-06');
-- EXECUTE the_insert_function ('2018-11-07');
-- EXECUTE the_insert_function ('2018-11-08');
-- EXECUTE the_insert_function ('2018-11-09');
-- EXECUTE the_insert_function ('2018-11-10');
-- EXECUTE the_insert_function ('2018-11-11');
-- EXECUTE the_insert_function ('2018-11-12');
-- EXECUTE the_insert_function ('2018-11-13');
-- EXECUTE the_insert_function ('2018-11-14');
-- EXECUTE the_insert_function ('2018-11-15');
-- EXECUTE the_insert_function ('2018-11-16');
-- EXECUTE the_insert_function ('2018-11-17');
-- EXECUTE the_insert_function ('2018-11-18');
-- EXECUTE the_insert_function ('2018-11-19');
-- EXECUTE the_insert_function ('2018-11-20');
-- EXECUTE the_insert_function ('2018-11-21');
-- EXECUTE the_insert_function ('2018-11-22');
-- EXECUTE the_insert_function ('2018-11-23');
-- EXECUTE the_insert_function ('2018-11-24');
-- EXECUTE the_insert_function ('2018-11-25');

EXECUTE the_insert_function ('2018-01-18');
EXECUTE the_insert_function ('2018-01-19');
EXECUTE the_insert_function ('2018-01-20');
EXECUTE the_insert_function ('2018-01-21');
EXECUTE the_insert_function ('2018-01-22');

-- Load TEMP_TABLE into TABLE AFTER DELETING THE DATA
INSERT INTO analysis.dsds292_metric_new_net_activations_daily
(SELECT * FROM the_temp_table);

-- DEALLOCATE THE INSERT FUNCTION
DEALLOCATE the_insert_function;
DEALLOCATE the_delete_function;
