-- DROP TABLE IF EXISTS analysis.dsds294_channel_daily_status;
-- CREATE TABLE    analysis.dsds294_channel_daily_status    AS
--   WITH
--   the_constants_time AS (
--     SELECT '2017-09-01'::TIMESTAMP AS the_date
--       , '2017-09-01'::TIMESTAMP - INTERVAL '29 days' AS start_time_rolling_30 --Greater Than Equal To (>=) this timestamp
--       , '2017-09-01'::TIMESTAMP + INTERVAL '1 days' - INTERVAL '1 second'  AS end_time_rolling_30 -- Less Than Equal To (<=) this timestamp
--   )
--
--
--   , ccu_log AS (
--     SELECT const.*, ccu.channel_id, ccu.total
--     FROM logs.channel_concurrents AS ccu
--     LEFT JOIN the_constants_time AS const ON TRUE
--     WHERE ccu.time>=(SELECT start_time_rolling_30 FROM the_constants_time) AND ccu.time<=(SELECT end_time_rolling_30 FROM the_constants_time)
--   )
--
--
--   , ccu_aggregated AS (
--     SELECT the_date, start_time_rolling_30, end_time_rolling_30, channel_id
--     , AVG(total::FLOAT) AS avg_ccu_rolling_30, COUNT(1) AS mins_broadcast
--     --SELECT DATE_DIFF('minute', '2017-09-01 00:00:00', '2017-09-30 23:59:59')::FLOAT/60/24 ===> 29.999 days ===> divide by 30 days
--     , COUNT(1)::FLOAT/30 AS avg_mb_per_day_rolling_30
--     FROM ccu_log
--     GROUP BY 1,2,3,4
--   )
--
--   -- are they a partner or affiliate at the the_date date? i.e. count end of month status for partner affiliate
--   , rollup_partner_affiliate AS (
--     SELECT day AS the_day, channel_id, is_partner, is_affiliate
--     FROM rollups.affiliates_partners_daily_channel_summary
--     WHERE day = (SELECT the_date FROM the_constants_time)
--     GROUP BY 1,2,3,4 --use GROUP BY just in case there are duplicate records
--   )
--   , meta_partner_affiliate AS (
--     SELECT the_day, channel_id
--     , CASE
--         WHEN is_partner =TRUE THEN 'partner'
--         WHEN is_affiliate = TRUE THEN 'affiliate'
--         ELSE 'none'
--       END AS channel_type
--     FROM rollup_partner_affiliate
--   )
--
--   , premium_non_gaming_raw as (
--     SELECT su.user_id AS channel_id, base.channel
--     FROM (
--       SELECT LOWER(channel) AS channel
--       FROM analysis.png_content_summary
--       GROUP BY 1
--     ) AS base
--     LEFT JOIN analysis.sitedb_users AS su ON base.channel = su.login
--     GROUP BY 1,2
--   )
--   , esports_raw AS (
--     SELECT su.user_id AS channel_id, base.channel
--     FROM (
--       SELECT LOWER(channelname) AS channel
--       FROM analysis.esports_deal_channels
--       WHERE "type" <> 'UGC Esports'
--       GROUP BY 1
--     ) AS base
--     LEFT JOIN analysis.sitedb_users AS su ON base.channel = su.login
--     GROUP BY 1,2
--   )
--   , all_premium_channels AS (
--     SELECT *
--     FROM (
--       SELECT * FROM premium_non_gaming_raw
--       UNION ALL SELECT * FROM esports_raw
--     )
--     WHERE channel_id IS NOT NULL
--     GROUP BY 1,2
--   )
--
--   , final_data AS (
--     SELECT base.*
--     , CASE
--         WHEN apc.channel IS NOT NULL THEN 'T5: premium content or esports'
--         WHEN avg_ccu_rolling_30 <= 2 THEN 'T0: 0-2 ccu'
--         WHEN avg_ccu_rolling_30 <= 25 THEN 'T1: 3-25 ccu'
--         WHEN avg_ccu_rolling_30 <= 200 THEN  'T2: 26-200 ccu'
--         WHEN avg_ccu_rolling_30 <= 2000 THEN  'T3: 201-2000 ccu'
--         WHEN avg_ccu_rolling_30 > 2000 THEN  'T4: 2001+ ccu'
--         ELSE 'ERROR'
--       END AS tier
--     , NVL(mpa.channel_type,'none') AS channel_type
--     , CASE
--         WHEN avg_mb_per_day_rolling_30>=10 THEN 'active_streamer'
--         ELSE 'not_active_streamer'
--       END AS active_streamer_status
--     FROM ccu_aggregated AS base
--     LEFT JOIN all_premium_channels AS apc ON base.channel_id = apc.channel_id
--     LEFT JOIN meta_partner_affiliate AS mpa ON
--       base.the_date = mpa.the_day
--       AND base.channel_id = mpa.channel_id
--     WHERE mins_broadcast>=1
--   )
--
--   SELECT the_date::DATE, start_time_rolling_30, end_time_rolling_30
--     , base.channel_id, su.login AS channel
--     , mins_broadcast, avg_mb_per_day_rolling_30, avg_ccu_rolling_30
--     , active_streamer_status, tier, channel_type
--   FROM final_data AS base
--   LEFT JOIN analysis.sitedb_users AS su ON base.channel_id = su.user_id
-- ;
--
--
--
-- SELECT * FROM analysis.dsds294_channel_daily_status AS base
-- WHERE base.channel_id = 114396840
-- AND base.the_date>='2017-09-01'::TIMESTAMP
-- ORDER BY 1,2;
--
-- SELECT * FROM analysis.dsds294_channel_daily_status AS base
-- WHERE tier='T5: premium content or esports'
-- ORDER BY 1,2
-- ;
--
-- SELECT * FROM analysis.dsds294_channel_daily_status AS base WHERE channel IS NULL;
--


SELECT * FROM analysis.dsds294_channel_daily_status WHERE channel_id IN (52159456, 168880307) ;



the_constants_timeframe AS (
  SELECT '2019-01-01'::TIMESTAMP AS the_run_report_month
)

, premium_channel_name as (
  select
    channel
    , min(date_added) as date_added
    , max(date_removed) as date_removed
  from (
    select
      channel
      , case when date_added > '2018-10-01'::date then date_added else to_date('01/01/2000', 'MM/DD/YYYY') end as date_added
      , date_removed
    from (
      select
        lower(channelname) as channel
        , to_date(case when sheet_addition_date > '' then sheet_addition_date else '01/01/2000' end, 'MM/DD/YYYY') as date_added
        , to_date('9999-12-31 00:00:00', 'YYYY-MM-DD HH24:MI:SS') as date_removed
      from analysis.esports_general_channels
      where "type" <> 'UGC Esports'
      group by 1,2,3
    )
    union
    select
      channel
      , to_date(case when date_added::text > '' then date_added else '2000-01-01 00:00:00' end, 'YYYY-MM-DD HH24:MI:SS') as date_added
      , to_date(case when date_removed > '' then date_removed else '9999-12-31 00:00:00' end, 'YYYY-MM-DD HH24:MI:SS') as date_removed
    from analysis.png_whitelist
    group by 1,2,3
  )
  group by 1
)

, premium_channel AS (
  SELECT base.channel, map.user_id AS channel_id, base.date_added, base.date_removed
  FROM premium_channel_name AS base
  LEFT JOIN analysis.user_id_login_mapping_all AS map ON base.channel = map.login
)
--   WITH
--   the_constants_time AS (
--     SELECT DATEADD(day, $1, DATE_TRUNC('day', (SYSDATE - INTERVAL '7 hours'))  ) AS the_date
--       , DATEADD(day, $1, DATE_TRUNC('day', (SYSDATE - INTERVAL '7 hours'))  ) - INTERVAL '29 days' AS start_time_rolling_30 --Greater Than Equal To (>=) this timestamp
--       , DATEADD(day, $1, DATE_TRUNC('day', (SYSDATE - INTERVAL '7 hours'))  ) + INTERVAL '1 days' - INTERVAL '1 second'  AS end_time_rolling_30 -- Less Than Equal To (<=) this timestamp
--   )

, ccu_log AS (
  SELECT ccu.channel_id, ccu.total, premium.channel_id AS premium_channel_id
  FROM logs.channel_concurrents AS ccu
  LEFT JOIN premium_channel AS premium
      on ccu.channel_id = premium.channel_id
      And ccu.time >= premium.date_added
      and ccu.time < premium.date_removed
  WHERE
        ccu.time>=(SELECT the_run_report_month - INTERVAL '29 days' FROM the_constants_timeframe)
    AND ccu.time<=(SELECT the_run_report_month - INTERVAL '1 second' FROM the_constants_timeframe)
)
, ccu_aggregated AS (
  SELECT channel_id, premium_channel_id
  , AVG(total::FLOAT) AS avg_ccu_rolling_30, COUNT(1) AS mins_broadcast
  --SELECT DATE_DIFF('minute', '2017-09-01 00:00:00', '2017-09-30 23:59:59')::FLOAT/60/24 ===> 29.999 days ===> divide by 30 days
  , COUNT(1)::FLOAT/30 AS avg_mb_per_day_rolling_30
  FROM ccu_log
  GROUP BY 1,2
)

, channel_tier_active_status AS (
  SELECT channel_id, premium_channel_id, avg_ccu_rolling_30, mins_broadcast, avg_mb_per_day_rolling_30
    , case
        when premium_channel_id is not null then 'T5: premium'
        when avg_ccu_rolling_30 <= 2 then 'T0: 0-2 CCU'
        when avg_ccu_rolling_30 <= 10 then 'T1: 3-10 CCU'
        when avg_ccu_rolling_30 <= 100 then 'T2: 11-100 CCU'
        when avg_ccu_rolling_30 <= 4000 then 'T3: 101-4000 CCU'
        when avg_ccu_rolling_30 > 4000 then 'T4: 4001+ CCU'
        else 'NULL_NO_STREAM_LAST_30_DAYS'
      END as tier
    , CASE
        WHEN avg_mb_per_day_rolling_30>=10 THEN 'active_streamer'
        ELSE 'not_active_streamer'
      END AS active_streamer_status
  from ccu_aggregated
)

, all_active_streamers AS (
  SELECT * FROM channel_tier_active_status
  WHERE active_streamer_status='active_streamer'
)
, t3_5_active_streamers AS (
  SELECT * FROM all_active_streamers
  WHERE tier IN ('T3: 101-4000 CCU', 'T4: 4001+ CCU', 'T5: premium')
)
