-- pull list of channels that have >=1 panel extension


-- extension_anchor    | extensions | channels |       min_day       |       max_day
-- -----------------------+------------+----------+---------------------+---------------------
-- NULL_EXTENSION_ANCHOR |        979 |    15020 | 2017-10-01 00:00:00 | 2018-08-01 00:00:00
-- component             |        103 |    47448 | 2017-12-20 00:00:00 | 2018-08-01 00:00:00
-- panel                 |        233 |   642472 | 2017-10-01 00:00:00 | 2018-08-01 00:00:00
-- video_overlay         |        221 |   540918 | 2017-10-01 00:00:00 | 2018-08-01 00:00:00
-- (4 rows)



WITH
the_timeframe AS (
  SELECT '2017-10-01'::TIMESTAMP AS start_time
  , '2018-08-01'::TIMESTAMP AS end_time
)
, the_extensions AS (
  SELECT *
  FROM analysis.dsds_281_extension_daily_channel_presence_all_anchor AS base
  WHERE base.the_day >= (SELECT start_time FROM the_timeframe)
    AND base.the_day <= (SELECT end_time FROM the_timeframe)
    AND base.bool_extension_activated = TRUE
    AND base.extension_anchor = 'panel'
)

SELECT extension_anchor, COUNT(DISTINCT extension_id) AS extensions, COUNT(DISTINCT channel_id) AS channels, MIN(the_day) AS min_day, MAX(the_day) AS max_day
FROM the_extensions
GROUP BY 1
--
-- FROM analysis.dsds_281_extension_daily_channel_presence_all_anchor AS base
-- WHERE base.the_day = (SELECT end_time - INTERVAL '1 day' FROM the_timeframe)
--   AND base.extension_id IN (SELECT extension_id FROM the_extensions)
--   AND base.bool_extension_activated = TRUE
