-- find the date for each channel_id and extension_id where there is 30 days post of continuous extension presence, and >=30 days pre of no extensions

DROP TABLE IF EXISTS analysis.dsds_302_extension_channel_modeling_data;
CREATE TABLE analysis.dsds_302_extension_channel_modeling_data AS

WITH

the_timeframe AS (
  SELECT '2017-10-01'::TIMESTAMP AS start_time
  , '2018-08-01'::TIMESTAMP AS end_time
)


, the_constants_timeframe AS (
  SELECT "date" AS the_day
  FROM metadata.date
  WHERE
    "date">= (SELECT start_time FROM the_timeframe)
    AND "date" <= (SELECT end_time FROM the_timeframe)
  GROUP BY 1
)
--pull a list of channels that had any extension activated in the timeframe
, the_constants_channels AS (
  SELECT channel_id
  FROM analysis.dsds_281_extension_daily_channel_presence_all_anchor AS base
  RIGHT JOIN analysis.released_extensions_latest AS rel ON base.extension_id = rel.extension_id --only look at released extensions records
  WHERE
    base.the_day>=(SELECT MIN(the_day) FROM the_constants_timeframe)--'2017-08-31'::TIMESTAMP -- https://blog.twitch.tv/introducing-extensions-a-streaming-revolution-c31762addcd9
    AND base.the_day<(SELECT MAX(the_day) FROM the_constants_timeframe)
    AND base.bool_extension_activated = TRUE
  GROUP BY 1
)

, day_channel_cross_join AS (
  --performed the cross join in separate query __00_gen_cross_join.sql
  SELECT * FROM analysis.dsds_302_day_channel_cross_join
)

-- get logs of each channel each extension each day and their activated status to loop over
, channel_extension_log AS (
  SELECT base.the_day, base.channel_id, base.extension_id, base.bool_extension_activated
  FROM analysis.dsds_281_extension_daily_channel_presence_all_anchor AS base
  RIGHT JOIN analysis.released_extensions_latest AS rel ON base.extension_id = rel.extension_id --only look at released extensions records
  WHERE
    the_day>=(SELECT MIN(the_day) FROM the_constants_timeframe)--'2017-08-31'::TIMESTAMP -- https://blog.twitch.tv/introducing-extensions-a-streaming-revolution-c31762addcd9
    AND the_day<(SELECT MAX(the_day) FROM the_constants_timeframe)
    AND channel_id IN (SELECT channel_id FROM the_constants_channels)
  GROUP BY 1,2,3,4
)
, daily_channel_has_extension_log AS (
  SELECT the_day, channel_id, MAX(CASE WHEN bool_extension_activated THEN 1 ELSE 0 END) AS flag_has_any_extension
  FROM channel_extension_log AS base
  GROUP BY 1,2
)

--For each channel_id and the_day combo, Check that they had X days continuously without extension counting backwards from the_day
, channel_pre_extension_data AS (
  SELECT * ,value_pre_1 + value_pre_2 + value_pre_3 + value_pre_4 + value_pre_5 + value_pre_6 + value_pre_7 + value_pre_8 + value_pre_9 + value_pre_10 + value_pre_11 + value_pre_12 + value_pre_13 + value_pre_14 + value_pre_15 + value_pre_16 + value_pre_17 + value_pre_18 + value_pre_19 + value_pre_20 + value_pre_21 + value_pre_22 + value_pre_23 + value_pre_24 + value_pre_25 + value_pre_26 + value_pre_27 + value_pre_28 + value_pre_29 + value_pre_30 AS no_ext_days_pre
  FROM (
    SELECT *
    , NTH_VALUE(CASE WHEN flag_has_any_extension=1 THEN 0 ELSE 1 END, 1) IGNORE NULLS OVER(PARTITION BY channel_id ORDER BY the_day DESC ROWS BETWEEN CURRENT ROW AND UNBOUNDED FOLLOWING) AS value_pre_1
    , NTH_VALUE(CASE WHEN flag_has_any_extension=1 THEN 0 ELSE 1 END, 2) IGNORE NULLS OVER(PARTITION BY channel_id ORDER BY the_day DESC ROWS BETWEEN CURRENT ROW AND UNBOUNDED FOLLOWING) AS value_pre_2
    , NTH_VALUE(CASE WHEN flag_has_any_extension=1 THEN 0 ELSE 1 END, 3) IGNORE NULLS OVER(PARTITION BY channel_id ORDER BY the_day DESC ROWS BETWEEN CURRENT ROW AND UNBOUNDED FOLLOWING) AS value_pre_3
    , NTH_VALUE(CASE WHEN flag_has_any_extension=1 THEN 0 ELSE 1 END, 4) IGNORE NULLS OVER(PARTITION BY channel_id ORDER BY the_day DESC ROWS BETWEEN CURRENT ROW AND UNBOUNDED FOLLOWING) AS value_pre_4
    , NTH_VALUE(CASE WHEN flag_has_any_extension=1 THEN 0 ELSE 1 END, 5) IGNORE NULLS OVER(PARTITION BY channel_id ORDER BY the_day DESC ROWS BETWEEN CURRENT ROW AND UNBOUNDED FOLLOWING) AS value_pre_5
    , NTH_VALUE(CASE WHEN flag_has_any_extension=1 THEN 0 ELSE 1 END, 6) IGNORE NULLS OVER(PARTITION BY channel_id ORDER BY the_day DESC ROWS BETWEEN CURRENT ROW AND UNBOUNDED FOLLOWING) AS value_pre_6
    , NTH_VALUE(CASE WHEN flag_has_any_extension=1 THEN 0 ELSE 1 END, 7) IGNORE NULLS OVER(PARTITION BY channel_id ORDER BY the_day DESC ROWS BETWEEN CURRENT ROW AND UNBOUNDED FOLLOWING) AS value_pre_7
    , NTH_VALUE(CASE WHEN flag_has_any_extension=1 THEN 0 ELSE 1 END, 8) IGNORE NULLS OVER(PARTITION BY channel_id ORDER BY the_day DESC ROWS BETWEEN CURRENT ROW AND UNBOUNDED FOLLOWING) AS value_pre_8
    , NTH_VALUE(CASE WHEN flag_has_any_extension=1 THEN 0 ELSE 1 END, 9) IGNORE NULLS OVER(PARTITION BY channel_id ORDER BY the_day DESC ROWS BETWEEN CURRENT ROW AND UNBOUNDED FOLLOWING) AS value_pre_9
    , NTH_VALUE(CASE WHEN flag_has_any_extension=1 THEN 0 ELSE 1 END, 10) IGNORE NULLS OVER(PARTITION BY channel_id ORDER BY the_day DESC ROWS BETWEEN CURRENT ROW AND UNBOUNDED FOLLOWING) AS value_pre_10
    , NTH_VALUE(CASE WHEN flag_has_any_extension=1 THEN 0 ELSE 1 END, 11) IGNORE NULLS OVER(PARTITION BY channel_id ORDER BY the_day DESC ROWS BETWEEN CURRENT ROW AND UNBOUNDED FOLLOWING) AS value_pre_11
    , NTH_VALUE(CASE WHEN flag_has_any_extension=1 THEN 0 ELSE 1 END, 12) IGNORE NULLS OVER(PARTITION BY channel_id ORDER BY the_day DESC ROWS BETWEEN CURRENT ROW AND UNBOUNDED FOLLOWING) AS value_pre_12
    , NTH_VALUE(CASE WHEN flag_has_any_extension=1 THEN 0 ELSE 1 END, 13) IGNORE NULLS OVER(PARTITION BY channel_id ORDER BY the_day DESC ROWS BETWEEN CURRENT ROW AND UNBOUNDED FOLLOWING) AS value_pre_13
    , NTH_VALUE(CASE WHEN flag_has_any_extension=1 THEN 0 ELSE 1 END, 14) IGNORE NULLS OVER(PARTITION BY channel_id ORDER BY the_day DESC ROWS BETWEEN CURRENT ROW AND UNBOUNDED FOLLOWING) AS value_pre_14
    , NTH_VALUE(CASE WHEN flag_has_any_extension=1 THEN 0 ELSE 1 END, 15) IGNORE NULLS OVER(PARTITION BY channel_id ORDER BY the_day DESC ROWS BETWEEN CURRENT ROW AND UNBOUNDED FOLLOWING) AS value_pre_15
    , NTH_VALUE(CASE WHEN flag_has_any_extension=1 THEN 0 ELSE 1 END, 16) IGNORE NULLS OVER(PARTITION BY channel_id ORDER BY the_day DESC ROWS BETWEEN CURRENT ROW AND UNBOUNDED FOLLOWING) AS value_pre_16
    , NTH_VALUE(CASE WHEN flag_has_any_extension=1 THEN 0 ELSE 1 END, 17) IGNORE NULLS OVER(PARTITION BY channel_id ORDER BY the_day DESC ROWS BETWEEN CURRENT ROW AND UNBOUNDED FOLLOWING) AS value_pre_17
    , NTH_VALUE(CASE WHEN flag_has_any_extension=1 THEN 0 ELSE 1 END, 18) IGNORE NULLS OVER(PARTITION BY channel_id ORDER BY the_day DESC ROWS BETWEEN CURRENT ROW AND UNBOUNDED FOLLOWING) AS value_pre_18
    , NTH_VALUE(CASE WHEN flag_has_any_extension=1 THEN 0 ELSE 1 END, 19) IGNORE NULLS OVER(PARTITION BY channel_id ORDER BY the_day DESC ROWS BETWEEN CURRENT ROW AND UNBOUNDED FOLLOWING) AS value_pre_19
    , NTH_VALUE(CASE WHEN flag_has_any_extension=1 THEN 0 ELSE 1 END, 20) IGNORE NULLS OVER(PARTITION BY channel_id ORDER BY the_day DESC ROWS BETWEEN CURRENT ROW AND UNBOUNDED FOLLOWING) AS value_pre_20
    , NTH_VALUE(CASE WHEN flag_has_any_extension=1 THEN 0 ELSE 1 END, 21) IGNORE NULLS OVER(PARTITION BY channel_id ORDER BY the_day DESC ROWS BETWEEN CURRENT ROW AND UNBOUNDED FOLLOWING) AS value_pre_21
    , NTH_VALUE(CASE WHEN flag_has_any_extension=1 THEN 0 ELSE 1 END, 22) IGNORE NULLS OVER(PARTITION BY channel_id ORDER BY the_day DESC ROWS BETWEEN CURRENT ROW AND UNBOUNDED FOLLOWING) AS value_pre_22
    , NTH_VALUE(CASE WHEN flag_has_any_extension=1 THEN 0 ELSE 1 END, 23) IGNORE NULLS OVER(PARTITION BY channel_id ORDER BY the_day DESC ROWS BETWEEN CURRENT ROW AND UNBOUNDED FOLLOWING) AS value_pre_23
    , NTH_VALUE(CASE WHEN flag_has_any_extension=1 THEN 0 ELSE 1 END, 24) IGNORE NULLS OVER(PARTITION BY channel_id ORDER BY the_day DESC ROWS BETWEEN CURRENT ROW AND UNBOUNDED FOLLOWING) AS value_pre_24
    , NTH_VALUE(CASE WHEN flag_has_any_extension=1 THEN 0 ELSE 1 END, 25) IGNORE NULLS OVER(PARTITION BY channel_id ORDER BY the_day DESC ROWS BETWEEN CURRENT ROW AND UNBOUNDED FOLLOWING) AS value_pre_25
    , NTH_VALUE(CASE WHEN flag_has_any_extension=1 THEN 0 ELSE 1 END, 26) IGNORE NULLS OVER(PARTITION BY channel_id ORDER BY the_day DESC ROWS BETWEEN CURRENT ROW AND UNBOUNDED FOLLOWING) AS value_pre_26
    , NTH_VALUE(CASE WHEN flag_has_any_extension=1 THEN 0 ELSE 1 END, 27) IGNORE NULLS OVER(PARTITION BY channel_id ORDER BY the_day DESC ROWS BETWEEN CURRENT ROW AND UNBOUNDED FOLLOWING) AS value_pre_27
    , NTH_VALUE(CASE WHEN flag_has_any_extension=1 THEN 0 ELSE 1 END, 28) IGNORE NULLS OVER(PARTITION BY channel_id ORDER BY the_day DESC ROWS BETWEEN CURRENT ROW AND UNBOUNDED FOLLOWING) AS value_pre_28
    , NTH_VALUE(CASE WHEN flag_has_any_extension=1 THEN 0 ELSE 1 END, 29) IGNORE NULLS OVER(PARTITION BY channel_id ORDER BY the_day DESC ROWS BETWEEN CURRENT ROW AND UNBOUNDED FOLLOWING) AS value_pre_29
    , NTH_VALUE(CASE WHEN flag_has_any_extension=1 THEN 0 ELSE 1 END, 30) IGNORE NULLS OVER(PARTITION BY channel_id ORDER BY the_day DESC ROWS BETWEEN CURRENT ROW AND UNBOUNDED FOLLOWING) AS value_pre_30
    FROM (
      SELECT base.the_day, base.channel_id, NVL(flag_has_any_extension,0) AS flag_has_any_extension
      FROM day_channel_cross_join AS base
      LEFT JOIN daily_channel_has_extension_log AS has_ext ON base.the_day = has_ext.the_day AND base.channel_id = has_ext.channel_id
    )
  )
)

, channel_post_extension_data AS (
  SELECT channel_id, extension_id, the_day, bool_extension_activated
  , value_1 * value_2 * value_3 * value_4 * value_5 * value_6 * value_7 * value_8 * value_9 * value_10 * value_11 * value_12 * value_13 * value_14 * value_15 * value_16 * value_17 * value_18 * value_19 * value_20 * value_21 * value_22 * value_23 * value_24 * value_25 * value_26 * value_27 * value_28 * value_29 * value_30 AS flag_valid_day_post
  , value_1, value_2, value_3, value_4, value_5, value_6, value_7, value_8, value_9, value_10, value_11, value_12, value_13, value_14, value_15, value_16, value_17, value_18, value_19, value_20, value_21, value_22, value_23, value_24, value_25, value_26, value_27, value_28, value_29, value_30
  FROM (
    SELECT *
    , NTH_VALUE(CASE WHEN bool_extension_activated THEN 1 ELSE 0 END, 1) IGNORE NULLS OVER(PARTITION BY channel_id, extension_id ORDER BY the_day ASC ROWS BETWEEN CURRENT ROW AND UNBOUNDED FOLLOWING) AS value_1
    , NTH_VALUE(CASE WHEN bool_extension_activated THEN 1 ELSE 0 END, 2) IGNORE NULLS OVER(PARTITION BY channel_id, extension_id ORDER BY the_day ASC ROWS BETWEEN CURRENT ROW AND UNBOUNDED FOLLOWING) AS value_2
    , NTH_VALUE(CASE WHEN bool_extension_activated THEN 1 ELSE 0 END, 3) IGNORE NULLS OVER(PARTITION BY channel_id, extension_id ORDER BY the_day ASC ROWS BETWEEN CURRENT ROW AND UNBOUNDED FOLLOWING) AS value_3
    , NTH_VALUE(CASE WHEN bool_extension_activated THEN 1 ELSE 0 END, 4) IGNORE NULLS OVER(PARTITION BY channel_id, extension_id ORDER BY the_day ASC ROWS BETWEEN CURRENT ROW AND UNBOUNDED FOLLOWING) AS value_4
    , NTH_VALUE(CASE WHEN bool_extension_activated THEN 1 ELSE 0 END, 5) IGNORE NULLS OVER(PARTITION BY channel_id, extension_id ORDER BY the_day ASC ROWS BETWEEN CURRENT ROW AND UNBOUNDED FOLLOWING) AS value_5
    , NTH_VALUE(CASE WHEN bool_extension_activated THEN 1 ELSE 0 END, 6) IGNORE NULLS OVER(PARTITION BY channel_id, extension_id ORDER BY the_day ASC ROWS BETWEEN CURRENT ROW AND UNBOUNDED FOLLOWING) AS value_6
    , NTH_VALUE(CASE WHEN bool_extension_activated THEN 1 ELSE 0 END, 7) IGNORE NULLS OVER(PARTITION BY channel_id, extension_id ORDER BY the_day ASC ROWS BETWEEN CURRENT ROW AND UNBOUNDED FOLLOWING) AS value_7
    , NTH_VALUE(CASE WHEN bool_extension_activated THEN 1 ELSE 0 END, 8) IGNORE NULLS OVER(PARTITION BY channel_id, extension_id ORDER BY the_day ASC ROWS BETWEEN CURRENT ROW AND UNBOUNDED FOLLOWING) AS value_8
    , NTH_VALUE(CASE WHEN bool_extension_activated THEN 1 ELSE 0 END, 9) IGNORE NULLS OVER(PARTITION BY channel_id, extension_id ORDER BY the_day ASC ROWS BETWEEN CURRENT ROW AND UNBOUNDED FOLLOWING) AS value_9
    , NTH_VALUE(CASE WHEN bool_extension_activated THEN 1 ELSE 0 END, 10) IGNORE NULLS OVER(PARTITION BY channel_id, extension_id ORDER BY the_day ASC ROWS BETWEEN CURRENT ROW AND UNBOUNDED FOLLOWING) AS value_10
    , NTH_VALUE(CASE WHEN bool_extension_activated THEN 1 ELSE 0 END, 11) IGNORE NULLS OVER(PARTITION BY channel_id, extension_id ORDER BY the_day ASC ROWS BETWEEN CURRENT ROW AND UNBOUNDED FOLLOWING) AS value_11
    , NTH_VALUE(CASE WHEN bool_extension_activated THEN 1 ELSE 0 END, 12) IGNORE NULLS OVER(PARTITION BY channel_id, extension_id ORDER BY the_day ASC ROWS BETWEEN CURRENT ROW AND UNBOUNDED FOLLOWING) AS value_12
    , NTH_VALUE(CASE WHEN bool_extension_activated THEN 1 ELSE 0 END, 13) IGNORE NULLS OVER(PARTITION BY channel_id, extension_id ORDER BY the_day ASC ROWS BETWEEN CURRENT ROW AND UNBOUNDED FOLLOWING) AS value_13
    , NTH_VALUE(CASE WHEN bool_extension_activated THEN 1 ELSE 0 END, 14) IGNORE NULLS OVER(PARTITION BY channel_id, extension_id ORDER BY the_day ASC ROWS BETWEEN CURRENT ROW AND UNBOUNDED FOLLOWING) AS value_14
    , NTH_VALUE(CASE WHEN bool_extension_activated THEN 1 ELSE 0 END, 15) IGNORE NULLS OVER(PARTITION BY channel_id, extension_id ORDER BY the_day ASC ROWS BETWEEN CURRENT ROW AND UNBOUNDED FOLLOWING) AS value_15
    , NTH_VALUE(CASE WHEN bool_extension_activated THEN 1 ELSE 0 END, 16) IGNORE NULLS OVER(PARTITION BY channel_id, extension_id ORDER BY the_day ASC ROWS BETWEEN CURRENT ROW AND UNBOUNDED FOLLOWING) AS value_16
    , NTH_VALUE(CASE WHEN bool_extension_activated THEN 1 ELSE 0 END, 17) IGNORE NULLS OVER(PARTITION BY channel_id, extension_id ORDER BY the_day ASC ROWS BETWEEN CURRENT ROW AND UNBOUNDED FOLLOWING) AS value_17
    , NTH_VALUE(CASE WHEN bool_extension_activated THEN 1 ELSE 0 END, 18) IGNORE NULLS OVER(PARTITION BY channel_id, extension_id ORDER BY the_day ASC ROWS BETWEEN CURRENT ROW AND UNBOUNDED FOLLOWING) AS value_18
    , NTH_VALUE(CASE WHEN bool_extension_activated THEN 1 ELSE 0 END, 19) IGNORE NULLS OVER(PARTITION BY channel_id, extension_id ORDER BY the_day ASC ROWS BETWEEN CURRENT ROW AND UNBOUNDED FOLLOWING) AS value_19
    , NTH_VALUE(CASE WHEN bool_extension_activated THEN 1 ELSE 0 END, 20) IGNORE NULLS OVER(PARTITION BY channel_id, extension_id ORDER BY the_day ASC ROWS BETWEEN CURRENT ROW AND UNBOUNDED FOLLOWING) AS value_20
    , NTH_VALUE(CASE WHEN bool_extension_activated THEN 1 ELSE 0 END, 21) IGNORE NULLS OVER(PARTITION BY channel_id, extension_id ORDER BY the_day ASC ROWS BETWEEN CURRENT ROW AND UNBOUNDED FOLLOWING) AS value_21
    , NTH_VALUE(CASE WHEN bool_extension_activated THEN 1 ELSE 0 END, 22) IGNORE NULLS OVER(PARTITION BY channel_id, extension_id ORDER BY the_day ASC ROWS BETWEEN CURRENT ROW AND UNBOUNDED FOLLOWING) AS value_22
    , NTH_VALUE(CASE WHEN bool_extension_activated THEN 1 ELSE 0 END, 23) IGNORE NULLS OVER(PARTITION BY channel_id, extension_id ORDER BY the_day ASC ROWS BETWEEN CURRENT ROW AND UNBOUNDED FOLLOWING) AS value_23
    , NTH_VALUE(CASE WHEN bool_extension_activated THEN 1 ELSE 0 END, 24) IGNORE NULLS OVER(PARTITION BY channel_id, extension_id ORDER BY the_day ASC ROWS BETWEEN CURRENT ROW AND UNBOUNDED FOLLOWING) AS value_24
    , NTH_VALUE(CASE WHEN bool_extension_activated THEN 1 ELSE 0 END, 25) IGNORE NULLS OVER(PARTITION BY channel_id, extension_id ORDER BY the_day ASC ROWS BETWEEN CURRENT ROW AND UNBOUNDED FOLLOWING) AS value_25
    , NTH_VALUE(CASE WHEN bool_extension_activated THEN 1 ELSE 0 END, 26) IGNORE NULLS OVER(PARTITION BY channel_id, extension_id ORDER BY the_day ASC ROWS BETWEEN CURRENT ROW AND UNBOUNDED FOLLOWING) AS value_26
    , NTH_VALUE(CASE WHEN bool_extension_activated THEN 1 ELSE 0 END, 27) IGNORE NULLS OVER(PARTITION BY channel_id, extension_id ORDER BY the_day ASC ROWS BETWEEN CURRENT ROW AND UNBOUNDED FOLLOWING) AS value_27
    , NTH_VALUE(CASE WHEN bool_extension_activated THEN 1 ELSE 0 END, 28) IGNORE NULLS OVER(PARTITION BY channel_id, extension_id ORDER BY the_day ASC ROWS BETWEEN CURRENT ROW AND UNBOUNDED FOLLOWING) AS value_28
    , NTH_VALUE(CASE WHEN bool_extension_activated THEN 1 ELSE 0 END, 29) IGNORE NULLS OVER(PARTITION BY channel_id, extension_id ORDER BY the_day ASC ROWS BETWEEN CURRENT ROW AND UNBOUNDED FOLLOWING) AS value_29
    , NTH_VALUE(CASE WHEN bool_extension_activated THEN 1 ELSE 0 END, 30) IGNORE NULLS OVER(PARTITION BY channel_id, extension_id ORDER BY the_day ASC ROWS BETWEEN CURRENT ROW AND UNBOUNDED FOLLOWING) AS value_30
    FROM channel_extension_log
  )
)
, channel_pre_post_join AS (
  SELECT *
    -- if the day before there were 30 days of no extensions, and for the next 30 days there is the same extension activated, then 1, else 0
    , (CASE WHEN no_ext_days_pre_yesterday >=30 THEN 1 ELSE 0 END) * flag_valid_day_post AS bool_valid_day
  FROM (
    SELECT pre.the_day, pre.channel_id, post.extension_id, post.bool_extension_activated, post.flag_valid_day_post
    , pre.flag_has_any_extension, pre.no_ext_days_pre
    , NTH_VALUE(pre.no_ext_days_pre, 2) IGNORE NULLS OVER(PARTITION BY pre.channel_id ORDER BY pre.the_day DESC ROWS BETWEEN CURRENT ROW AND 2 FOLLOWING) AS no_ext_days_pre_yesterday
    FROM channel_pre_extension_data AS pre
    LEFT JOIN channel_post_extension_data AS post ON post.the_day = pre.the_day AND post.channel_id = pre.channel_id
    WHERE pre.no_ext_days_pre IS NOT NULL --will exlude some of the data in apr 2017
  )
  --ORDER BY 1,2
)

--get list of channels and extensions along with the day in which they had 30 days post of consecutive extension on and at least 30 days pre of no extensions
, channel_extension_data AS (
  SELECT base.the_day, base.channel_id, base.extension_id, rel.extension_name, bool_valid_day, no_ext_days_pre, no_ext_days_pre_yesterday, flag_valid_day_post
  -- , MIN(base.the_day)::TIMESTAMP AS first_consecutive_30_day_activated
  -- , MAX(base.the_day)::TIMESTAMP AS last_consecutive_30_day_activated
  FROM channel_pre_post_join AS base
  LEFT JOIN analysis.released_extensions_latest AS rel ON base.extension_id = rel.extension_id
  WHERE bool_valid_day=1
  GROUP BY 1,2,3,4,5,6,7,8
)
-- get the tiers of these channels
, channel_tier AS (
  SELECT *,
  CASE
    WHEN avg_ccu <=2 THEN 'T0: 0-2 ccu'
    WHEN avg_ccu <= 25 THEN 'T1: 3-25 ccu'
    WHEN avg_ccu <= 200 THEN  'T2: 26-200 ccu'
    WHEN avg_ccu <= 2000 THEN  'T3: 201-2000 ccu'
    WHEN avg_ccu > 2000 THEN  'T4: 2001+ ccu'
    ELSE 'Unknown'
  END AS tier
  FROM (
    SELECT channel_id, AVG(total::float) AS avg_ccu
    FROM logs.channel_concurrents
    WHERE channel_id IN (SELECT channel_id FROM channel_extension_data)
    AND time>=(SELECT MIN(the_day) - INTERVAL '30 days' FROM channel_extension_data)
    AND time<(SELECT MAX(the_day) + INTERVAL '30 days' FROM channel_extension_data)
    GROUP BY 1
  )
)
, final_data AS (
  SELECT the_day, base.channel_id, tier, extension_id, extension_name, bool_valid_day, no_ext_days_pre, flag_valid_day_post
  --, first_consecutive_30_day_activated, last_consecutive_30_day_activated
  FROM channel_extension_data AS base
  LEFT JOIN channel_tier AS ct on base.channel_id = ct.channel_id
)

SELECT * FROM final_data ;
