-- Bits transacted (if bits extension)
-- #bits customers
-- Digital goods value transacted (if pubg skin)
-- Digital goods customers
-- # viewers that seen extension
-- # viewers that interacted with extension
-- # channels that have the extension live on their page


WITH
the_extensions AS (
  SELECT 'qhkxgybrzjfjjb5fwwwjkcohh2uzmc'  AS extension_id
  UNION ALL SELECT 'oks2vrhq8iqq1qv714n35fo70igtjc'  AS extension_id
) --pubg colonel extensions


, the_timeframe AS (
  SELECT '2018-10-18 00:00:00'::TIMESTAMP AS end_time
)

, the_extensions_metadata AS (
  SELECT base.extension_id, rel.extension_name
  FROM the_extensions AS base
  LEFT JOIN analysis.released_extensions_latest AS rel ON base.extension_id = rel.extension_id
)

, bits_data AS (
  SELECT (SELECT 'PUBG Contraband (Panel & Component)') AS the_extension
    , 0 AS bits_transaction_value
    , 0 AS bits_total_customers
)

, digital_goods_data AS (
  SELECT (SELECT 'PUBG Contraband (Panel & Component)') AS the_extension
    , SUM(base.purchase_value::float) AS digital_goods_transaction_value
    , COUNT(DISTINCT base.user_id) AS digital_goods_total_customers
  FROM tahoe.extension_item_entitled as base
  RIGHT JOIN tahoe_analysis.colonel_pubg_item_sku_data as items
    ON base.asin = items.asin
  WHERE base.date < (SELECT end_time FROM the_timeframe)
)

, viewers_data AS (
  SELECT (SELECT 'PUBG Contraband (Panel & Component)') AS the_extension
    , COUNT(DISTINCT device_id) AS total_viewers
  FROM (
    SELECT device_id
    FROM tahoe.extension_render AS base
    WHERE base.date < (SELECT end_time FROM the_timeframe)
      AND base.extension_id = 'qhkxgybrzjfjjb5fwwwjkcohh2uzmc'
    UNION ALL
    SELECT device_id
    FROM tahoe.extension_view AS base
    WHERE base.date < (SELECT end_time FROM the_timeframe)
      AND base.extension_id = 'oks2vrhq8iqq1qv714n35fo70igtjc'
      AND base.pct_view_visible >= 75
  )
)

, interactors_data AS (
  SELECT (SELECT 'PUBG Contraband (Panel & Component)') AS the_extension
    , COUNT(DISTINCT device_id) AS total_interactors
  FROM tahoe.extension_click AS base
  WHERE base.date < (SELECT end_time FROM the_timeframe)
    AND base.extension_id IN (SELECT extension_id FROM the_extensions)
)
, channels_data AS (
  SELECT (SELECT 'PUBG Contraband (Panel & Component)') AS the_extension
    , COUNT(DISTINCT channel_id) AS total_channels_with_extension
  FROM analysis.dsds_281_extension_daily_channel_presence_all_anchor AS base
  WHERE base.the_day = (SELECT end_time - INTERVAL '1 day' FROM the_timeframe)
    AND base.extension_id IN (SELECT extension_id FROM the_extensions)
    AND base.bool_extension_activated = TRUE
)



SELECT digital_goods_data.*
  , bits_data.bits_transaction_value::FLOAT / 100 AS bits_transaction_value
  , bits_data.bits_total_customers
  , viewers_data.total_viewers
  , interactors_data.total_interactors
  , channels_data.total_channels_with_extension
FROM digital_goods_data
LEFT JOIN bits_data ON digital_goods_data.the_extension = bits_data.the_extension
LEFT JOIN viewers_data ON digital_goods_data.the_extension = viewers_data.the_extension
LEFT JOIN interactors_data ON digital_goods_data.the_extension = interactors_data.the_extension
LEFT JOIN channels_data ON digital_goods_data.the_extension = channels_data.the_extension
