-- ALWAYS ASSOCIATED WITH A SPEEDRUN
--speedrun---->             https://www.twitch.tv/directory/all/tags/7cefbf30-4c3e-4aa7-99cd-70aabb662f27
--WR Attempts---->         https://www.twitch.tv/directory/all/tags/2b19c8f9-695f-4ea1-a5fe-eba176770dbc
--PB Attempts---->          https://www.twitch.tv/directory/all/tags/77a928f7-39da-4dad-9d81-3e6bd7a36e04

-- SOMETIMES USED WITH SPEEDRUN BUT NOT ALL THE TIME
--Any%---->                 https://www.twitch.tv/directory/all/tags/c9193f35-a88f-4f03-af99-b73fe0db60f3
--100%---->         https://www.twitch.tv/directory/all/tags/e659959d-392f-44c5-83a5-fb959cdbaccc



CREATE TABLE analysis.dsds_306_speedrun_stream_sessions AS
WITH
the_data AS (
  SELECT
  "time", rails_channel_id AS channel_id, rails_title AS stream_title, rails_meta_game AS game
  , "graffiti-tag_ids_long" AS tag_set_long
  FROM tahoe.jax_live_channel
  WHERE
  --"date">='2018-09-27' AND "date"<'2018-09-28' -- have data on tags starting 2018-09-28
  "date">='2018-10-01' AND "date"<'2018-11-27' -- have data on tags starting 2018-09-28
  AND (POSITION('7cefbf30-4c3e-4aa7-99cd-70aabb662f27' IN "graffiti-tag_ids_long")>0
    OR POSITION('2b19c8f9-695f-4ea1-a5fe-eba176770dbc' IN "graffiti-tag_ids_long")>0
    OR POSITION('77a928f7-39da-4dad-9d81-3e6bd7a36e04' IN "graffiti-tag_ids_long")>0 )
  --AND rails_channel_id = 21534457
)

, final_data AS (
  SELECT *, DATE_TRUNC('day', stream_start) AS stream_start_day, DATE_TRUNC('day', stream_end) AS stream_end_day
  FROM (
    SELECT channel_id, stream_title, game, MIN("time") AS stream_start, MAX("time") AS stream_end
    FROM the_data
    GROUP BY 1,2,3
  )
)

SELECT * FROM final_data
