--calculate what tier the client_id is in based on rules and data from analysis.dsds30e

DROP TABLE IF EXISTS    analysis.dsds30f2;
CREATE TABLE    analysis.dsds30f2    AS


WITH final_table AS (
  SELECT *,
  CASE WHEN users<15000 THEN 'Tier 3'
  WHEN users >=15000 AND users<100000 AND mw_per_user<150 THEN 'Tier 3'
  WHEN users >=15000 AND users<100000 AND mw_per_user>=150 THEN 'Tier 2'
  WHEN users >=100000 AND users<200000 AND mw_per_user<450 THEN 'Tier 2'
  WHEN users >=100000 AND users<200000 AND mw_per_user>=450 THEN 'Tier 2'
  WHEN users >=200000 AND users<500000 AND mw_per_user<450 THEN 'Tier 2'
  WHEN users >=200000 AND users<500000 AND mw_per_user>=450 THEN 'Tier 1'
  WHEN users >=500000 AND mw_per_user<450 THEN 'Tier 2'
  WHEN users >=500000 AND mw_per_user>=450 THEN 'Tier 1'
  ELSE 'ERROR'
  END AS the_tier
  FROM (
    SELECT client_id, COUNT(DISTINCT user_id) AS users, SUM(mw) AS total_mw, SUM(mw)::FLOAT / COUNT(DISTINCT user_id)::FLOAT AS mw_per_user
    FROM analysis.dsds30e
    GROUP BY 1
  )
)

SELECT * FROM final_table
