CREATE TABLE analysis.dsds_310_fifa_users_pre_drops_start AS

WITH
the_constants AS (
  SELECT 'FIFA 18' AS game
    , '2018-01-25'::TIMESTAMP - INTERVAL '30 days' AS start_time
    , '2018-01-25'::TIMESTAMP AS end_time --'2018-01-26 04:00:00'::TIMESTAMP is when the first drops campaign for fifa 18 started
)

, mw_log_fifa AS (
  SELECT "time", user_id, game, 1 AS one_min_watch
  FROM logs."minute-watched"
  WHERE user_id IS NOT NULL --only looked at logged in users since we want high-ish intent viewers
    AND (live = TRUE OR live IS NULL) --live minutes only
    AND "time">=(SELECT start_time FROM the_constants)
    AND "time"<=(SELECT end_time FROM the_constants)
    AND game = (SELECT game FROM the_constants) --fifa mins
)

, per_user_mw_fifa AS (
  SELECT user_id, SUM(one_min_watch)::FLOAT/60 AS fifa_hrs_watched_prev_month_before_drops_start
  FROM mw_log_fifa
  GROUP BY 1
)

, mw_log_non_fifa AS (
  SELECT "time", user_id, game, 1 AS one_min_watch
  FROM logs."minute-watched"
  WHERE user_id IN (SELECT user_id FROM per_user_mw_fifa) --only look at the fifa viewers from previous CTE
    AND (live = TRUE OR live IS NULL) --live minutes only
    AND "time">=(SELECT start_time FROM the_constants)
    AND "time"<=(SELECT end_time FROM the_constants)
    AND game != (SELECT game FROM the_constants) --not fifa mins
)
, per_user_mw_non_fifa AS (
  SELECT user_id, SUM(one_min_watch)::FLOAT/60 AS not_fifa_hrs_watched_prev_month_before_drops_start
  FROM mw_log_non_fifa
  GROUP BY 1
)

--generate low,med,high fifa engaged user before start of drops campaign (used tableau to look at histogram for the splits)
, fifa_users AS (
  SELECT user_id, fifa_hrs_watched_prev_month_before_drops_start
  , CASE
      WHEN fifa_hrs_watched_prev_month_before_drops_start<1 THEN '0. low_engaged_fifa'
      WHEN fifa_hrs_watched_prev_month_before_drops_start<6 THEN '1. med_engaged_fifa'
      WHEN fifa_hrs_watched_prev_month_before_drops_start>=6 THEN '2. high_engaged_fifa'
      ELSE 'error'
    END AS flag_fifa_engagement_before_drops_start
  FROM per_user_mw_fifa
)

, joined_data AS (
  SELECT base.*, non.not_fifa_hrs_watched_prev_month_before_drops_start
  FROM fifa_users AS base
  LEFT JOIN per_user_mw_non_fifa AS non ON base.user_id = non.user_id
)

, final_data AS (
  SELECT *
  , CASE
      WHEN not_fifa_hrs_watched_prev_month_before_drops_start<1 THEN '0. low_engaged_non_fifa'
      WHEN not_fifa_hrs_watched_prev_month_before_drops_start<21 THEN '1. med_engaged_non_fifa'
      WHEN not_fifa_hrs_watched_prev_month_before_drops_start>=21 THEN '2. high_engaged_non_fifa'
      ELSE 'error'
    END AS flag_non_fifa_engagement_before_drops_start
  FROM joined_data
)

SELECT * FROM final_data
