--join the data that exists in analysis.dsds_310_fifa_users_pre_drops_start and analysis.dsds_310_fifa_linked_accounts

CREATE TABLE analysis.dsds_310_fifa_final_data AS
WITH

fifa_users AS (
  SELECT user_id, flag_fifa_engagement_before_drops_start, flag_non_fifa_engagement_before_drops_start
    , fifa_hrs_watched_prev_month_before_drops_start
    , not_fifa_hrs_watched_prev_month_before_drops_start
    , fifa_hrs_watched_prev_month_before_drops_start::FLOAT/30 AS avg_daily_fifa_hrs_watch_before_drops_start
    , not_fifa_hrs_watched_prev_month_before_drops_start::FLOAT/30 AS avg_daily_not_fifa_hrs_watch_before_drops_start
  FROM analysis.dsds_310_fifa_users_pre_drops_start
)

, fifa_link_accounts AS (
  SELECT user_id, flag_is_linked_phase1, flag_is_linked_phase2, flag_is_linked_phase3, flag_is_linked_phase4
  FROM analysis.dsds_310_fifa_linked_accounts
)

, join_fifa_users_fifa_links AS (
  SELECT base.*
    , NVL(flag_is_linked_phase1, 0) AS flag_is_linked_phase1
    , NVL(flag_is_linked_phase2, 0) AS flag_is_linked_phase2
    , NVL(flag_is_linked_phase3, 0) AS flag_is_linked_phase3
    , NVL(flag_is_linked_phase4, 0) AS flag_is_linked_phase4
    , NVL(flag_is_linked_phase1, 0) + NVL(flag_is_linked_phase2, 0) + NVL(flag_is_linked_phase3, 0) + NVL(flag_is_linked_phase4, 0) AS total_linked_phases
  FROM fifa_users AS base
  LEFT JOIN fifa_link_accounts AS link ON base.user_id = link.user_id
)

--there are 4 "phases" of the fifa drops campaigns
--phase 1= 2018-01-26 04:00 to 2018-01-28 14:00
--phase 2= 2018-04-13 04:00 to 2018-04-15 13:30
--phase 3= 2018-05-28 05:00 to 2018-06-03 12:00
--phase 4= 2018-08-02 03:00 to 2018-08-04 14:00
, fifa_campaign_mw_per_user AS (
  SELECT user_id
    , DATEDIFF(hours, '2018-01-26 04:00:00', '2018-01-28 14:00:00')::FLOAT /24 AS num_days_1a_during_phase1
    , DATEDIFF(hours, '2018-01-28 14:00:00', '2018-04-13 04:00:00')::FLOAT /24 AS num_days_1b_post_phase1
    , DATEDIFF(hours, '2018-04-13 04:00:00', '2018-04-15 13:30:00')::FLOAT /24 AS num_days_2a_during_phase2
    , DATEDIFF(hours, '2018-04-15 13:30:00', '2018-05-28 05:00:00')::FLOAT /24 AS num_days_2b_post_phase2
    , DATEDIFF(hours, '2018-05-28 05:00:00', '2018-06-03 12:00:00')::FLOAT /24 AS num_days_3a_during_phase3
    , DATEDIFF(hours, '2018-06-03 12:00:00', '2018-08-02 03:00:00')::FLOAT /24 AS num_days_3b_post_phase3
    , DATEDIFF(hours, '2018-08-02 03:00:00', '2018-08-04 14:00:00')::FLOAT /24 AS num_days_4a_during_phase4
    , DATEDIFF(hours, '2018-08-04 14:00:00', '2018-11-27 04:00:00')::FLOAT /24 AS num_days_4b_post_phase4

    , SUM(CASE WHEN the_campaign_phase='1a_during_phase1' AND flag_is_fifa=1 THEN one_min_watch ELSE 0 END) AS total_fifa_mw_1a_during_phase1
    , SUM(CASE WHEN the_campaign_phase='1b_post_phase1' AND flag_is_fifa=1 THEN one_min_watch ELSE 0 END) AS total_fifa_mw_1b_post_phase1
    , SUM(CASE WHEN the_campaign_phase='2a_during_phase2' AND flag_is_fifa=1 THEN one_min_watch ELSE 0 END) AS total_fifa_mw_2a_during_phase2
    , SUM(CASE WHEN the_campaign_phase='2b_post_phase2' AND flag_is_fifa=1 THEN one_min_watch ELSE 0 END) AS total_fifa_mw_2b_post_phase2
    , SUM(CASE WHEN the_campaign_phase='3a_during_phase3' AND flag_is_fifa=1 THEN one_min_watch ELSE 0 END) AS total_fifa_mw_3a_during_phase3
    , SUM(CASE WHEN the_campaign_phase='3b_post_phase3' AND flag_is_fifa=1 THEN one_min_watch ELSE 0 END) AS total_fifa_mw_3b_post_phase3
    , SUM(CASE WHEN the_campaign_phase='4a_during_phase4' AND flag_is_fifa=1 THEN one_min_watch ELSE 0 END) AS total_fifa_mw_4a_during_phase4
    , SUM(CASE WHEN the_campaign_phase='4b_post_phase4' AND flag_is_fifa=1 THEN one_min_watch ELSE 0 END) AS total_fifa_mw_4b_post_phase4

    , SUM(CASE WHEN the_campaign_phase='1a_during_phase1' AND flag_is_fifa=1 THEN one_min_watch ELSE 0 END)::FLOAT / (DATEDIFF(hours, '2018-01-26 04:00:00', '2018-01-28 14:00:00')::FLOAT /24) AS avg_daily_fifa_mw_1a_during_phase1
    , SUM(CASE WHEN the_campaign_phase='1b_post_phase1' AND flag_is_fifa=1 THEN one_min_watch ELSE 0 END)::FLOAT / (DATEDIFF(hours, '2018-01-28 14:00:00', '2018-04-13 04:00:00')::FLOAT /24) AS avg_daily_fifa_mw_1b_post_phase1
    , SUM(CASE WHEN the_campaign_phase='2a_during_phase2' AND flag_is_fifa=1 THEN one_min_watch ELSE 0 END)::FLOAT / (DATEDIFF(hours, '2018-04-13 04:00:00', '2018-04-15 13:30:00')::FLOAT /24) AS avg_daily_fifa_mw_2a_during_phase2
    , SUM(CASE WHEN the_campaign_phase='2b_post_phase2' AND flag_is_fifa=1 THEN one_min_watch ELSE 0 END)::FLOAT / (DATEDIFF(hours, '2018-04-15 13:30:00', '2018-05-28 05:00:00')::FLOAT /24) AS avg_daily_fifa_mw_2b_post_phase2
    , SUM(CASE WHEN the_campaign_phase='3a_during_phase3' AND flag_is_fifa=1 THEN one_min_watch ELSE 0 END)::FLOAT / (DATEDIFF(hours, '2018-05-28 05:00:00', '2018-06-03 12:00:00')::FLOAT /24) AS avg_daily_fifa_mw_3a_during_phase3
    , SUM(CASE WHEN the_campaign_phase='3b_post_phase3' AND flag_is_fifa=1 THEN one_min_watch ELSE 0 END)::FLOAT / (DATEDIFF(hours, '2018-06-03 12:00:00', '2018-08-02 03:00:00')::FLOAT /24) AS avg_daily_fifa_mw_3b_post_phase3
    , SUM(CASE WHEN the_campaign_phase='4a_during_phase4' AND flag_is_fifa=1 THEN one_min_watch ELSE 0 END)::FLOAT / (DATEDIFF(hours, '2018-08-02 03:00:00', '2018-08-04 14:00:00')::FLOAT /24) AS avg_daily_fifa_mw_4a_during_phase4
    , SUM(CASE WHEN the_campaign_phase='4b_post_phase4' AND flag_is_fifa=1 THEN one_min_watch ELSE 0 END)::FLOAT / (DATEDIFF(hours, '2018-08-04 14:00:00', '2018-11-27 04:00:00')::FLOAT /24) AS avg_daily_fifa_mw_4b_post_phase4

    , SUM(CASE WHEN the_campaign_phase='1a_during_phase1' AND flag_is_fifa=0 THEN one_min_watch ELSE 0 END) AS total_not_fifa_mw_1a_during_phase1
    , SUM(CASE WHEN the_campaign_phase='1b_post_phase1' AND flag_is_fifa=0 THEN one_min_watch ELSE 0 END) AS total_not_fifa_mw_1b_post_phase1
    , SUM(CASE WHEN the_campaign_phase='2a_during_phase2' AND flag_is_fifa=0 THEN one_min_watch ELSE 0 END) AS total_not_fifa_mw_2a_during_phase2
    , SUM(CASE WHEN the_campaign_phase='2b_post_phase2' AND flag_is_fifa=0 THEN one_min_watch ELSE 0 END) AS total_not_fifa_mw_2b_post_phase2
    , SUM(CASE WHEN the_campaign_phase='3a_during_phase3' AND flag_is_fifa=0 THEN one_min_watch ELSE 0 END) AS total_not_fifa_mw_3a_during_phase3
    , SUM(CASE WHEN the_campaign_phase='3b_post_phase3' AND flag_is_fifa=0 THEN one_min_watch ELSE 0 END) AS total_not_fifa_mw_3b_post_phase3
    , SUM(CASE WHEN the_campaign_phase='4a_during_phase4' AND flag_is_fifa=0 THEN one_min_watch ELSE 0 END) AS total_not_fifa_mw_4a_during_phase4
    , SUM(CASE WHEN the_campaign_phase='4b_post_phase4' AND flag_is_fifa=0 THEN one_min_watch ELSE 0 END) AS total_not_fifa_mw_4b_post_phase4

    , SUM(CASE WHEN the_campaign_phase='1a_during_phase1' AND flag_is_fifa=0 THEN one_min_watch ELSE 0 END)::FLOAT / (DATEDIFF(hours, '2018-01-26 04:00:00', '2018-01-28 14:00:00')::FLOAT /24) AS avg_daily_not_fifa_mw_1a_during_phase1
    , SUM(CASE WHEN the_campaign_phase='1b_post_phase1' AND flag_is_fifa=0 THEN one_min_watch ELSE 0 END)::FLOAT / (DATEDIFF(hours, '2018-01-28 14:00:00', '2018-04-13 04:00:00')::FLOAT /24) AS avg_daily_not_fifa_mw_1b_post_phase1
    , SUM(CASE WHEN the_campaign_phase='2a_during_phase2' AND flag_is_fifa=0 THEN one_min_watch ELSE 0 END)::FLOAT / (DATEDIFF(hours, '2018-04-13 04:00:00', '2018-04-15 13:30:00')::FLOAT /24) AS avg_daily_not_fifa_mw_2a_during_phase2
    , SUM(CASE WHEN the_campaign_phase='2b_post_phase2' AND flag_is_fifa=0 THEN one_min_watch ELSE 0 END)::FLOAT / (DATEDIFF(hours, '2018-04-15 13:30:00', '2018-05-28 05:00:00')::FLOAT /24) AS avg_daily_not_fifa_mw_2b_post_phase2
    , SUM(CASE WHEN the_campaign_phase='3a_during_phase3' AND flag_is_fifa=0 THEN one_min_watch ELSE 0 END)::FLOAT / (DATEDIFF(hours, '2018-05-28 05:00:00', '2018-06-03 12:00:00')::FLOAT /24) AS avg_daily_not_fifa_mw_3a_during_phase3
    , SUM(CASE WHEN the_campaign_phase='3b_post_phase3' AND flag_is_fifa=0 THEN one_min_watch ELSE 0 END)::FLOAT / (DATEDIFF(hours, '2018-06-03 12:00:00', '2018-08-02 03:00:00')::FLOAT /24) AS avg_daily_not_fifa_mw_3b_post_phase3
    , SUM(CASE WHEN the_campaign_phase='4a_during_phase4' AND flag_is_fifa=0 THEN one_min_watch ELSE 0 END)::FLOAT / (DATEDIFF(hours, '2018-08-02 03:00:00', '2018-08-04 14:00:00')::FLOAT /24) AS avg_daily_not_fifa_mw_4a_during_phase4
    , SUM(CASE WHEN the_campaign_phase='4b_post_phase4' AND flag_is_fifa=0 THEN one_min_watch ELSE 0 END)::FLOAT / (DATEDIFF(hours, '2018-08-04 14:00:00', '2018-11-27 04:00:00')::FLOAT /24) AS avg_daily_not_fifa_mw_4b_post_phase4

  FROM analysis.dsds_310_fifa_campaign_mw
  GROUP BY 1
)




, join_mw AS (
  SELECT base.*
    , mw.num_days_1a_during_phase1
    , mw.num_days_1b_post_phase1
    , mw.num_days_2a_during_phase2
    , mw.num_days_2b_post_phase2
    , mw.num_days_3a_during_phase3
    , mw.num_days_3b_post_phase3
    , mw.num_days_4a_during_phase4
    , mw.num_days_4b_post_phase4
    , mw.total_fifa_mw_1a_during_phase1
    , mw.total_fifa_mw_1b_post_phase1
    , mw.total_fifa_mw_2a_during_phase2
    , mw.total_fifa_mw_2b_post_phase2
    , mw.total_fifa_mw_3a_during_phase3
    , mw.total_fifa_mw_3b_post_phase3
    , mw.total_fifa_mw_4a_during_phase4
    , mw.total_fifa_mw_4b_post_phase4
    , mw.avg_daily_fifa_mw_1a_during_phase1
    , mw.avg_daily_fifa_mw_1b_post_phase1
    , mw.avg_daily_fifa_mw_2a_during_phase2
    , mw.avg_daily_fifa_mw_2b_post_phase2
    , mw.avg_daily_fifa_mw_3a_during_phase3
    , mw.avg_daily_fifa_mw_3b_post_phase3
    , mw.avg_daily_fifa_mw_4a_during_phase4
    , mw.avg_daily_fifa_mw_4b_post_phase4
    , mw.total_not_fifa_mw_1a_during_phase1
    , mw.total_not_fifa_mw_1b_post_phase1
    , mw.total_not_fifa_mw_2a_during_phase2
    , mw.total_not_fifa_mw_2b_post_phase2
    , mw.total_not_fifa_mw_3a_during_phase3
    , mw.total_not_fifa_mw_3b_post_phase3
    , mw.total_not_fifa_mw_4a_during_phase4
    , mw.total_not_fifa_mw_4b_post_phase4
    , mw.avg_daily_not_fifa_mw_1a_during_phase1
    , mw.avg_daily_not_fifa_mw_1b_post_phase1
    , mw.avg_daily_not_fifa_mw_2a_during_phase2
    , mw.avg_daily_not_fifa_mw_2b_post_phase2
    , mw.avg_daily_not_fifa_mw_3a_during_phase3
    , mw.avg_daily_not_fifa_mw_3b_post_phase3
    , mw.avg_daily_not_fifa_mw_4a_during_phase4
    , mw.avg_daily_not_fifa_mw_4b_post_phase4
  FROM join_fifa_users_fifa_links AS base
  LEFT JOIN fifa_campaign_mw_per_user AS mw ON base.user_id = mw.user_id
)


SELECT * FROM join_mw
