WITH
the_extension_states AS (
SELECT 'Testing' AS state --'1. Local Testing'
UNION ALL SELECT 'Assets Uploaded' AS state --'2. Hosted Testing'
UNION ALL SELECT 'In Review' AS state --'3. In Review'
UNION ALL SELECT 'Approved' AS state --'4. Approved'
UNION ALL SELECT 'Released' AS state --'5. Released'
)
, the_extension_names AS (
SELECT DISTINCT extension_name, extension_id
FROM analysis.released_extensions_latest
)
, the_extension_logs AS (
SELECT extension_id, extension_version, "time", state
FROM logs.extension_lifecycle
WHERE state IN (SELECT state FROM the_extension_states)
AND extension_id IN (SELECT extension_id FROM the_extension_names)
)
, the_extension_list AS (
SELECT DISTINCT extension_id, extension_version
FROM logs.extension_lifecycle
WHERE extension_id IN (SELECT extension_id FROM the_extension_names)
)
, the_extensions_logs_step1 AS (
SELECT *, CASE WHEN step1_testing_time IS NULL THEN 0 ELSE 1 END AS step1_testing_flag
FROM (
SELECT extension_id, extension_version, MAX(time) AS step1_testing_time
FROM the_extension_logs WHERE state = 'Testing' GROUP BY 1,2)
)
, the_extensions_logs_step2 AS (
SELECT *, CASE WHEN step2_upload_time IS NULL THEN 0 ELSE 1 END AS step2_upload_flag
FROM (
SELECT extension_id, extension_version, MAX(time) AS step2_upload_time
FROM the_extension_logs WHERE state = 'Assets Uploaded' GROUP BY 1,2)
)
, the_extensions_logs_step3 AS (
SELECT *, CASE WHEN step3_review_time IS NULL THEN 0 ELSE 1 END AS step3_review_flag
FROM (
SELECT extension_id, extension_version, MAX(time) AS step3_review_time
FROM the_extension_logs WHERE state = 'In Review' GROUP BY 1,2)
)
, the_extensions_logs_step4 AS (
SELECT *, CASE WHEN step4_approve_time IS NULL THEN 0 ELSE 1 END AS step4_approve_flag
FROM (
SELECT extension_id, extension_version, MAX(time) AS step4_approve_time
FROM the_extension_logs WHERE state = 'Approved' GROUP BY 1,2)
)
, the_extensions_logs_step5 AS (
SELECT *, CASE WHEN step5_release_time IS NULL THEN 0 ELSE 1 END AS step5_release_flag
FROM (
SELECT extension_id, extension_version, MAX(time) AS step5_release_time
FROM the_extension_logs WHERE state = 'Released' GROUP BY 1,2)
)


SELECT *
, CASE WHEN step5_release_flag=1 THEN '5. Released'
WHEN step4_approve_flag=1 THEN '4. Approved'
WHEN step3_review_flag=1 THEN '3. In Review'
WHEN step2_upload_flag=1 THEN '2. Hosted Testing'
WHEN step1_testing_flag=1 THEN '1. Local Testing'
ELSE '0. Unknown' END AS latest_status
, CASE WHEN step5_release_flag=1 THEN step5_release_time
WHEN step4_approve_flag=1 THEN step4_approve_time
WHEN step3_review_flag=1 THEN step3_review_time
WHEN step2_upload_flag=1 THEN step2_upload_time
WHEN step1_testing_flag=1 THEN step1_testing_time
ELSE '2000-01-01 00:00:00' END AS latest_status
FROM
(
SELECT tel.*, tels1.step1_testing_time, tels1.step1_testing_flag
, tels2.step2_upload_time, tels2.step2_upload_flag
, tels3.step3_review_time, tels3.step3_review_flag
, tels4.step4_approve_time, tels4.step4_approve_flag
, tels5.step5_release_time, tels5.step5_release_flag
FROM the_extension_list AS tel
LEFT JOIN the_extensions_logs_step1 AS tels1 ON tel.extension_id = tels1.extension_id AND tel.extension_version = tels1.extension_version
LEFT JOIN the_extensions_logs_step2 AS tels2 ON tel.extension_id = tels2.extension_id AND tel.extension_version = tels2.extension_version
LEFT JOIN the_extensions_logs_step3 AS tels3 ON tel.extension_id = tels3.extension_id AND tel.extension_version = tels3.extension_version
LEFT JOIN the_extensions_logs_step4 AS tels4 ON tel.extension_id = tels4.extension_id AND tel.extension_version = tels4.extension_version
LEFT JOIN the_extensions_logs_step5 AS tels5 ON tel.extension_id = tels5.extension_id AND tel.extension_version = tels5.extension_version
)
ORDER BY extension_id, extension_version
