DROP TABLE analysis.dsds_343_stream_sessions_one_streamer;
CREATE TABLE analysis.dsds_343_stream_sessions_one_streamer AS

WITH
the_constants AS (
  SELECT 49415591 AS channel_id --lil_lexi
    , '2018-06-01'::TIMESTAMP AS start_time
    , '2018-12-01'::TIMESTAMP AS end_time
)
, r6_streamers AS (
  SELECT * FROM tahoe_analysis.dsds_343_rainbow6_similar_streamers WHERE flag_exclude = FALSE AND channel_id_streamer = 49415591 --lil_lexi
)
, the_channels AS (
  SELECT channel_id_streamer AS channel_id, streamer AS login, 'treatment' AS the_group FROM r6_streamers GROUP BY 1,2,3
  UNION ALL SELECT channel_id_competitor AS channel_id, competitor AS login, 'control' AS the_group FROM r6_streamers GROUP BY 1,2,3
)

, the_jax_data AS (
  SELECT usher_id AS broadcast_id, rails_channel_id AS channel_id, rails_channel AS channel--, rails_title AS broadcast_title, rails_meta_game AS game
    , MIN("time") AS start_time, MAX("time") AS end_time
  FROM logs.jax_live_channel
  WHERE
    usher_id IS NOT NULL AND rails_channel_id IS NOT NULL
    AND rails_channel_id IN (SELECT channel_id FROM the_channels) --OPTIONAL
    AND "time">=(SELECT start_time FROM the_constants) --OPTIONAL
    AND "time"<(SELECT end_time FROM the_constants) --OPTIONAL
  GROUP BY 1,2,3--,4,5
)


-- NOTE: SOMETIMES YOU HAVE CONSECUTIVE SESSIONS OF 5-10 MINS HAPPENING ONE RIGHT AFTER THE OTHER, THIS SHOULD BE SAME SESSION BUT usher_id SAYS ITS DIFFERENT SESSION
, the_stream_sessions AS (
  SELECT * FROM (
    SELECT *, ROUND(DATEDIFF(seconds, start_time, end_time)::FLOAT / 60) AS stream_length_mins, ROUND(DATEDIFF(seconds, start_time, end_time)::FLOAT / 60) / 60 AS stream_length_hours
    FROM the_jax_data
  )
  WHERE stream_length_mins>=30
)
, final_data AS (
  SELECT base.*
    , the_channels.the_group
    , CASE
        WHEN start_time<'2018-07-31' THEN '0_before_promo' --Promo period from 2018-07-30 to 2018-09-10
        WHEN start_time>='2018-07-31' AND start_time<'2018-09-11' THEN '1_during_promo' --Promo period from 2018-07-30 to 2018-09-10
        WHEN start_time>='2018-09-11' THEN '2_after_promo' --Promo period from 2018-07-30 to 2018-09-10
        ELSE 'error'
      END AS the_time_period
  FROM the_stream_sessions AS base
  LEFT JOIN the_channels ON base.channel_id = the_channels.channel_id
)

SELECT * FROM final_data
ORDER BY channel_id, start_time;
