--prime subs data is off for some reason, see https://modeanalytics.com/editor/twitch/reports/81530ac37bb3#
DROP TABLE analysis.dsds_343_paid_gift_subs_all_streamer;
CREATE TABLE analysis.dsds_343_paid_gift_subs_all_streamer AS

WITH
the_constants AS (
  SELEcT 49415591 AS channel_id --lil_lexi
    , '2018-12-01' AS start_time
    , '2019-01-01' AS end_time
)

, r6_streamers AS (
  SELECT * FROM tahoe_analysis.dsds_343_rainbow6_similar_streamers WHERE flag_exclude = FALSE --AND channel_id_streamer = 49415591 --lil_lexi
)
, the_channels AS (
  SELECT channel_id_streamer AS channel_id, streamer AS login, 'treatment' AS the_group FROM r6_streamers GROUP BY 1,2,3
  UNION ALL SELECT channel_id_competitor AS channel_id, competitor AS login, 'control' AS the_group FROM r6_streamers GROUP BY 1,2,3
)


, subscription_payment AS (
  SELECT
    DATE_TRUNC('day', recognized_on) AS the_subscription_day
    , recognized_on AS "time"
    , payment_provider, product_type
    , CASE WHEN DATE_TRUNC('day', recognized_on) = DATE_TRUNC('day', "time") THEN 'new_sub' ELSE 'prev_recurring_sub' END AS flag_new_old_sub
    , CASE
      WHEN is_gift = TRUE OR is_mystery_gift = TRUE THEN '3. gift_sub'
      WHEN payment_provider='samus' AND product_type='turbo' THEN 'prime_linking'
      WHEN payment_provider='samus' AND product_type!='turbo' THEN '2. prime_sub'
      WHEN payment_provider!='samus' AND product_type='turbo' THEN 'turbo_sub'
      WHEN payment_provider!='samus' AND product_type!='turbo' THEN '1. channel_sub'
      ELSE 'other'
    END AS flag_subscription_type
    , is_gift, is_mystery_gift, quantity, tier
    , purchaser_user_id, recipient_user_id, channel_id
  FROM logs.subscription_payment
  WHERE

    recognized_on>='2018-06-01' AND recognized_on<'2018-12-01'
    AND purchaser_login NOT like 'subs_qa_%'
    AND purchaser_login NOT in ('payments_test', 'payments_test2', 'amazon_test', 'michael_test')
    AND payment_provider NOT IN ('test', 'admin')
    AND product NOT IN ('owlallaccess2018','twitchprime2')
    AND channel_id IN (SELEcT channel_id FROM the_channels)
    --AND recognized_on>=(SELECT start_time FROM the_constants) AND recognized_on<(SELECT end_time FROM the_constants) --get december 2018 data only
)



, paid_subs AS (
  SELECT "time", DATE_TRUNC('month', "time") AS the_month, channel_id, flag_subscription_type, tier, COUNT(1) AS num_subs--, COUNT(DISTINCT purchaser_user_id) AS purchasers, COUNT(1) AS ROWS
  FROM subscription_payment
  WHERE flag_subscription_type = '1. channel_sub'
  AND channel_id IN (SELEcT channel_id FROM the_channels)
  GROUP BY 1,2,3,4,5
)
, gift_subs AS (
  SELECT "time", DATE_TRUNC('month', "time") AS the_month, channel_id, flag_subscription_type, tier, sum(case when is_mystery_gift = true then quantity  else 1 end ) as num_subs--, COUNT(DISTINCT purchaser_user_id) AS purchasers, COUNT(1) AS ROWS
  FROM subscription_payment
  WHERE flag_subscription_type = '3. gift_sub'
  AND channel_id IN (SELEcT channel_id FROM the_channels)
  GROUP BY 1,2,3,4,5
)

, final_data AS (
  SELEcT * FROM paid_subs
  UNION ALL SELECT * FROM gift_subs
)

SELECT * FROM final_data;
