WITH
the_constants_drops AS (
  SELECT start_time, end_time, channel_id::BIGINT, game::VARCHAR, start_time::DATE AS start_date, end_time::DATE AS end_date
    , regexp_replace(lower(game::VARCHAR),'([^a-z.])','') as game_flattened
  FROM tahoe_analysis.dsds_351_drops_history
)

, viewers_log AS (
  SELECT "time", device_id, user_id, channel_id, game, regexp_replace(lower(game::VARCHAR),'([^a-z.])','') as game_flattened
  FROM tahoe."video-play"
  WHERE
        DATE>=(SELECT MIN(start_date) FROM the_constants_drops)
    AND DATE<=(SELECT MAX(end_date) FROM the_constants_drops)
    AND channel_id IN (SELECT channel_id FROM the_constants_drops GROUP BY 1)
    AND regexp_replace(lower(game::VARCHAR),'([^a-z.])','') IN (SELECT game_flattened FROM the_constants_drops GROUP BY 1)
    AND live = TRUE
    AND device_id NOT IN ('0', '0000000000000000', '00000000000000000000000000000000', '(null)')
)

, drops_viewers_log AS (
  SELECT base.*
  FROM viewers_log AS base
  RIGHT JOIN the_constants_drops AS drops
    ON drops.start_time<=base.time AND base.time<=drops.end_time
    AND drops.channel_id = base.channel_id
    AND drops.game = base.game
)

SELECT game, COUNT(1) AS rows, COUNT(DISTINCT device_id) AS devices
  , COUNT(DISTINCT user_id)  AS users, COUNT(DISTINCT channel_id) AS channels
FROM drops_viewers_log
GROUP BY 1
ORDER BY 1

-- , viewers_log_time_bound AS (
--   SELECT *
--   FROM (
--     SELECT device_id, user_id, FIRST_VALUE("time") OVER (PARTITION BY device_id) AS first_drops_view_time
--     FROM drops_viewers_log
--   )
--   GROUP BY 1,2,3
-- )
--
-- SELECT * FROM viewers_log_time_bound ORDER BY 1,2,3
-- SELECT * FROM drops_viewers_log LIMIT 100
