-- DROP TABLE IF EXISTS analysis.dsds353_channel_daily_status_2019_update;
-- CREATE TABLE    analysis.dsds353_channel_daily_status_2019_update    AS
  WITH
  the_parameter_input AS (
    SELECT '2017-01-01'::TIMESTAMP AS the_day_we_run_script
    --SELECT DATE_TRUNC('day', (SYSDATE - INTERVAL '7 hours')) AS the_day_we_run_script
  )
  -- , the_constants_time AS (
  --   SELECT (SELECT the_day_we_run_script - INTERVAL '1 days' FROM the_parameter_input) AS the_date
  --     , (SELECT the_day_we_run_script - INTERVAL '30 days' FROM the_parameter_input) AS start_time_rolling_30 --Greater Than Equal To (>=) this timestamp
  --     , (SELECT the_day_we_run_script - INTERVAL '1 seconds' FROM the_parameter_input)  AS end_time_rolling_30 -- Less Than Equal To (<=) this timestamp
  --
  --     -- avg_ccu_past_7_days      FLOAT,
  --     -- avg_ccu_past_14_days     FLOAT,
  --     -- avg_ccu_past_30_days     FLOAT,
  --     -- avg_ccu_past_90_days     FLOAT,
  --     -- avg_ccu_past_180_days    FLOAT,
  --     -- avg_ccu_past_360_days    FLOAT,
  -- )

  -- take channels that have streamed at least once from 2016-01-01 onward
  , eligible_channels AS (
    SELECT channel_id, MIN(date) AS min_ccu_date
    FROM tahoe.channel_concurrents
    WHERE "date" >= '2016-01-01 00:00:00'
    GROUP BY 1
  )

  --returns a list of channel_id that we should run the data for
  --it will return the channel_id if they ever streamed since 2016-01-01
  , day_channel_matrix AS (
    SELECT *
      , DATEDIFF ( second, start_time_rolling_7, end_time_rolling_7 )::FLOAT/86400 AS num_days_rolling_7 --this is used just to verify that we are taking a 30 day snapshot
      , DATEDIFF ( second, start_time_rolling_14, end_time_rolling_14 )::FLOAT/86400 AS num_days_rolling_14 --this is used just to verify that we are taking a 30 day snapshot
      , DATEDIFF ( second, start_time_rolling_30, end_time_rolling_30 )::FLOAT/86400 AS num_days_rolling_30 --this is used just to verify that we are taking a 30 day snapshot
      , DATEDIFF ( second, start_time_rolling_90, end_time_rolling_90 )::FLOAT/86400 AS num_days_rolling_90 --this is used just to verify that we are taking a 30 day snapshot
      , DATEDIFF ( second, start_time_rolling_180, end_time_rolling_180 )::FLOAT/86400 AS num_days_rolling_180 --this is used just to verify that we are taking a 30 day snapshot
      , DATEDIFF ( second, start_time_rolling_360, end_time_rolling_360 )::FLOAT/86400 AS num_days_rolling_360 --this is used just to verify that we are taking a 30 day snapshot
    FROM (
      SELECT d."date" AS day
        , ec.channel_id
        , (d."date" - INTERVAL '6 days') AS start_time_rolling_7
        , (d."date" + INTERVAL '1 days' - INTERVAL '1 seconds') AS end_time_rolling_7
        , (d."date" - INTERVAL '13 days') AS start_time_rolling_14
        , (d."date" + INTERVAL '1 days' - INTERVAL '1 seconds') AS end_time_rolling_14
        , (d."date" - INTERVAL '29 days') AS start_time_rolling_30
        , (d."date" + INTERVAL '1 days' - INTERVAL '1 seconds') AS end_time_rolling_30
        , (d."date" - INTERVAL '89 days') AS start_time_rolling_90
        , (d."date" + INTERVAL '1 days' - INTERVAL '1 seconds') AS end_time_rolling_90
        , (d."date" - INTERVAL '179 days') AS start_time_rolling_180
        , (d."date" + INTERVAL '1 days' - INTERVAL '1 seconds') AS end_time_rolling_180
        , (d."date" - INTERVAL '359 days') AS start_time_rolling_360
        , (d."date" + INTERVAL '1 days' - INTERVAL '1 seconds') AS end_time_rolling_360
      FROM eligible_channels ec
      INNER JOIN metadata."date" d ON d."date" >= ec.min_ccu_date
      WHERE d."date" >= (SELECT the_day_we_run_script - INTERVAL '1 days' FROM the_parameter_input)
      AND   d."date" < (SELECT the_day_we_run_script FROM the_parameter_input)--DATE_TRUNC('day',SYSDATE)
    )
  )
  -- SELECT * FROM day_channel_matrix WHERE channel_id = 67955580 --chewiemelodies
  -- ;

  --get all the ccu logs for all eligible_channels during the rolling 7 time period
  , ccu_log_rolling_7 AS (
    SELECT dcm.*, ccu."time", ccu.total
    FROM logs.channel_concurrents AS ccu
    RIGHT JOIN day_channel_matrix AS dcm
      ON ccu.channel_id = dcm.channel_id
      AND dcm.start_time_rolling_7 <= ccu.time AND ccu.time<=dcm.end_time_rolling_7
  )

  --get the per day per channel_id aggregated ccu and mb stats during the rolling 7 time period
  , ccu_aggregated_rolling_7 AS (
    SELECT day AS the_date, channel_id, start_time_rolling_7, end_time_rolling_7
    , AVG(total::FLOAT) AS avg_ccu_rolling_7, COUNT(1) AS mins_broadcast_rolling_7
    , COUNT(1)::FLOAT/7 AS avg_mb_per_day_rolling_7
    FROM ccu_log_rolling_7
    GROUP BY 1,2,3,4
  )

  -- --get all the ccu logs for all eligible_channels during the rolling 14 time period
  -- , ccu_log_rolling_14 AS (
  --   SELECT dcm.*, ccu."time", ccu.total
  --   FROM logs.channel_concurrents AS ccu
  --   RIGHT JOIN day_channel_matrix AS dcm
  --     ON ccu.channel_id = dcm.channel_id
  --     AND dcm.start_time_rolling_14 <= ccu.time AND ccu.time<=dcm.end_time_rolling_14
  -- )
  --
  -- --get the per day per channel_id aggregated ccu and mb stats during the rolling 14 time period
  -- , ccu_aggregated_rolling_14 AS (
  --   SELECT day AS the_date, channel_id, start_time_rolling_14, end_time_rolling_14
  --   , AVG(total::FLOAT) AS avg_ccu_rolling_14, COUNT(1) AS mins_broadcast_rolling_14
  --   , COUNT(1)::FLOAT/14 AS avg_mb_per_day_rolling_14
  --   FROM ccu_log_rolling_14
  --   GROUP BY 1,2,3,4
  -- )

  --get all the ccu logs for all eligible_channels during the rolling 30 time period
  , ccu_log_rolling_30 AS (
    SELECT dcm.*, ccu."time", ccu.total
    FROM logs.channel_concurrents AS ccu
    RIGHT JOIN day_channel_matrix AS dcm
      ON ccu.channel_id = dcm.channel_id
      AND dcm.start_time_rolling_30 <= ccu.time AND ccu.time<=dcm.end_time_rolling_30
  )

  --get the per day per channel_id aggregated ccu and mb stats during the rolling 30 time period
  , ccu_aggregated_rolling_30 AS (
    SELECT day AS the_date, channel_id, start_time_rolling_30, end_time_rolling_30
    , AVG(total::FLOAT) AS avg_ccu_rolling_30, COUNT(1) AS mins_broadcast_rolling_30
    , COUNT(1)::FLOAT/30 AS avg_mb_per_day_rolling_30
    FROM ccu_log_rolling_30
    GROUP BY 1,2,3,4
  )

  -- --get all the ccu logs for all eligible_channels during the rolling 90 time period
  -- , ccu_log_rolling_90 AS (
  --   SELECT dcm.*, ccu."time", ccu.total
  --   FROM logs.channel_concurrents AS ccu
  --   RIGHT JOIN day_channel_matrix AS dcm
  --     ON ccu.channel_id = dcm.channel_id
  --     AND dcm.start_time_rolling_90 <= ccu.time AND ccu.time<=dcm.end_time_rolling_90
  -- )
  --
  -- --get the per day per channel_id aggregated ccu and mb stats during the rolling 90 time period
  -- , ccu_aggregated_rolling_90 AS (
  --   SELECT day AS the_date, channel_id, start_time_rolling_90, end_time_rolling_90
  --   , AVG(total::FLOAT) AS avg_ccu_rolling_90, COUNT(1) AS mins_broadcast_rolling_90
  --   , COUNT(1)::FLOAT/90 AS avg_mb_per_day_rolling_90
  --   FROM ccu_log_rolling_90
  --   GROUP BY 1,2,3,4
  -- )
  --
  -- --get all the ccu logs for all eligible_channels during the rolling 180 time period
  -- , ccu_log_rolling_180 AS (
  --   SELECT dcm.*, ccu."time", ccu.total
  --   FROM logs.channel_concurrents AS ccu
  --   RIGHT JOIN day_channel_matrix AS dcm
  --     ON ccu.channel_id = dcm.channel_id
  --     AND dcm.start_time_rolling_180 <= ccu.time AND ccu.time<=dcm.end_time_rolling_180
  -- )
  --
  -- --get the per day per channel_id aggregated ccu and mb stats during the rolling 180 time period
  -- , ccu_aggregated_rolling_180 AS (
  --   SELECT day AS the_date, channel_id, start_time_rolling_180, end_time_rolling_180
  --   , AVG(total::FLOAT) AS avg_ccu_rolling_180, COUNT(1) AS mins_broadcast_rolling_180
  --   , COUNT(1)::FLOAT/180 AS avg_mb_per_day_rolling_180
  --   FROM ccu_log_rolling_180
  --   GROUP BY 1,2,3,4
  -- )
  --
  -- --get all the ccu logs for all eligible_channels during the rolling 360 time period
  -- , ccu_log_rolling_360 AS (
  --   SELECT dcm.*, ccu."time", ccu.total
  --   FROM logs.channel_concurrents AS ccu
  --   RIGHT JOIN day_channel_matrix AS dcm
  --     ON ccu.channel_id = dcm.channel_id
  --     AND dcm.start_time_rolling_360 <= ccu.time AND ccu.time<=dcm.end_time_rolling_360
  -- )
  --
  -- --get the per day per channel_id aggregated ccu and mb stats during the rolling 360 time period
  -- , ccu_aggregated_rolling_360 AS (
  --   SELECT day AS the_date, channel_id, start_time_rolling_360, end_time_rolling_360
  --   , AVG(total::FLOAT) AS avg_ccu_rolling_360, COUNT(1) AS mins_broadcast_rolling_360
  --   , COUNT(1)::FLOAT/360 AS avg_mb_per_day_rolling_360
  --   FROM ccu_log_rolling_360
  --   GROUP BY 1,2,3,4
  -- )


  -- are they a partner or affiliate at the the_date date? i.e. count end of month status for partner affiliate
  , rollup_partner_affiliate AS (
    SELECT day AS the_date, channel_id, is_partner, is_affiliate
    FROM rollups.affiliates_partners_daily_channel_summary
    WHERE day = (SELECT the_day_we_run_script - INTERVAL '1 days' FROM the_parameter_input)
    GROUP BY 1,2,3,4 --use GROUP BY just in case there are duplicate records
  )
  , meta_partner_affiliate AS (
    SELECT the_date, channel_id
    , CASE
        WHEN is_partner =TRUE THEN 'partner'
        WHEN is_affiliate = TRUE THEN 'affiliate'
        ELSE 'not_partner_affiliate'
      END AS channel_type
    FROM rollup_partner_affiliate
  )

  -- return a row per channel name along with the date they were added and removed to be counted as a "premium" channel
  -- see https://docs.google.com/document/d/1t4WLzTKEsEq1VEsOdA9POCupRtV6fefZfzgMpk9PyJA/edit
  , premium_channel_name as (
    select
      channel
      , min(date_added) as date_added
      , max(date_removed) as date_removed
    from (
      select
        channel
        , case when date_added > '2018-10-01'::date then date_added else to_date('01/01/2000', 'MM/DD/YYYY') end as date_added
        , date_removed
      from (
        select
          lower(channelname) as channel
          , to_date(case when sheet_addition_date > '' then sheet_addition_date else '01/01/2000' end, 'MM/DD/YYYY') as date_added
          , to_date('9999-12-31 00:00:00', 'YYYY-MM-DD HH24:MI:SS') as date_removed
        from analysis.esports_general_channels
        where "type" <> 'UGC Esports'
        group by 1,2,3
      )
      union
      select
        channel
        , to_date(case when date_added::text > '' then date_added else '2000-01-01 00:00:00' end, 'YYYY-MM-DD HH24:MI:SS') as date_added
        , to_date(case when date_removed > '' then date_removed else '9999-12-31 00:00:00' end, 'YYYY-MM-DD HH24:MI:SS') as date_removed
      from analysis.png_whitelist
      group by 1,2,3
    )
    group by 1
  )

  , meta_premium_channel AS (
    SELECT *
    FROM (
      SELECT base.channel, map.user_id AS channel_id, base.date_added, base.date_removed
      FROM premium_channel_name AS base
      LEFT JOIN analysis.user_id_login_mapping_all AS map ON base.channel = map.login
    )
    WHERE channel_id IS NOT NULL
  )

  --take final_data_rolling_30 AS the "base" data for tier and active streamer status
  --this is the opinion from DX team on the standard to use
  , final_data_rolling_30 AS (
    SELECT the_date, channel_id, channel, channel_type, tier_rolling_30 AS tier, active_streamer_status_rolling_30 AS active_streamer_status
      , start_time_rolling_30, end_time_rolling_30, avg_ccu_rolling_30, mins_broadcast_rolling_30, avg_mb_per_day_rolling_30, tier_rolling_30, active_streamer_status_rolling_30
    FROM (
      SELECT base.the_date, base.channel_id, su.login AS channel
        , NVL(mpa.channel_type,'not_partner_affiliate') AS channel_type
        , base.start_time_rolling_30, base.end_time_rolling_30
        , base.avg_ccu_rolling_30, base.mins_broadcast_rolling_30
        , base.avg_mb_per_day_rolling_30
        , CASE
            WHEN mpc.channel IS NOT NULL THEN 'T5: Premium'
            WHEN base.avg_ccu_rolling_30 <= 2 THEN 'T0: 0-2 ccv'
            WHEN base.avg_ccu_rolling_30 <= 10 THEN 'T1: 3-10 ccv'
            WHEN base.avg_ccu_rolling_30 <= 100 THEN  'T2: 11-100 ccv'
            WHEN base.avg_ccu_rolling_30 <= 4000 THEN  'T3: 101-4000 ccv'
            WHEN base.avg_ccu_rolling_30 > 4000 THEN  'T4: 4001+ ccv'
            ELSE 'NULL: NOT STREAM LAST 30 DAYS'
          END AS tier_rolling_30 --new 2019 tiers see https://docs.google.com/document/d/1t4WLzTKEsEq1VEsOdA9POCupRtV6fefZfzgMpk9PyJA/edit#heading=h.l25drnd1o9q5
        , CASE
            WHEN avg_mb_per_day_rolling_30>=10 THEN 'active_streamer'
            ELSE 'not_active_streamer'
          END AS active_streamer_status_rolling_30
      FROM ccu_aggregated_rolling_30 AS base
      LEFT JOIN meta_premium_channel AS mpc ON
        base.channel_id = mpc.channel_id
        AND mpc.date_added <= base.the_date
        AND base.the_date < mpc.date_removed
      LEFT JOIN meta_partner_affiliate AS mpa ON
        base.the_date = mpa.the_date
        AND base.channel_id = mpa.channel_id
      LEFT JOIN db_snapshots.users AS su ON base.channel_id = su.id
      WHERE base.mins_broadcast_rolling_30>=1
    )
  )

  , final_data_rolling_7 AS (
    SELECT base.the_date, base.channel_id
      , NVL(mpa.channel_type,'not_partner_affiliate') AS channel_type
      , base.start_time_rolling_7, base.end_time_rolling_7
      , base.avg_ccu_rolling_7, base.mins_broadcast_rolling_7
      , base.avg_mb_per_day_rolling_7
      , CASE
          WHEN mpc.channel IS NOT NULL THEN 'T5: Premium'
          WHEN base.avg_ccu_rolling_7 <= 2 THEN 'T0: 0-2 ccv'
          WHEN base.avg_ccu_rolling_7 <= 10 THEN 'T1: 3-10 ccv'
          WHEN base.avg_ccu_rolling_7 <= 100 THEN  'T2: 11-100 ccv'
          WHEN base.avg_ccu_rolling_7 <= 4000 THEN  'T3: 101-4000 ccv'
          WHEN base.avg_ccu_rolling_7 > 4000 THEN  'T4: 4001+ ccv'
          ELSE 'NULL: NOT STREAM LAST 7 DAYS'
        END AS tier_rolling_7 --new 2019 tiers see https://docs.google.com/document/d/1t4WLzTKEsEq1VEsOdA9POCupRtV6fefZfzgMpk9PyJA/edit#heading=h.l25drnd1o9q5
      , CASE
          WHEN avg_mb_per_day_rolling_7>=10 THEN 'active_streamer'
          ELSE 'not_active_streamer'
        END AS active_streamer_status_rolling_7
    FROM ccu_aggregated_rolling_7 AS base
    LEFT JOIN meta_premium_channel AS mpc ON
      base.channel_id = mpc.channel_id
      AND mpc.date_added <= base.the_date
      AND base.the_date < mpc.date_removed
    LEFT JOIN meta_partner_affiliate AS mpa ON
      base.the_date = mpa.the_date
      AND base.channel_id = mpa.channel_id
    WHERE base.mins_broadcast_rolling_7>=1
  )

  , final_data AS (
    SELECT base.the_date, base.channel_id, base.channel, base.channel_type, base.tier, base.active_streamer_status
      , start_time_rolling_7, end_time_rolling_7, avg_ccu_rolling_7, mins_broadcast_rolling_7, avg_mb_per_day_rolling_7, tier_rolling_7, active_streamer_status_rolling_7
      , start_time_rolling_30, end_time_rolling_30, avg_ccu_rolling_30, mins_broadcast_rolling_30, avg_mb_per_day_rolling_30, tier_rolling_30, active_streamer_status_rolling_30

    FROM final_data_rolling_30 AS base
    LEFT JOIN final_data_rolling_7 AS roll7 ON base.the_date = roll7.the_date AND base.channel_id = roll7.channel_id
  )

  SELECT *
  FROM final_data WHERE channel_id = 67955580 --chewiemelodies
  ORDER BY 2,1--, "time";
  ;

--
--   SELECT the_date::DATE, start_time_rolling_30, end_time_rolling_30
--     , base.channel_id, su.login AS channel
--     , mins_broadcast, avg_mb_per_day_rolling_30, avg_ccu_rolling_30
--     , active_streamer_status, tier, channel_type
--   FROM final_data AS base
--   LEFT JOIN analysis.sitedb_users AS su ON base.channel_id = su.user_id
-- ;
--
--
--
-- SELECT * FROM analysis.dsds294_channel_daily_status AS base
-- WHERE base.channel_id = 114396840
-- AND base.the_date>='2017-09-01'::TIMESTAMP
-- ORDER BY 1,2;
--
-- SELECT * FROM analysis.dsds294_channel_daily_status AS base
-- WHERE tier='T5: premium content or esports'
-- ORDER BY 1,2
-- ;
--
-- SELECT * FROM analysis.dsds294_channel_daily_status AS base WHERE channel IS NULL;
--
