SELECT the_date, channel_type, COUNT(1) AS rows, COUNT(DISTINCT channel_id) AS channels
FROM (
SELECT day AS the_date, CASE
    WHEN is_partner =TRUE THEN 'partner'
    WHEN is_affiliate = TRUE THEN 'affiliate'
    ELSE 'not_partner_affiliate'
  END AS channel_type
  , channel_id
FROM rollups.affiliates_partners_daily_channel_summary
WHERE day>='2019-04-01'
)
GROUP BY 1,2
ORDER BY 1,2


SELECT day AS the_date, channel_id, is_partner, is_affiliate
FROM rollups.affiliates_partners_daily_channel_summary
WHERE day = (SELECT the_day_we_run_script - INTERVAL '1 days' FROM the_parameter_input)
GROUP BY 1,2,3,4 --use GROUP BY just in case there are duplicate records


SELECT the_date, tier_rolling_1, COUNT(1) AS rows, COUNT(DISTINCT channel_id) AS channels
FROM analysis.dsds294_channel_daily_status
WHERE the_date>='2019-04-01'
GROUP BY 1,2
ORDER BY 1,2
