
--for some users who never change their login, they have one record in logs.login_rename where old_login = new_login
-- i.e. chewiemelodies (67955580)
--for users who never change their login, potentially they won't have a record in logs.login_rename
-- i.e. a_dot_burr (155528531)


-- DROP TABLE IF EXISTS analysis.user_id_login_mapping_all;
-- CREATE TABLE analysis.user_id_login_mapping_all AS



DELETE FROM analysis.user_id_login_mapping_all; --REMOVE OLD RECORDS
INSERT INTO analysis.user_id_login_mapping_all (




WITH
the_constants_users AS (
SELECT 143917159 AS user_id
UNION ALL SELECT 144390223 AS user_id
UNION ALL SELECT 193998137 AS user_id
UNION ALL SELECT 67955580 AS user_id
UNION ALL SELECT 155528531 AS user_id
UNION ALL SELECT 83828553 AS user_id
UNION ALL SELECT 14836307 AS user_id
)

--take all unique pairs of old_login and user_id in logs.login_rename
, login_rename_old AS (
  SELECT user_id, old_login AS login
  FROM logs.login_rename
  --WHERE user_id IN (SELECT user_id FROM the_constants_users)
  GROUP BY 1,2
)

--take all unique pairs of new_login and user_id in logs.login_rename
, login_rename_new AS (
  SELECT user_id, new_login AS login
  FROM logs.login_rename
  --WHERE user_id IN (SELECT user_id FROM the_constants_users)
  GROUP BY 1,2
)

--take all unique pairs of login and id (user_id) in logs.login_rename db_snapshots.users
, dbsnap_users AS (
  SELECT id AS user_id, login
  FROM db_snapshots.users
  --WHERE id IN (SELECT user_id FROM the_constants_users)
  GROUP BY 1,2
)

, union_records AS (
  SELECT * FROM dbsnap_users
  UNION ALL SELECT * FROM login_rename_new
  UNION ALL SELECT * FROM login_rename_old
)

, final_data AS (
  SELECT * FROM union_records GROUP BY 1,2
)

SELECT * FROM final_data
)
;
