--
-- the_constants_game AS (
--   SELECT 'darwinproject' AS game_flattened
--   UNION ALL SELECT 'worldofwarcraft' AS game_flattened
--   UNION ALL SELECT 'pathofexile' AS game_flattened
-- )


WITH


 the_constants_blessed_ugc_extensions AS (
  SELECT 'b761gcvkac6qbwo26ededwf9sluqh0' AS extension_id
  UNION ALL SELECT 'fdpp9vcx5bsz8osxvqii4i9cumwswd' AS extension_id
  UNION ALL SELECT 'y0io0scnvisnnlyga0j0bo5vdxkxgv' AS extension_id
)

, the_constants_time AS (
  SELECT start_time, DATEADD('month',1,start_time) AS end_time
  FROM (SELECT '2019-01-01'::TIMESTAMP AS start_time)
)

, game_map as (
  SELECT * FROM (
    select regexp_replace(lower(game_map),'([^a-z.])','') as game_flattened, *
    from tahoe_analysis.extension_game_mapping
    where game_map is not null
  )
  WHERE extension_id IN (SELECT extension_id FROM the_constants_blessed_ugc_extensions)
)

, the_ugc_streamers AS (
  SELECT channel_id::BIGINT
  FROM analysis.dsds_366_mbr_2019_01
  WHERE tier NOT IN ('T5: Premium', 'NULL: NOT STREAM LAST 30 DAYS')
  GROUP BY 1
)



, hw_all as (
  SELECT CASE WHEN game_map.game_flattened IS NULL THEN 'other_games_w_no_official_extension' ELSE base.game_flattened END AS the_game
    , SUM(mw) AS mw
  FROM (
    select game_flattened, sum(mw_total) as mw
    from rollups.daily_minutes_watched_by_channel_country_game
    where day >= (SELECT start_time FROM the_constants_time) and day < (SELECT end_time FROM the_constants_time)
    --AND game_flattened is not null and game_flattened NOT IN ('irl', 'justchatting', 'music','e32018','talkshowspodcasts','creative','alwayson','vrchat','gamesdemos')
    --AND game_flattened IN (SELECT game_flattened FROM game_map)
    AND channel_id IN (SELECT channel_id FROM the_ugc_streamers)
    group by 1
  ) AS base
  LEFT JOIN game_map ON base.game_flattened = game_map.game_flattened
  GROUP BY 1
)


, extensions as (
  select gm.game_flattened, base.the_day, base.channel_id
  from analysis.dsds_281_extension_daily_channel_presence_all_anchor as base
  join game_map as gm
  on base.extension_id = gm.extension_id
  where base.bool_extension_activated = TRUE
  AND base.channel_id IN (SELECT channel_id FROM the_ugc_streamers)
)



, hw_map as (
  select base.game_flattened, sum(base.mw_total) as mw
  from rollups.daily_minutes_watched_by_channel_country_game as base
  join extensions as ext
  on base.channel_id = ext.channel_id and base.day = ext.the_day and base.game_flattened = ext.game_flattened
  where day >= (SELECT start_time FROM the_constants_time) and day < (SELECT end_time FROM the_constants_time)
  AND base.channel_id IN (SELECT channel_id FROM the_ugc_streamers)
  group by 1
)

, ugc_final as(
  select base.the_game, base.mw, case when hm.mw is null then 0 else hm.mw end as matched_mw
  from hw_all as base
  left join hw_map as hm
  on base.the_game = hm.game_flattened
)

select *, matched_mw::float/mw as pct_mw
from ugc_final
ORDER BY 1
;

--
-- game_flattened  |    mw     | matched_mw |      pct_mw
-- pathofexile     | 519008278 |  395286871 | 0.761619588271769
-- worldofwarcraft | 993277339 |  151420912 | 0.152445753119109
-- darwinproject   |   3037807 |    1733884 | 0.570768320699768
--
-- the_game               |     mw
-- -------------------------------------+-------------
-- pathofexile                         |   518872423
-- other_games_w_no_official_extension | 43794079811
-- darwinproject                       |     3034572
-- worldofwarcraft                     |   992854317
--
--
-- the_game               |     mw
-- -------------------------------------+-------------
-- pathofexile                         |   518872423
-- worldofwarcraft                     |   992854317
-- other_games_w_no_official_extension | 38501480488
-- darwinproject                       |     3034572

--
-- the_game               |     mw      | matched_mw |      pct_mw
-- darwinproject                       |     3034572 |    1731443 | 0.570572390439245
-- other_games_w_no_official_extension | 43794079811 |          0 |                 0
-- pathofexile                         |   518872423 |  395212486 | 0.761675642183821
-- worldofwarcraft                     |   992854317 |  151416965 | 0.152506729746133
