
-- analysis.dsds_366_premium_content_match_extension_2019_01
--numerator = premium mw on days with the extensions activated on the channels
--denominator = total premium mw for the month

with

 the_constants_blessed_premium_extensions AS (
--    Column	     Type
-- extension_id	   VARCHAR(256)
-- extension_name	 VARCHAR(256)
-- extension_url	 VARCHAR(256)
-- flag_is_content_matched	BOOL
  SELECT extension_id FROM analysis.dsds_366_premium_content_match_extension_2019_01 WHERE flag_is_content_matched GROUP BY 1
)

, the_constants_time AS (
  SELECT start_time, DATEADD('month',1,start_time) AS end_time
  FROM (SELECT '2019-01-01'::TIMESTAMP AS start_time)
)

, the_premium_streamers AS (
  SELECT channel_id::BIGINT
  FROM analysis.dsds_366_mbr_2019_01
  WHERE tier IN ('T5: Premium', 'NULL: NOT STREAM LAST 1 DAYS')
  GROUP BY 1
)



, hw_all as (
  select day AS the_day, channel_id, sum(mw_total) as mw
  from rollups.daily_minutes_watched_by_channel
  where day >= (SELECT start_time FROM the_constants_time) and day < (SELECT end_time FROM the_constants_time)
  AND channel_id IN (SELECT channel_id FROM the_premium_streamers)
  group by 1,2
)



, extensions as (
  select base.the_day, base.channel_id, base.bool_extension_activated
  from analysis.dsds_281_extension_daily_channel_presence_all_anchor as base
  where base.bool_extension_activated = TRUE
  AND base.channel_id IN (SELECT channel_id FROM the_premium_streamers)
  AND base.extension_id IN (SELECT extension_id FROM the_constants_blessed_premium_extensions)
  GROUP BY 1,2,3
)



, hw_map as (
  select base.the_day, base.channel_id, mw, bool_extension_activated AS flag_is_content_matched_day
  from hw_all as base
  LEFT JOIN extensions as ext
  on base.channel_id = ext.channel_id and base.the_day = ext.the_day
  group by 1,2,3,4
)

, premium_final as(
  select channel_id, SUM(mw) AS mw, SUM(CASE WHEN flag_is_content_matched_day THEN mw ELSE 0 END) AS matched_mw
  from hw_map
  GROUP BY 1
)

select *, matched_mw::float/mw as pct_mw
from premium_final
;



-- channel_id |     mw     | matched_mw |        pct_mw        
--   28741244 |      32575 |          0 |                    0
--  203574420 |         18 |          0 |                    0
--  212933453 |      15873 |          0 |                    0
--   96399910 |      11648 |          0 |                    0
--  136893234 |         64 |          0 |                    0
--   89357362 |          1 |          0 |                    0
--   74255988 |        182 |          0 |                    0
--  182144693 |      19670 |          0 |                    0
--  131967990 |         18 |          0 |                    0
--   26656197 |    5035604 |          0 |                    0
--   91434204 |          6 |          0 |                    0
--  214677748 |     296991 |          0 |                    0
--  122461130 |     160576 |          0 |                    0
--   36511198 |       5178 |          0 |                    0
--   28717547 |          5 |          0 |                    0
--   28479773 |        112 |          0 |                    0
--  213749122 |   88059702 |          0 |                    0
--   28629460 |        329 |          0 |                    0
--  148362547 |          3 |          0 |                    0
--  195560520 |     144713 |          0 |                    0
--   50244027 |     696412 |     419963 |    0.603038144087121
--  182953678 |     844112 |          0 |                    0
--  121152790 |     304510 |          0 |                    0
--  195205000 |       9841 |          0 |                    0
--   22212874 |       3886 |          0 |                    0
--  102383426 |          8 |          0 |                    0
--   32686914 |    1620795 |          0 |                    0
--   91070599 |    4379758 |          0 |                    0
--  134162634 |         79 |          0 |                    0
--  150996722 |       2802 |          0 |                    0
--   38438547 |      42227 |          0 |                    0
--  157320746 |      59880 |          0 |                    0
--   75864458 |       6680 |          0 |                    0
--  143947758 |       1480 |          0 |                    0
--  205613687 |        237 |          0 |                    0
--  147082528 |      16684 |          0 |                    0
--  195371628 |        124 |          0 |                    0
--  183786127 |     414021 |          0 |                    0
--   72977645 |    1936406 |          0 |                    0
--   75962614 |     464796 |          0 |                    0
--   23973651 |         39 |          0 |                    0
--   30772581 |          2 |          0 |                    0
--  106721972 |     125141 |          0 |                    0
--  127515565 |       2165 |          0 |                    0
--   35631192 |     229406 |          0 |                    0
--   55800350 |         93 |          0 |                    0
--   65171890 |   63510078 |          0 |                    0
--  140840952 |         34 |          0 |                    0
--   74233027 |        374 |          0 |                    0
--   42776357 |   89142473 |          0 |                    0
--   29769280 |       5950 |          0 |                    0
--  150368923 |       7601 |          0 |                    0
--  140133451 |        111 |          0 |                    0
--  191590629 |     188816 |          0 |                    0
--  148018320 |    3168435 |          0 |                    0
--  119448253 |     616061 |          0 |                    0
--   50160915 |     617206 |          0 |                    0
--  124021777 |         14 |          0 |                    0
--   75764662 |     314289 |          0 |                    0
--  106461063 |       5705 |          0 |                    0
--   85118564 |         25 |          0 |                    0
--  145847456 |          1 |          0 |                    0
--  192805101 |     210488 |          0 |                    0
--   87065447 |     407523 |     407523 |                    1
--   41744414 |    8886541 |          0 |                    0
--  134157504 |         65 |          0 |                    0
--   72556476 |         85 |          0 |                    0
--  122590634 |     947320 |          0 |                    0
--   47927788 |    1878045 |          0 |                    0
--  160075583 |   10531210 |          0 |                    0
--  192718746 |       3723 |       3723 |                    1
--  140132906 |         23 |          0 |                    0
--   94437781 |          1 |          0 |                    0
--  118922943 |     984077 |          0 |                    0
--  176743071 |       2098 |          0 |                    0
--  206125674 |          5 |          0 |                    0
--   76280702 |         21 |          0 |                    0
--     614394 |    9649419 |          0 |                    0
--  116957189 |    1136547 |          0 |                    0
--  121159279 |          8 |          0 |                    0
--  189700942 |         16 |          0 |                    0
--   29828548 |        178 |          0 |                    0
--   36513989 |         22 |          0 |                    0
--  156567621 |   24626362 |          0 |                    0
--   42028111 |    2541635 |          0 |                    0
--  123425775 |     124807 |          0 |                    0
--  107551531 |   12588345 |          0 |                    0
--   90320707 |        372 |          0 |                    0
--  195208775 |      40516 |          0 |                    0
--   96400126 |        363 |          0 |                    0
--   46601493 |          3 |          0 |                    0
--  122295502 |        482 |          0 |                    0
--  216476660 |       4583 |          0 |                    0
--  124466999 |      51733 |          0 |                    0
--  209348876 |     114260 |     114260 |                    1
--  103936130 |        177 |          0 |                    0
--   82313645 |        303 |          0 |                    0
--  176316135 |         20 |          0 |                    0
--  194701088 |       1128 |          0 |                    0
--  100815342 |          1 |          0 |                    0
--   40336240 |   36982031 |          0 |                    0
--  163299585 |     155704 |          0 |                    0
--  101651449 |      84049 |          0 |                    0
--  106829863 |       1260 |          0 |                    0
--  143314130 |      15670 |          0 |                    0
--  121159556 |          1 |          0 |                    0
--   83032635 |         11 |          0 |                    0
--  147085587 |       4417 |          0 |                    0
--  183663188 |    3453949 |          0 |                    0
--   84935206 |    6397598 |          0 |                    0
--   86133606 |         37 |          0 |                    0
--  109029203 |         44 |          0 |                    0
--  132872900 |        259 |          0 |                    0
--  148018215 |         65 |          0 |                    0
--   27122907 |     246556 |          0 |                    0
--   63759512 |       6366 |          0 |                    0
--   98389096 |         28 |          0 |                    0
--   35788718 |         22 |          0 |                    0
--   35631327 |         61 |          0 |                    0
--   23675940 |         17 |          0 |                    0
--  106777314 |        362 |          0 |                    0
--   35630634 |    4871837 |          0 |                    0
--   57781936 |     307012 |          0 |                    0
--  109619851 |         53 |          0 |                    0
--  116311210 |   68356625 |          0 |                    0
--  117546026 |     192622 |          0 |                    0
--   67012900 |        741 |          0 |                    0
--  216478486 |       1305 |          0 |                    0
--   82540262 |         11 |          0 |                    0
--   65504150 |       2707 |          0 |                    0
--  113357578 |      16152 |          0 |                    0
--   46273272 |    5999115 |          0 |                    0
--   21595703 |         12 |          0 |                    0
--   96381687 |         13 |          0 |                    0
--   45870383 |       1758 |          0 |                    0
--  156325678 |        114 |          0 |                    0
--   30707866 |     176773 |          0 |                    0
--  213757766 |          5 |          0 |                    0
--   60811749 |          1 |          0 |                    0
--  136372988 |      99395 |          0 |                    0
--  176741569 |     351557 |          0 |                    0
--   45796635 |     355017 |          0 |                    0
--   31092734 |     193482 |          0 |                    0
--   82310452 |    7119749 |          0 |                    0
--   28633201 |    1392658 |          0 |                    0
--  109828129 |      36416 |          0 |                    0
--  132682088 |     126817 |          0 |                    0
--  198850888 |         11 |          0 |                    0
--   39124980 |          4 |          0 |                    0
--  106460917 |          3 |          0 |                    0
--  140588227 |          7 |          0 |                    0
--  171945841 |      59095 |          0 |                    0
--   84224581 |       1055 |          0 |                    0
--  257683371 |          4 |          0 |                    0
--  205942918 |        138 |          0 |                    0
--  147082539 |          2 |          0 |                    0
--   80286320 |       3958 |          0 |                    0
--  144947284 |      13121 |          0 |                    0
--  124421740 |       2319 |          0 |                    0
--   22043840 |   10527052 |          0 |                    0
--   72216413 |         45 |          0 |                    0
--   59260909 |       5920 |          0 |                    0
--   82427972 |       4706 |          0 |                    0
--  104001945 |     117125 |          0 |                    0
--  102384447 |          1 |          0 |                    0
--  176741598 |      17745 |          0 |                    0
--  122909250 |          2 |          0 |                    0
--  192240838 |         28 |          0 |                    0
--   26009303 |     495242 |          0 |                    0
--  204014012 |          1 |          0 |                    0
--   50894635 |        659 |          0 |                    0
--   53964978 |    1231902 |          0 |                    0
--   92094149 |     341754 |          0 |                    0
--   93740385 |         21 |          0 |                    0
--   36514253 |        243 |          0 |                    0
--   57071933 |        270 |          0 |                    0
--  111747279 |          7 |          0 |                    0
--   27838915 |          1 |          0 |                    0
--  118075825 |          4 |          0 |                    0
--   89191044 |       5354 |          0 |                    0
--  114581581 |       1239 |          0 |                    0
--     186012 |      43238 |          0 |                    0
--   16522792 |          9 |          0 |                    0
--  125766975 |        287 |          0 |                    0
--  122590658 |     423938 |          0 |                    0
--   95834302 |      61505 |          0 |                    0
--  179016375 |       2314 |          0 |                    0
--      37319 |      32822 |          0 |                    0
--  122590578 |    2806298 |          0 |                    0
--  166438195 |       6294 |          0 |                    0
--   62286679 |          2 |          0 |                    0
--   46510620 |        124 |          0 |                    0
--   48937001 |     116174 |          0 |                    0
--  124424929 |        288 |          0 |                    0
--   88870099 |        199 |          0 |                    0
--   38270518 |          2 |          2 |                    1
--   73527121 |         12 |          0 |                    0
--   59980349 |     682424 |          0 |                    0
--  109724636 |   78011951 |          0 |                    0
--  112837021 |      10168 |          0 |                    0
--   96381817 |      85242 |          0 |                    0
--   89053723 |          1 |          0 |                    0
--   59168409 |        631 |          0 |                    0
--   74251962 |        513 |          0 |                    0
--  115597682 |          3 |          0 |                    0
--  106729463 |          2 |          2 |                    1
--   32568356 |        323 |          0 |                    0
--  202779379 |          1 |          0 |                    0
--   74255438 |    2890333 |          0 |                    0
--  135196297 |       1096 |          0 |                    0
--   22859340 |        517 |          0 |                    0
--   38247214 |      27036 |          0 |                    0
--  124425501 |  104598402 |          0 |                    0
--   22866395 |       2659 |          0 |                    0
--  125885546 |        719 |          0 |                    0
--  182702042 |       4811 |          0 |                    0
--   54934114 |   13600432 |          0 |                    0
--   53910500 |    1253961 |          0 |                    0
--   45505866 |          1 |          0 |                    0
--  155607705 |        114 |          0 |                    0
--   30679116 |      10685 |          0 |                    0
--   28062280 |      44719 |          0 |                    0
--   90871611 |         13 |          0 |                    0
--   86136948 |          2 |          0 |                    0
--  145170717 |         14 |          0 |                    0
--  214001728 |   37088469 |          0 |                    0
--  121543297 |       1911 |          0 |                    0
--  170846405 |     102589 |          0 |                    0
--  157859480 |       2017 |          0 |                    0
--  182144638 |      52079 |          0 |                    0
--  198850711 |         68 |          0 |                    0
--  104237033 |          1 |          0 |                    0
--  160404236 |        305 |          0 |                    0
--   91017948 |          7 |          0 |                    0
--  152984821 |     244543 |          0 |                    0
--  132561587 |       1340 |          0 |                    0
--   94706671 |    2531137 |          0 |                    0
--  185821973 |      20223 |      20223 |                    1
--  101390582 |       1674 |          0 |                    0
--   27034639 |     262958 |          0 |                    0
--  184638051 |     410984 |          0 |                    0
--  178115381 |          5 |          0 |                    0
--   77255771 |          1 |          0 |                    0
--  140132808 |       1518 |          0 |                    0
--   74234315 |      22558 |          0 |                    0
--   32179434 |      53356 |          0 |                    0
--  143877042 |        518 |          0 |                    0
--   31058366 |        256 |          0 |                    0
--   82310703 |         26 |          0 |                    0
--   78182396 |    2369702 |          0 |                    0
--  134543960 |        215 |          0 |                    0
--   39203358 |   31347776 |          0 |                    0
--  125053415 |        645 |          0 |                    0
--   48184656 |        623 |          0 |                    0
--   44902792 |       1607 |          0 |                    0
--   95745090 |     635396 |          0 |                    0
--  185837543 |          3 |          0 |                    0
--   76457409 |    2607575 |          0 |                    0
--   79223178 |         22 |          0 |                    0
--   63560840 |        131 |          0 |                    0
--  117166361 |     120028 |          0 |                    0
--  234307858 |      14733 |      14733 |                    1
--  118076064 |          1 |          0 |                    0
--  129013664 |   16776555 |          0 |                    0
--  140130109 |        238 |          0 |                    0
--   21681549 |      14913 |          0 |                    0
--   49161847 |       1303 |          0 |                    0
--   21608217 |     143676 |          0 |                    0
--   87172183 |        273 |          0 |                    0
--   65504552 |       1019 |          0 |                    0
--   26599480 |       1068 |          0 |                    0
--  116387399 |     107488 |          0 |                    0
--   69031635 |    1834641 |          0 |                    0
--   84428795 |          2 |          0 |                    0
--   44426109 |      12064 |          0 |                    0
--  170296499 |         53 |          0 |                    0
--  156375500 |          4 |          0 |                    0
--  125583114 |        465 |          0 |                    0
--   83010775 |     416133 |          0 |                    0
--   92086686 |      68171 |          0 |                    0
--  159580001 |      66681 |          0 |                    0
--  126862685 |        268 |          0 |                    0
--   60021718 |          2 |          0 |                    0
--   23675138 |     728261 |          0 |                    0
--   47160885 |      11196 |          0 |                    0
--  112807592 |        349 |          0 |                    0
--   23184822 |     131091 |          0 |                    0
--    9846758 |   49304457 |          0 |                    0
--   27541545 |      20876 |          0 |                    0
--  133006306 |       1623 |          0 |                    0
--   73900017 |   34419457 |          0 |                    0
--   28633177 |  242655750 |          0 |                    0
--  147089687 |          7 |          0 |                    0
--   77277333 |      55734 |          0 |                    0
--   82312633 |          3 |          0 |                    0
--  121394866 |     148774 |          0 |                    0
--   86415369 |         35 |          0 |                    0
--  147239905 |   14115521 |          0 |                    0
--   48281577 |      14446 |          0 |                    0
--   19482585 |    1328441 |    1328441 |                    1
--  195560769 |    1190460 |          0 |                    0
--  170814629 |       1906 |          0 |                    0
--   62297903 |        105 |          0 |                    0
--  106460795 |       7374 |          0 |                    0
--   75852992 |        113 |          0 |                    0
--  188864445 |     426856 |     362058 |    0.848197050059036
--   93158909 |     156673 |          0 |                    0
--   23855684 |        118 |          0 |                    0
--   90250213 |          1 |          0 |                    0
--  127598526 |         11 |          0 |                    0
--  146032492 |          7 |          0 |                    0
--  163974815 |      12300 |          0 |                    0
--   82315852 |    1128059 |          0 |                    0
--   24368229 |       7332 |          0 |                    0
--  194191084 |    1149265 |          0 |                    0
--   56118718 |        112 |          0 |                    0
--   86517310 |         24 |          0 |                    0
--   79854877 |    3002308 |          0 |                    0
--  130447455 |        120 |          0 |                    0
--  215393257 |          1 |          0 |                    0
--   23667239 |      21974 |          0 |                    0
--   31677807 |       3001 |          0 |                    0
--   50827887 |         16 |          0 |                    0
--   88435074 |         36 |          0 |                    0
--    7601562 |   75181544 |          0 |                    0
--   36481935 |     511992 |          0 |                    0
--  194701994 |        540 |          0 |                    0
--  124022037 |      37726 |          0 |                    0
--  111166326 |       1409 |          0 |                    0
--   59768679 |          1 |          0 |                    0
--   27446517 |   14493976 |          0 |                    0
--  112547823 |         75 |          0 |                    0
--  147094330 |        739 |          0 |                    0
--   52826507 |       2386 |          0 |                    0
--  149823532 |        503 |          0 |                    0
--  146887982 |     334359 |     334359 |                    1
--   60383928 |        584 |          0 |                    0
--  101335000 |          1 |          0 |                    0
--   96642596 |       3949 |          0 |                    0
--  125217175 |     699535 |          0 |                    0
--  130118642 |        381 |          0 |                    0
--  198165386 |    3105969 |          0 |                    0
--   88438363 |        225 |          0 |                    0
--  111748136 |          4 |          0 |                    0
--  142128642 |    1381156 |          0 |                    0
--   90816103 |        562 |          0 |                    0
--   24657677 |    7163465 |          0 |                    0
--  121159094 |          8 |          0 |                    0
--   32660551 |       2132 |          0 |                    0
--  157212231 |     277375 |          0 |                    0
--   89945131 |        454 |          0 |                    0
--  121312093 |     210891 |          0 |                    0
--  158262454 |      11997 |          0 |                    0
--   38082778 |       7848 |          0 |                    0
--  133023333 |         34 |          0 |                    0
--   49483154 |          6 |          0 |                    0
--  147081397 |        581 |          0 |                    0
--   30918314 |        989 |          0 |                    0
--  131926753 |          4 |          0 |                    0
--   82311871 |       2688 |          0 |                    0
--  109495736 |         73 |          0 |                    0
--  203942955 |          2 |          0 |                    0
--   67854211 |          3 |          0 |                    0
--   92184565 |          7 |          0 |                    0
--   36933313 |         47 |          0 |                    0
--  119637580 |        205 |          0 |                    0
--   46241462 |         98 |          0 |                    0
--   72209864 |       6604 |          0 |                    0
--  131284368 |          8 |          0 |                    0
--  129339704 |   10446588 |       5129 | 0.000490973703567136
--  112127912 |       2712 |          0 |                    0
--  119637323 |        247 |          0 |                    0
--  102383984 |         34 |          0 |                    0
--  185825123 |    6197422 |          0 |                    0
--  104931874 |         64 |          0 |                    0
--  215329026 |          2 |          0 |                    0
--  104846109 |       5298 |          0 |                    0
--  105458682 |   29805984 |          0 |                    0
--   92743746 |        128 |          0 |                    0
--  121250829 |          2 |          0 |                    0
--   77256070 |          1 |          0 |                    0
--   27230032 |     495518 |          0 |                    0
--  127388123 |     347009 |          0 |                    0
--   26019478 |     176732 |          0 |                    0
--  106248682 |         31 |          0 |                    0
--   43184733 |       1746 |          0 |                    0
--  194702141 |        708 |          0 |                    0
--  116703220 |      11756 |          0 |                    0
--  118999468 |       1090 |       1090 |                    1
--  118076662 |    1979838 |          0 |                    0
--   45793430 |        148 |          0 |                    0
--  108548899 |        132 |          0 |                    0
--   27838856 |     150258 |          0 |                    0
--  214725742 |          1 |          0 |                    0
--    8495441 |       1532 |          0 |                    0
--   85926659 |    1102978 |          0 |                    0
--  124556863 |       2535 |          0 |                    0
--   55512799 |          3 |          0 |                    0
--  122217790 |     382439 |          0 |                    0
--  140130590 |         86 |          0 |                    0
--  157791234 |         52 |          0 |                    0
--  216211702 |         25 |          0 |                    0
--   29733529 |      59130 |          0 |                    0
--    2158531 |      53150 |          0 |                    0
--  206732783 |          5 |          0 |                    0
--   27528066 |    4196068 |          0 |                    0
--  174962332 |         19 |          0 |                    0
--  189008041 |     141214 |          0 |                    0
--   92184206 |        677 |          0 |                    0
--   31500812 |    2487096 |          0 |                    0
--  106790087 |       3493 |          0 |                    0
--  124021922 |      52467 |          0 |                    0
--  137956392 |      50621 |          0 |                    0
--   27451903 |     191779 |          0 |                    0
--  174174299 |        790 |          0 |                    0
--  103207223 |        174 |          0 |                    0
--  127616454 |          8 |          0 |                    0
--   39411368 |    8232150 |          0 |                    0
--   46489877 |     164856 |          0 |                    0
--   33286185 |         62 |          0 |                    0
--   36514204 |         14 |          0 |                    0
--  147565999 |    3218609 |    1436576 |    0.446334425834266
--  161101369 |     112534 |          0 |                    0
--   32944300 |    5516288 |          0 |                    0
--   59602952 |        394 |          0 |                    0
--   28201341 |         19 |          0 |                    0
--   31245897 |        655 |          0 |                    0
--  136272680 |         77 |          0 |                    0
--  177964931 |      27806 |          0 |                    0
--  142079337 |         79 |          0 |                    0
--   98041498 |     578269 |          0 |                    0
--   40418127 |       1594 |          0 |                    0
--   28608943 |    4484943 |          0 |                    0
--  149232299 |       2980 |          0 |                    0
--  105399301 |       4573 |          0 |                    0
--   82858128 |          2 |          0 |                    0
--   77255996 |     284765 |          0 |                    0
--   35601846 |         64 |          0 |                    0
--  138524211 |       1362 |          0 |                    0
--   59613488 |       3426 |          0 |                    0
--   87056709 |   91448663 |          0 |                    0
--  140130229 |        561 |          0 |                    0
--   93912702 |     703137 |          0 |                    0
--  107788013 |       1459 |          0 |                    0
--  132798676 |         56 |          0 |                    0
--   55081823 |      20678 |          0 |                    0
--   82387620 |         10 |          0 |                    0
--  225224263 |        309 |          0 |                    0
--   86418130 |          1 |          0 |                    0
--   37516578 |    2211381 |          0 |                    0
--   27942990 |      39453 |          0 |                    0
--  168252394 |          4 |          0 |                    0
--   44891403 |          2 |          0 |                    0
--   82836791 |        131 |          0 |                    0
--   80145304 |    7500371 |          0 |                    0
--  182687191 |        949 |          0 |                    0
--  247664629 |       2455 |          0 |                    0
--   30011711 |      28152 |          0 |                    0
--  190835892 |  108841174 |          0 |                    0
--  135462003 |     237854 |          0 |                    0
--   76000427 |       2509 |          0 |                    0
--  143093008 |      93045 |          0 |                    0
--   62979603 |         56 |          0 |                    0
--  166458814 |      11444 |          0 |                    0
--  146157808 |          7 |          0 |                    0
--  237729705 |          1 |          0 |                    0
--   29578325 |   45959181 |          0 |                    0
--    8641037 |    1422103 |          0 |                    0
--  198368256 |     587004 |          0 |                    0
--   65508920 |          1 |          0 |                    0
--   91434298 |         11 |          0 |                    0
--   88398797 |         26 |          0 |                    0
--  134210430 |          3 |          0 |                    0
--   91445441 |       5566 |          0 |                    0
--  103928041 |       2720 |          0 |                    0
--  136805845 |         41 |          0 |                    0
--  180717240 |          2 |          0 |                    0
--  123285052 |         11 |          0 |                    0
--   36990968 |         29 |          0 |                    0
--   48866350 |        521 |          0 |                    0
--   44891249 |      12999 |          0 |                    0
--   79946736 |     345570 |          0 |                    0
--   36513748 |        162 |          0 |                    0
--   31239503 |  185954438 |          0 |                    0
--  213753215 |         43 |          0 |                    0
--  177205547 |         16 |          0 |                    0
--   41008133 |        129 |          0 |                    0
--   88398874 |          2 |          0 |                    0
--   28633396 |        125 |          0 |                    0
--  140154155 |         26 |          0 |                    0
--   73294347 |         17 |          0 |                    0
--   62179509 |          1 |          0 |                    0
--   41744476 |      10333 |          0 |                    0
--   21998263 |       5055 |          0 |                    0
--   71068671 |    6391603 |          0 |                    0
--   54739364 |    1518431 |          0 |                    0
--   30186974 |    2837042 |          0 |                    0
--   21282777 |       1477 |          0 |                    0
--  177206101 |         15 |          0 |                    0
--  197780646 |    8059838 |    8049510 |    0.998718584666342
--   34312029 |        528 |          0 |                    0
--  189716990 |      10738 |          0 |                    0
--   43311375 |    1559881 |          0 |                    0
--   84263077 |        124 |          0 |                    0
--  142399923 |        257 |          0 |                    0
--  121545596 |       1349 |          0 |                    0
--  233397692 |     797975 |          0 |                    0
--   44690946 |     747245 |          0 |                    0
--  151259593 |      19669 |          0 |                    0
--  122396317 |      18750 |          0 |                    0
--   28568066 |          4 |          0 |                    0
--   26362946 |        221 |          0 |                    0
--  106460865 |          7 |          0 |                    0
--   25722719 |   12943727 |          0 |                    0
--  171220649 |          1 |          0 |                    0
--   28633500 |         33 |          0 |                    0
--   69389343 |     236375 |          0 |                    0
--  133078246 |         14 |          0 |                    0
--  109028896 |         28 |          0 |                    0
--   36029255 |  358574200 |          0 |                    0
--   70084558 |         20 |          0 |                    0
--  124420521 |      29423 |          0 |                    0
--  144484430 |        459 |          0 |                    0
--   82310722 |     786621 |          0 |                    0
--  182686434 |         27 |          0 |                    0
--   66141259 |       1701 |          0 |                    0
--  230563437 |         16 |          0 |                    0
--  117545786 |     309739 |          0 |                    0
--  100814397 |    3445857 |          0 |                    0
--  180780173 |        197 |          0 |                    0
--  100837300 |          3 |          0 |                    0
--   82312033 |         80 |          0 |                    0
--  157161991 |      71441 |      71441 |                    1
--   60493007 |         71 |          0 |                    0
--  140650225 |          1 |          0 |                    0
--   26492776 |        483 |          0 |                    0
--  147734961 |    3585707 |          0 |                    0
--  100838228 |         32 |          0 |                    0
--  148446618 |        463 |          0 |                    0
--  126778132 |       3082 |          0 |                    0
--   90482206 |        128 |          0 |                    0
--   30220059 |    5397733 |          0 |                    0
--  193334310 |       1327 |          0 |                    0
--  107948330 |          3 |          0 |                    0
--  195205609 |    4668640 |          0 |                    0
--   28381331 |         29 |          0 |                    0
--  138607882 |      18814 |          0 |                    0
--   22230083 |       3912 |          0 |                    0
--  170828602 |         12 |          0 |                    0
--   23211159 |      16104 |          0 |                    0
--  126070922 |        200 |          0 |                    0
--  212941581 |        337 |          0 |                    0
--  106210387 |       2727 |          0 |                    0
--   52242778 |        580 |          0 |                    0
--  116956483 |          9 |          0 |                    0
--   39124933 |       2563 |          0 |                    0
--  136871372 |       1154 |          0 |                    0
--       8822 |      12939 |          0 |                    0
--   55038335 |          5 |          0 |                    0
--  162183301 |          4 |          0 |                    0
--   36791492 |        375 |          0 |                    0
--  213752946 |     756436 |          0 |                    0
--  184723670 |        207 |          0 |                    0
--   72982747 |    8190896 |          0 |                    0
--   28596663 |         13 |          0 |                    0
--  188863650 |     125116 |     112453 |    0.898789922951501
--   25015653 |     996859 |          0 |                    0
--   93159988 |     359909 |          0 |                    0
--   41771997 |        252 |          0 |                    0
--  124695018 |        140 |          0 |                    0
--   40022691 |   15631532 |   15631532 |                    1
--  197886470 |   37494018 |   37441957 |    0.998611485170781
--   95304086 |          4 |          0 |                    0
--   28311272 |         34 |          0 |                    0
--  206129618 |        652 |          0 |                    0
--   35788650 |    7352170 |          0 |                    0
--   84941012 |         19 |          0 |                    0
--  124556419 |     624713 |          0 |                    0
--  100815315 |        374 |          0 |                    0
--  121909345 |     105404 |          0 |                    0
--  198349730 |         64 |          0 |                    0
--  182217093 |        327 |          0 |                    0
--   49455542 |        534 |          0 |                    0
--  169407356 |    2406488 |          0 |                    0
--   62880125 |        432 |          0 |                    0
--  179015767 |       2037 |          0 |                    0
--  111916431 |          8 |          0 |                    0
--   65075571 |          6 |          0 |                    0
--  118170598 |       4066 |          0 |                    0
--  162760681 |         38 |          0 |                    0
--  184045485 |     306042 |          0 |                    0
--   63563054 |    1266535 |          0 |                    0
--  120609069 |     382869 |          0 |                    0
--  161717421 |        881 |          0 |                    0
--   70815714 |     452609 |          0 |                    0
--   52650914 |   11036516 |          0 |                    0
--   91840528 |     541045 |          0 |                    0
--  153904184 |     269579 |          0 |                    0
--  116957695 |          9 |          0 |                    0
--   71801725 |          3 |          0 |                    0
--   28295429 |   24427022 |          0 |                    0
--  117167527 |   14446158 |          0 |                    0
--  205873032 |        278 |          0 |                    0
--  104833324 |   28177633 |          0 |                    0
--  205938815 |          2 |          0 |                    0
--   85907264 |        944 |          0 |                    0
--  106461347 |         28 |          0 |                    0
--  156948981 |       1696 |          0 |                    0
--  104306386 |       1011 |          0 |                    0
--   45091947 |          3 |          0 |                    0
--  197780873 |       4921 |          0 |                    0
--   36616300 |     525146 |          0 |                    0
--  108511628 |          4 |          0 |                    0
--   83037509 |          1 |          0 |                    0
--  161155239 |        132 |          0 |                    0
--  112445706 |        122 |          0 |                    0
--   27755070 |     578268 |          0 |                    0
--   44617985 |        809 |          0 |                    0
--  134080100 |          4 |          0 |                    0
--   77392286 |       3073 |          0 |                    0
--  120472594 |    1768163 |          0 |                    0
--   43573547 |         11 |          0 |                    0
--   28547446 |         11 |          0 |                    0
--  214723543 |        346 |          0 |                    0
--   57884386 |       5705 |          0 |                    0
--  176683368 |          1 |          0 |                    0
--  206115073 |        194 |          0 |                    0
--   14370225 |       6193 |          0 |                    0
--  147405184 |         22 |          0 |                    0
--   41744541 |       4125 |          0 |                    0
--   49645254 |      16070 |          0 |                    0
--   93158567 |         63 |          0 |                    0
--   82427460 |        303 |          0 |                    0
--   41744279 |       1562 |          0 |                    0
--  104150768 |         43 |          0 |                    0
--  124021995 |   10977055 |          0 |                    0
--   89349239 |     320152 |          0 |                    0
--   61355521 |   17227820 |          0 |                    0
--   42028083 |    3296877 |          0 |                    0
--   35936871 |   13658163 |          0 |                    0
--   90960271 |     350877 |          0 |                    0
--   13238556 |       6557 |          0 |                    0
--  213474496 |         57 |          0 |                    0
--  126482446 |    1230726 |          0 |                    0
--  104297197 |       1097 |          0 |                    0
--   42026012 |        643 |          0 |                    0
--   42316376 |    7902997 |          0 |                    0
--   28444103 |     203129 |          0 |                    0
--  182559457 |         15 |          0 |                    0
--   91029784 |    3803206 |          0 |                    0
--   59286736 |        395 |          0 |                    0
--   72929734 |         41 |          0 |                    0
--   27935723 |         63 |          0 |                    0
--  205587390 |          2 |          0 |                    0
--  112432113 |        689 |          0 |                    0
--  171303857 |          8 |          0 |                    0
--  126778404 |         58 |          0 |                    0
--   55125740 |     680640 |          0 |                    0
--   29140595 |        207 |          0 |                    0
--   35788661 |        235 |          0 |                    0
--  112803049 |      51013 |          0 |                    0
--  152227184 |     540417 |          0 |                    0
--  173767570 |         18 |          0 |                    0
--   28029009 |   68823229 |   68823229 |                    1
--  171040977 |         64 |          0 |                    0
--  126070938 |         40 |          0 |                    0
--   77255855 |       4222 |          0 |                    0
--   65503456 |       7500 |          0 |                    0
--   40407340 |        215 |          0 |                    0
--   35631403 |         13 |          0 |                    0
--   22510310 | 1078049444 |          0 |                    0
--  102851676 |         10 |          0 |                    0
--  133022161 |        792 |          0 |                    0
--   29156628 |         25 |          0 |                    0
--    7352265 |      15510 |          0 |                    0
--   59621686 |         28 |          0 |                    0
--   23674654 |    3006189 |          0 |                    0
--  181254758 |      95853 |          0 |                    0
--   94015104 |         39 |          0 |                    0
--   60811129 |          1 |          0 |                    0
--  177327398 |       3131 |          0 |                    0
--   72315696 |        693 |          0 |                    0
--  182058271 |         76 |          0 |                    0
--   36794584 |     271599 |          0 |                    0
--   24954143 |          6 |          0 |                    0
--   58765102 |         63 |          0 |                    0
--   26991613 |   18961927 |          0 |                    0
--  121159439 |        116 |          0 |                    0
--  127507183 |        387 |          0 |                    0
--   30513904 |         39 |          0 |                    0
--   22346597 |   43160407 |          0 |                    0
--  168843586 |      30404 |      30404 |                    1
--   31538945 |        741 |          0 |                    0
--  147081229 |        716 |          0 |                    0
--   74256427 |      20765 |          0 |                    0
--   78479827 |          1 |          0 |                    0
--  104976757 |        141 |          0 |                    0
--  140133532 |         15 |          0 |                    0
--   23675021 |    9670981 |          0 |                    0
--   30086806 |          2 |          0 |                    0
--  159579852 |      33212 |          0 |                    0
--    7832442 |   17313081 |          0 |                    0
--  133542601 |          1 |          0 |                    0
--   36653045 |      36657 |          0 |                    0
--   28604133 |     925282 |          0 |                    0
--   26597591 |     133144 |          0 |                    0
--   30635747 |      70411 |      17761 |    0.252247518143472
--   84425570 |          2 |          0 |                    0
--  104477535 |       1799 |          0 |                    0
--  126071097 |        160 |          0 |                    0
--   94337556 |          2 |          0 |                    0
--   30343318 |          1 |          0 |                    0
--   40259844 |      26774 |          0 |                    0
--   93318779 |      42736 |          0 |                    0
--   20891118 |        211 |          0 |                    0
--  134159688 |          3 |          0 |                    0
--   87647925 |         26 |          0 |                    0
--  132181565 |          2 |          0 |                    0
--  148939910 |      49820 |          0 |                    0
--  195070795 |         11 |          0 |                    0
--  207008614 |        224 |          0 |                    0
--   88398531 |         54 |          0 |                    0
--  147405168 |        993 |          0 |                    0
--   11152602 |   14051979 |          0 |                    0
--  126071010 |         12 |          0 |                    0
--   29528377 |        319 |          0 |                    0
--   41122028 |     388431 |          0 |                    0
--   75311291 |          1 |          0 |                    0
--   28631805 |          1 |          0 |                    0
--   20687650 |    2999745 |          0 |                    0
--   73254415 |     984870 |          0 |                    0
--   27945625 |     182206 |          0 |                    0
--   75975727 |    2763132 |          0 |                    0
--  206121124 |          1 |          0 |                    0
--   65503845 |       6330 |          0 |                    0
--  184852975 |          3 |          0 |                    0
--  106992078 |        177 |          0 |                    0
--  124605286 |    1032762 |          0 |                    0
--   54933969 |  268973023 |          0 |                    0
--  182747332 |    2171754 |          0 |                    0
--   97876585 |       9845 |          0 |                    0
--  192239539 |          3 |          0 |                    0
--   88029046 |         12 |          0 |                    0
--   20780251 |    1089638 |          0 |                    0
--   51104502 |         10 |          0 |                    0
--  142055874 |   13370386 |          0 |                    0
--  182687072 |         32 |          0 |                    0
--  163004400 |      42896 |          0 |                    0
--  198168158 |     840102 |          0 |                    0
--  132250791 |    1450038 |          0 |                    0
--  127619048 |          4 |          0 |                    0
--   49632767 |     998708 |          0 |                    0
--  126479100 |     133958 |          0 |                    0
--  211769279 |         17 |          0 |                    0
--   93748139 |    8967960 |          0 |                    0
--  125363804 |       5063 |          0 |                    0
--   29225105 |         52 |          0 |                    0
--  101733109 |         55 |          0 |                    0
--   71852806 |   18547800 |          0 |                    0
--   36513760 |   19059770 |          0 |                    0
--  120779324 |       5588 |          0 |                    0
--  145497793 |         13 |          0 |                    0
--   91596438 |          1 |          0 |                    0
--   26043975 |          1 |          0 |                    0
--   36546126 |        239 |          0 |                    0
--   30437881 |       2238 |          0 |                    0
--   92570994 |        849 |          0 |                    0
--  132039510 |        130 |          0 |                    0
--  185828953 |       2849 |          0 |                    0
--  156604272 |    1351374 |          0 |                    0
--   38539112 |   28494137 |   11831409 |    0.415222577191933
--  129003148 |        167 |          0 |                    0
--  124425092 |         61 |          0 |                    0
--  139518597 |      35989 |          0 |                    0
--   59130579 |         55 |          0 |                    0
--   94435040 |   19569770 |          0 |                    0
--  157594551 |          1 |          0 |                    0
--   28736641 |          1 |          0 |                    0
--  134850221 |    4133031 |          0 |                    0
--  108583261 |      25314 |          0 |                    0
--   28633583 |         26 |          0 |                    0
--   42846507 |        487 |          0 |                    0
--   28629491 |          4 |          0 |                    0
--   37828235 |     105542 |          0 |                    0
--   23674883 |          2 |          0 |                    0
--   75976124 |          5 |          0 |                    0
--  159538868 |       3879 |          0 |                    0
--  131929996 |          8 |          0 |                    0
--  233400622 |    3340568 |          0 |                    0
--   94880618 |         50 |          0 |                    0
--   83920368 |         10 |          0 |                    0
--   48866387 |          1 |          0 |                    0
--   52245511 |        173 |          0 |                    0
--   89881921 |       1109 |          0 |                    0
--  147856298 |          1 |          0 |                    0
--  132352083 |         41 |          0 |                    0
--   88607946 |    6386579 |          0 |                    0
--  174961238 |        572 |          0 |                    0
--   94829982 |        573 |          0 |                    0
--  131438205 |      17037 |          0 |                    0
--   51435464 |    9514429 |          0 |                    0
--  133021958 |         20 |          0 |                    0
--   25473490 |          7 |          0 |                    0
--  193700628 |     106386 |          0 |                    0
--   44079069 |       2005 |          0 |                    0
--   61365106 |     309455 |          0 |                    0
--  104974429 |        227 |          0 |                    0
--  115303295 |         29 |          0 |                    0
--   48276058 |      47299 |          0 |                    0
--  224113098 |         37 |          0 |                    0
--   90567379 |          2 |          0 |                    0
--   92629178 |      64889 |          0 |                    0
--  134701163 |          1 |          0 |                    0
--  133022643 |        632 |          0 |                    0
--   23660075 |       9762 |          0 |                    0
--  114029128 |       4996 |          0 |                    0
--   99890311 |     104342 |          0 |                    0
--   35785191 |         32 |          0 |                    0
--   28633266 |    1209703 |          0 |                    0
--  184787193 |         17 |          0 |                    0
--  181103251 |     233404 |          0 |                    0
--   62838488 |          6 |          0 |                    0
--  242710048 |          6 |          0 |                    0
--   95592694 |        214 |          0 |                    0
--   25473475 |          4 |          0 |                    0
--  132038849 |    1612520 |          0 |                    0
--   10677092 |    1002523 |          0 |                    0
--   26805191 |       1430 |          0 |                    0
--   85111145 |      43083 |          0 |                    0
--   49946840 |      30166 |          0 |                    0
--  124422593 |      12674 |          0 |                    0
--   88398452 |        184 |          0 |                    0
--   12616386 |     493180 |          0 |                    0
--   40700260 |     127451 |          0 |                    0
--   65504582 |       2305 |          0 |                    0
--   75910196 |    8508859 |          0 |                    0
--   39176474 |     419543 |          0 |                    0
--   20963618 |      45696 |          0 |                    0
--  154046373 |         60 |          0 |                    0
--   86276413 |         31 |          0 |                    0
--   26846332 |          1 |          0 |                    0
--   80646824 |          1 |          0 |                    0
--   90912711 |       8545 |          0 |                    0
--   60955605 |     453782 |          0 |                    0
--   82424182 |       1502 |          0 |                    0
--  257684632 |          2 |          0 |                    0
--   84934385 |   21913659 |          0 |                    0
--  215166120 |        662 |          0 |                    0
--  149747285 |   92483217 |          0 |                    0
--   36511426 |       2261 |          0 |                    0
--  100820859 |        204 |          0 |                    0
--  124425627 |   27345568 |          0 |                    0
--  143979183 |        646 |          0 |                    0
--   24681606 |          4 |          0 |                    0
--   85801385 |       3638 |          0 |                    0
--  185830782 |      13933 |      13933 |                    1
--  108458130 |          6 |          0 |                    0
--  192227758 |          1 |          0 |                    0
--  133022795 |      17106 |          0 |                    0
--  205587113 |         23 |          0 |                    0
--  134218516 |    1875592 |          0 |                    0
--   50796963 |    9938474 |          0 |                    0
--  232091581 |        365 |          0 |                    0
--  178262623 |          4 |          0 |                    0
--  161089598 |          5 |          0 |                    0
--  112435828 |       1314 |          0 |                    0
--  100820522 |       6747 |          0 |                    0
--   39886511 |      40278 |          0 |                    0
--  126435001 |       6144 |          0 |                    0
--   63788558 |       8945 |          0 |                    0
--  265841739 |          5 |          0 |                    0
--   94173794 |          6 |          0 |                    0
--   89991985 |      95514 |          0 |                    0
--  109828170 |      12150 |          0 |                    0
--   82312053 |          5 |          0 |                    0
--  121159622 |         12 |          0 |                    0
--   51533647 |         13 |          0 |                    0
--   36081806 |        377 |          0 |                    0
--   71747347 |          7 |          0 |                    0
--   63722538 |        645 |          0 |                    0
--   66256102 |        460 |          0 |                    0
--   24643779 |   12132862 |          0 |                    0
--  177221717 |          8 |          0 |                    0
--   52692813 |        151 |          0 |                    0
--   24627827 |       7622 |       7622 |                    1
--   57419841 |       3987 |          0 |                    0
--   70518383 |     407934 |          0 |                    0
--   65503889 |       2572 |          0 |                    0
--  173434178 |         30 |          0 |                    0
--   60048521 |        243 |          0 |                    0
--  134233455 |         38 |          0 |                    0
--   39391268 |     232917 |          0 |                    0
--   96029074 |         34 |          0 |                    0
--  181054504 |          5 |          0 |                    0
--  164761266 |     447724 |          0 |                    0
--   42508152 |   12302509 |          0 |                    0
--  147081089 |       3772 |          0 |                    0
--  134736545 |       4104 |          0 |                    0
--  190110074 |   27822117 |          0 |                    0
--    1446594 |      16758 |          0 |                    0
--   22480377 |   34401188 |   34401188 |                    1
--  182057740 |          6 |          0 |                    0
--  175013554 |        224 |          0 |                    0
--  116301733 |        202 |          0 |                    0
--  198652534 |         41 |          0 |                    0
--  134232312 |        253 |          0 |                    0
--  127506955 |    6730780 |       4235 | 0.000629198993281611
--  135935157 |      61487 |          0 |                    0
--   92184187 |      31088 |          0 |                    0
--   40276229 |          4 |          0 |                    0
--  153892238 |         10 |          0 |                    0
--  110171353 |      84462 |          0 |                    0
--   50161262 |          4 |          0 |                    0
--  232867781 |         77 |          0 |                    0
--  104778898 |        297 |          0 |                    0
--   28633563 |         12 |          0 |                    0
--  176416093 |          9 |          0 |                    0
--   90254285 |        212 |          0 |                    0
--  102382966 |          1 |          0 |                    0
--  156144422 |         77 |          0 |                    0
--  109640263 |     110099 |          0 |                    0
--   85266773 |         13 |          0 |                    0
--   32179353 |    1897509 |          0 |                    0
--   96859654 |          2 |          0 |                    0
--   36041679 |       2595 |          0 |                    0
--   13108948 |       2232 |          0 |                    0
--   22859264 |    2390652 |          0 |                    0
--  137347549 |   24794542 |          0 |                    0
--  140154074 |         76 |          0 |                    0
--  107990613 |          2 |          0 |                    0
--   28462004 |      14995 |          0 |                    0
--   31542318 |       1017 |          0 |                    0
--   25196062 |          1 |          0 |                    0
--  136321928 |        183 |          0 |                    0
--  233403700 |    4468743 |          0 |                    0
--  205578128 |          2 |          0 |                    0
--   31113075 |     166935 |          0 |                    0
--   24208138 |     314680 |          0 |                    0
--   37711733 |   31816866 |          0 |                    0
--   51914127 |   18395432 |          0 |                    0
--  149137273 |       1389 |          0 |                    0
--     501281 |   58369154 |          0 |                    0
--   28444142 |          2 |          0 |                    0
--   21175297 |       3091 |          0 |                    0
--  106460964 |          1 |          0 |                    0
--  209958706 |      63901 |          0 |                    0
--  118170488 |      67860 |          0 |                    0
--   85082977 |     150430 |          0 |                    0
--   45912780 |    4702358 |          0 |                    0
--   44882903 |       8762 |          0 |                    0
--  147462900 |      22576 |          0 |                    0
--  132250515 |    2805859 |          0 |                    0
--   83832889 |         42 |          0 |                    0
--   40573163 |     116094 |          0 |                    0
--  126645844 |         32 |          0 |                    0
--  116000787 |      31973 |          0 |                    0
--  176026968 |         95 |          0 |                    0
--  122875003 |     168975 |          0 |                    0
--  132106826 |   18622655 |          0 |                    0
--  112866535 |    9113798 |          0 |                    0
--   28633298 |    7018138 |          0 |                    0
--  167167117 |      34605 |          0 |                    0
--  102321416 |     171381 |          0 |                    0
--   32194506 |       3086 |          0 |                    0
--   82982720 |    2500298 |          0 |                    0
--  116619091 |      11105 |       4530 |    0.407924358397118
--   95592305 |       1429 |          0 |                    0
--  233398214 |    2670813 |          0 |                    0
--  105042012 |        454 |          0 |                    0
--   43873661 |         31 |          0 |                    0
--  131439345 |      15961 |          0 |                    0
--  171207260 |       1226 |          0 |                    0
--  214941695 |    6619993 |          0 |                    0
--  122208625 |       9717 |          0 |                    0
--  141885084 |        728 |          0 |                    0
--   25809459 |     352481 |          0 |                    0
--  103927668 |        136 |          0 |                    0
--  167619740 |       1720 |          0 |                    0
--  191121754 |       1111 |          0 |                    0
--   76546210 |          1 |          0 |                    0
--   52229024 |     397514 |          0 |                    0
--      12826 |    3042278 |          0 |                    0
--   82312665 |        590 |          0 |                    0
--  198409176 |       1733 |          0 |                    0
--   86926514 |          1 |          0 |                    0
--   38617228 |     720440 |          0 |                    0
--   61544117 |         80 |          0 |                    0
--   32638197 |       3582 |          0 |                    0
--   23460504 |      21514 |          0 |                    0
--   46842715 |         70 |          0 |                    0
--  132007330 |   13382379 |          0 |                    0
--   90939300 |        698 |          0 |                    0
--   43951156 |        919 |          0 |                    0
--   67794893 |   10580794 |          0 |                    0
--   52288508 |       1122 |          0 |                    0
--  170396144 |    2259112 |          0 |                    0
--   23926276 |         37 |          0 |                    0
--   44345392 |    4896428 |    4895015 |    0.999711422285797
--   30609527 |       1956 |          0 |                    0
--  173510043 |        383 |          0 |                    0
--   83920024 |       1460 |          0 |                    0
--  195186605 |      48347 |          0 |                    0
--  128515235 |     772392 |          0 |                    0
--  125573753 |     899597 |          0 |                    0
--   80632795 |         12 |          0 |                    0
--  116284087 |     603976 |          0 |                    0
--  106989228 |         24 |          0 |                    0
--   49460839 |          1 |          0 |                    0
--   76451988 |         17 |          0 |                    0
--  177214194 |        855 |          0 |                    0
--  206133618 |        808 |          0 |                    0
--  173291201 |      39167 |          0 |                    0
--   90268294 |          1 |          0 |                    0
--   40570590 |        138 |          0 |                    0
--   60818929 |       5592 |          0 |                    0
--   40341274 |       2024 |          0 |                    0
--  155607625 |       1945 |          0 |                    0
--   71852853 |   12233358 |          0 |                    0
--  185822287 |      20566 |      20566 |                    1
--   81175911 |       3269 |          0 |                    0
--   41719683 |     662615 |          0 |                    0
--  134653996 |        239 |          0 |                    0
--    7700271 |        553 |          0 |                    0
--   93077562 |    9442612 |          0 |                    0
--  133163409 |      13400 |          0 |                    0
--   80380440 |         18 |          0 |                    0
--  121543359 |        866 |          0 |                    0
--   47042444 |       1095 |          0 |                    0
--  185876706 |     431661 |          0 |                    0
--   86107102 |     321789 |          0 |                    0
--  116783807 |        276 |          0 |                    0
--   52141201 |     198889 |          0 |                    0
--   28633636 |       1562 |          0 |                    0
--   82836821 |         46 |          0 |                    0
--   23570353 |          7 |          0 |                    0
--  100815219 |       9840 |          0 |                    0
--  192035808 |         44 |          0 |                    0
--  173125561 |        170 |          0 |                    0
--   67834893 |      78003 |          0 |                    0
--  151123442 |         28 |          0 |                    0
--   46902932 |          2 |          0 |                    0
--     131070 |    2125350 |          0 |                    0
--   42287922 |      26024 |          0 |                    0
--  171219430 |      17746 |          0 |                    0
--   24297173 |   23933439 |          0 |                    0
--   82858025 |          5 |          0 |                    0
--   89245104 |        384 |          0 |                    0
--  174126302 |        689 |          0 |                    0
--  169708283 |       6366 |          0 |                    0
--  107953058 |          6 |          0 |                    0
--  125565415 |          5 |          0 |                    0
--  102439087 |         18 |          0 |                    0
--  133023568 |          3 |          0 |                    0
--  230794730 |         41 |          0 |                    0
--   88027661 |          1 |          0 |                    0
--   30160706 |       6578 |          0 |                    0
--     947519 |     101294 |          0 |                    0
--  138030712 |    9158761 |          0 |                    0
--  137512364 |    1450894 |          0 |                    0
--   86135589 |        168 |          0 |                    0
--   83037928 |          2 |          0 |                    0
--  133541859 |          8 |          0 |                    0
--   28201445 |       1105 |          0 |                    0
--  147081554 |         53 |          0 |                    0
--   39096670 |        213 |        213 |                    1
--  107971650 |         11 |          0 |                    0
--    8911047 |    2448060 |          0 |                    0
--  158470294 |         58 |          0 |                    0
--   21379187 |     170327 |          0 |                    0
--  184623414 |     291839 |          0 |                    0
--   37846210 |     276061 |          0 |                    0
--  209960140 |       6473 |          0 |                    0
--   10332629 |    2667311 |          0 |                    0
--  125216434 |    1706008 |          0 |                    0
--   30565441 |         76 |          0 |                    0
--   29737277 |        227 |          0 |                    0
--   71852533 |   74886637 |          0 |                    0
--  106990048 |       4497 |          0 |                    0
--   46602569 |         18 |          0 |                    0
--   83605450 |    2034360 |          0 |                    0
--  140130486 |         35 |          0 |                    0
--     127800 |   91382770 |   85039209 |    0.930582526662302
--  233400279 |     173776 |          0 |                    0
--  147096714 |         47 |          0 |                    0
--  100837532 |    1642864 |    1642864 |                    1
--   25451849 |      23782 |          0 |                    0
--   83919985 |        452 |          0 |                    0
--  136999564 |         12 |          0 |                    0
--   30917811 |      42278 |          0 |                    0
--   92743810 |      58103 |          0 |                    0
--  131175131 |     983601 |          0 |                    0
--  141205732 |         31 |          0 |                    0
--  123517994 |    2551849 |          0 |                    0
--   28310012 |        763 |          0 |                    0
--  179988448 |    6257037 |    6130964 |     0.97985100615515
--  194701696 |     624953 |          0 |                    0
--  209296130 |      10279 |          0 |                    0
--   82315751 |    3374234 |          0 |                    0
--   96366611 |          7 |          0 |                    0
--   41016619 |         26 |          0 |                    0
--  117559435 |          9 |          0 |                    0
--   90148825 |    1148350 |          0 |                    0
--  137254712 |         21 |          0 |                    0
--  125718273 |          2 |          0 |                    0
--   38759871 |       1811 |          0 |                    0
--   45565626 |       6286 |          0 |                    0
--  133022972 |          5 |          0 |                    0
--   46916408 |       2981 |          0 |                    0
--   22866412 |         20 |          0 |                    0
--   45911148 |         54 |          0 |                    0
--   54882935 |        103 |          0 |                    0
--   85188856 |       1739 |          0 |                    0
--   72349485 |          2 |          0 |                    0
--   62888536 |      24615 |          0 |                    0
--  175769353 |         73 |          0 |                    0
--   40793406 |      85000 |          0 |                    0
--   67172879 |      20367 |          0 |                    0
--   83226049 |          9 |          0 |                    0
--  141205589 |        172 |          0 |                    0
--   10027602 |    3514443 |          0 |                    0
--  214062798 |     928607 |          0 |                    0
--   59078790 |     410961 |          0 |                    0
--   41040425 |       1504 |          0 |                    0
--  120985789 |          4 |          0 |                    0
--   85875535 |      62857 |          0 |                    0
--  124021871 |    6547204 |          0 |                    0
--  145717344 |        746 |          0 |                    0
--   96381432 |     255383 |          0 |                    0
--   48997325 |     506187 |          0 |                    0
--   36511475 |   65836897 |          0 |                    0
--   82312288 |          4 |          0 |                    0
--  189181359 |        984 |          0 |                    0
--  117375012 |         10 |          0 |                    0
--   83157422 |        137 |          0 |                    0
--  186794521 |    7696970 |          0 |                    0
--   28206345 |         19 |          0 |                    0
--   86137568 |        127 |          0 |                    0
--    3552088 |       6143 |          0 |                    0
--  119638093 |      74616 |          0 |                    0
--  134605001 |     478019 |          0 |                    0
--   28633374 |      80645 |          0 |                    0
--   39050441 |     503764 |          0 |                    0
--   86133091 |          8 |          0 |                    0
--  146169176 |     174354 |          0 |                    0
--   62642223 |         84 |          0 |                    0
--  101898646 |      14714 |          0 |                    0
--  102383718 |       4880 |          0 |                    0
--   36619478 |    7831831 |          0 |                    0
--  106461249 |         66 |          0 |                    0
--   83916681 |        250 |          0 |                    0
--   29528336 |        439 |          0 |                    0
--  154215188 |        547 |          0 |                    0
--   86401380 |      75509 |          0 |                    0
--   64778962 |        996 |          0 |                    0
--   45021691 |          4 |          0 |                    0
--   44977149 |         15 |          0 |                    0
--  136820243 |        543 |          0 |                    0
--   47711988 |     304997 |          0 |                    0
--   56157891 |         14 |          0 |                    0
--   64291396 |    2792051 |          0 |                    0
--  137422507 |   45337514 |          0 |                    0
--  191078069 |    2062220 |          0 |                    0
--   45877376 |    3701335 |    3696594 |    0.998719110807317
--   68159747 |         56 |          0 |                    0
--  141173718 |    1129987 |    1129987 |                    1
--   89311841 |    1181888 |          0 |                    0
--   21306295 |         35 |          0 |                    0
--  141741776 |          4 |          0 |                    0
--  104764449 |          2 |          0 |                    0
--  132254961 |       1769 |          0 |                    0
--   82430341 |   40483330 |          0 |                    0
--   92748408 |     633475 |          0 |                    0
--  138494027 |        112 |          0 |                    0
--  100815402 |          6 |          0 |                    0
--  124692072 |       2196 |          0 |                    0
--  151920918 |       2894 |          0 |                    0
--  176513803 |    1664455 |          0 |                    0
--  179846360 |     222958 |     222958 |                    1
--   44890813 |      89189 |          0 |                    0
--  100838056 |    1042933 |    1042933 |                    1
--  122485529 |          1 |          0 |                    0
--   28446548 |     203990 |          0 |                    0
