CREATE TABLE analysis.dsds_379_extensions_2019_revenue_metric AS

with
the_parameter_date AS (
  SELECT '2019-01-01'::TIMESTAMP AS the_date_we_run_report
)

, time_constant as (
  SELECT (SELECT the_date_we_run_report FROM the_parameter_date)::date as current_day
  , DATEADD(day,-45,(SELECT the_date_we_run_report FROM the_parameter_date))::date as prev_day
  , DATEADD(day,-1,(SELECT the_date_we_run_report FROM the_parameter_date))::date as the_day
)


, bits as (
  select ext.extension_id, ext.extension_name,round(sum(case when base.amount is null then 0 else (-1*base.amount*365)::float/4500 end ) ,2) as rev_run_rate
  from tahoe.extension_use_bits_complete as base
  full outer join analysis.released_extensions_latest as ext
  on base.extension_id = ext.extension_id
  where base.date >= (select prev_day from time_constant) and base.date < (select current_day from time_constant)
  -- and extension_id = 'bttsqjy6dnv05acplp5vy0mflgrh3z'
  and ext.is_bits_enabled
  group by 1, 2
)

, clicks as (
  select checkout_source_detail as extension_id, date as the_day,"time" as the_time, product_id as channel, user_id
  from tahoe.payment_form_interaction
  where action = 'complete_purchase_click'
  -- and checkout_source_detail = 'pt33xuskm584dpxkqnjs35zlkp406d'
  and action_detail = 'success'
  and date >= (select prev_day from time_constant) and date < (select current_day from time_constant)
)

, subs as (
  select c.extension_id,  ext.extension_name, sum((gross_amount-isnull(taxes,0))/ 100.0)*(365/45)  as rev_run_rate
  from tahoe.subscription_payment as base
  join clicks as c
  on  base.time >= c.the_time and base.time <= (c.the_time + interval '2 hours')
  and base.purchaser_user_id = c.user_id
  join analysis.released_extensions_latest as ext
    on c.extension_id = ext.extension_id
  where base.date >= (select prev_day from time_constant) and base.date < (select current_day from time_constant)
  group by 1, 2
)


, step2_logs AS (
  SELECT "time", extension_id, user_id, channel_id, asin
  FROM tahoe.extension_confirm_buy
  WHERE
  date >= (select prev_day from time_constant) and date < (select current_day from time_constant)
)
, items AS (
  SELECT
  l.extension_id, ext.extension_name, round(sum(case when base.purchase_value is null then 0 else base.purchase_value end)*(365/45),2) as rev_run_rate
  FROM tahoe.extension_item_entitled as base
  join step2_logs  as l
  on base.user_id = l.user_id
  and base.time >= l.time and base.time <= (l.time + interval '2 hours')
  and base.asin = l.asin
  and base.channel_id = l.channel_id
  join analysis.released_extensions_latest as ext
  on l.extension_id = ext.extension_id
  WHERE
  base.date >= (select prev_day from time_constant) and base.date < (select current_day from time_constant)
  and
  base.channel_id is not null
  group by 1, 2
)
-- , merch as (
-- select 'merch' as extension_id, 'snaps' as extension_name, 1 as rev_run_rate
-- )

, final as (
select (SELECT the_day FROM time_constant) AS the_day, 'bits' AS rev_source, * from bits
UNION ALL
select (SELECT the_day FROM time_constant) AS the_day, 'subs' AS rev_source, * from subs
UNION ALL
select (SELECT the_day FROM time_constant) AS the_day, 'digital_items' AS rev_source, * from items
-- union ALL
-- select * from merch
)

select * from final --order by rev_run_rate desc limit 30
;

-- SELECT the_day, COUNT(1) as rows, SUM(rev_run_rate) AS rev_run_rate FROM analysis.dsds_379_extensions_2019_revenue_metric GROUP BY 1 ORDER BY 1

--SELECT * FROM analysis.dsds_379_extensions_2019_revenue_metric ORDER BY rev_run_rate DESC LIMIT 30
