
CREATE TEMP TABLE the_temp_table (LIKE analysis.dsds_379_extensions_2019_revenue_metric);


PREPARE the_insert_function (VARCHAR) AS
INSERT INTO the_temp_table
(


  WITH
  the_parameter_date AS (
    SELECT $1::DATE AS the_date_we_run_report
  )

  , time_constant as (
    SELECT (SELECT the_date_we_run_report FROM the_parameter_date)::date as current_day
    , DATEADD(day,-45,(SELECT the_date_we_run_report FROM the_parameter_date))::date as prev_day
    , DATEADD(day,-1,(SELECT the_date_we_run_report FROM the_parameter_date))::date as the_day
  )


  , bits as (
    select ext.extension_id, ext.extension_name,round(sum(case when base.amount is null then 0 else (-1*base.amount*365)::float/4500 end ) ,2) as rev_run_rate
    from tahoe.extension_use_bits_complete as base
    left join analysis.all_extensions_latest as ext
      on base.extension_id = ext.extension_id
    where base.date >= (select prev_day from time_constant) and base.date < (select current_day from time_constant)
      and ext.is_bits_enabled
    group by 1, 2
  )

  , clicks as (
    select checkout_source_detail as extension_id, date as the_day,"time" as the_time, product_id as channel, user_id
    from tahoe.payment_form_interaction
    where action = 'complete_purchase_click'
    and action_detail = 'success'
    and date >= (select prev_day from time_constant) and date < (select current_day from time_constant)
  )

  , subs as (
    select c.extension_id,  ext.extension_name, sum((gross_amount-isnull(taxes,0))/ 100.0)*(365/45)  as rev_run_rate
    from tahoe.subscription_payment as base
    join clicks as c
    on  base.time >= c.the_time and base.time <= (c.the_time + interval '2 hours')
    and base.purchaser_user_id = c.user_id
    left join analysis.all_extensions_latest as ext
      on c.extension_id = ext.extension_id
    where base.date >= (select prev_day from time_constant) and base.date < (select current_day from time_constant)
    group by 1, 2
  )


  , step2_logs AS (
    SELECT "time", extension_id, user_id, channel_id, asin
    FROM tahoe.extension_confirm_buy
    WHERE
    date >= (select prev_day from time_constant) and date < (select current_day from time_constant)
  )
  , items AS (
    SELECT
    l.extension_id, ext.extension_name, round(sum(case when base.purchase_value is null then 0 else base.purchase_value end)*(365/45),2) as rev_run_rate
    FROM tahoe.extension_item_entitled as base
    join step2_logs  as l
    on base.user_id = l.user_id
    and base.time >= l.time and base.time <= (l.time + interval '2 hours')
    and base.asin = l.asin
    and base.channel_id = l.channel_id
    left join analysis.all_extensions_latest as ext
      on l.extension_id = ext.extension_id
    WHERE
    base.date >= (select prev_day from time_constant) and base.date < (select current_day from time_constant)
    and
    base.channel_id is not null
    group by 1, 2
  )
  -- , merch as (
  -- select 'merch' as extension_id, 'snaps' as extension_name, 1 as rev_run_rate
  -- )

  , final as (
  select (SELECT the_day FROM time_constant) AS the_day, 'bits' AS rev_source, * from bits
  UNION ALL
  select (SELECT the_day FROM time_constant) AS the_day, 'subs' AS rev_source, * from subs
  UNION ALL
  select (SELECT the_day FROM time_constant) AS the_day, 'digital_items' AS rev_source, * from items
  -- union ALL
  -- select * from merch
  )

  select * from final

);

--DELETE THE DATA FOR THE DAY YOU ARE GOING TO BE ADDING IN
PREPARE the_delete_function (VARCHAR) AS
DELETE FROM analysis.dsds_379_extensions_2019_revenue_metric
WHERE analysis.dsds_379_extensions_2019_revenue_metric.the_day = DATEADD(day, -1, $1::DATE)
;



EXECUTE the_insert_function ('2019-03-20');
EXECUTE the_insert_function ('2019-03-21');
EXECUTE the_insert_function ('2019-03-22');
EXECUTE the_insert_function ('2019-03-23');
EXECUTE the_insert_function ('2019-03-24');
EXECUTE the_insert_function ('2019-03-25');
EXECUTE the_insert_function ('2019-03-26');
EXECUTE the_insert_function ('2019-03-27');
EXECUTE the_insert_function ('2019-03-28');
EXECUTE the_insert_function ('2019-03-29');
EXECUTE the_insert_function ('2019-03-30');
EXECUTE the_insert_function ('2019-03-31');

EXECUTE the_insert_function ('2019-04-01');





EXECUTE the_delete_function ('2019-03-20');
EXECUTE the_delete_function ('2019-03-21');
EXECUTE the_delete_function ('2019-03-22');
EXECUTE the_delete_function ('2019-03-23');
EXECUTE the_delete_function ('2019-03-24');
EXECUTE the_delete_function ('2019-03-25');
EXECUTE the_delete_function ('2019-03-26');
EXECUTE the_delete_function ('2019-03-27');
EXECUTE the_delete_function ('2019-03-28');
EXECUTE the_delete_function ('2019-03-29');
EXECUTE the_delete_function ('2019-03-30');
EXECUTE the_delete_function ('2019-03-31');

EXECUTE the_delete_function ('2019-04-01');







-- Load TEMP_TABLE into ROLLUP_TABLE
INSERT INTO analysis.dsds_379_extensions_2019_revenue_metric
(SELECT * FROM the_temp_table);



DEALLOCATE the_insert_function;
DEALLOCATE the_delete_function;
