--NOTE: THERE ARE A LOT OF MOVING PIECES AND UNKNOWNS STILL AS OF 2019-02-27
--For historical data, we can't use analysis.dsds_389_extensions_daily_metadata, so just use the earliest day's snapshot of that table as the metadata state
--UPDATE THE FOLLOWING LINES AS NECESSARY IN THE FUTURE  --45 to 59, 82 to 87, 97 to 106
--CREATE TABLE analysis.dsds_389_2019_mbr_mw_metric AS
DELETE FROM analysis.dsds_389_2019_mbr_mw_metric WHERE the_day>='2018-07-01' AND the_day<'2019-01-01';
INSERT INTO analysis.dsds_389_2019_mbr_mw_metric (
WITH

the_constants_time AS (
  SELECT '2018-07-01'::DATE AS start_date
    , '2019-01-01'::DATE AS end_date
)
--get the "blessed" list of game to extension_id mapping
--https://docs.google.com/spreadsheets/d/1hk7i3qeL63s4jxAItljN__2dejtzZCpMv4SHk3y6Dqs/edit#gid=738274537
, first_party_extension_log AS (
  SELECT * FROM analysis.dsds_389_blessed_first_party_extensions
  -- game_name	        VARCHAR(256)
  -- extension_id	      VARCHAR(256)
  -- extension_name	    VARCHAR(256)
  -- extension_url	    VARCHAR(256)
  -- game_flattened	    VARCHAR(256)
)
--only take records where the extension is activated
, extension_daily_channel_presence_log AS (
  SELECT the_day, channel_id, extension_id
  FROM analysis.dsds_281_extension_daily_channel_presence_all_anchor
  WHERE
    (SELECT start_date FROM the_constants_time)<=the_day AND the_day<(SELECT end_date FROM the_constants_time)
    AND bool_extension_activated = TRUE
)
--only include records where the extensions are in the blessed first part list
, extension_daily_channel_presence_log_step2 AS (
  SELECT base.the_day, base.channel_id, base.extension_id, first_p.game_name, first_p.game_flattened
  FROM extension_daily_channel_presence_log AS base
  RIGHT JOIN first_party_extension_log AS first_p ON base.extension_id = first_p.extension_id
)
--logic to determine if the extension should count various platform mins watched
, extensions_metadata_log AS (
  SELECT *
    --if any of the conditions of enabled on overlay, panel or component is true, then count web as true, else false
    , CASE WHEN is_overlay_enabled OR is_panel_enabled OR is_component_enabled THEN true ELSE false END AS flag_count_web
    --if is_mobile_enabled is true THEN count android as true, else false
    , CASE WHEN is_mobile_enabled THEN true ELSE false END AS flag_count_android
    --need special logic for ios pending discussion with Danny Chi on extensions team, because ios needs special whitelist
    , false AS flag_count_ios
    ----------------------------------------------------------------------------------------------
    --ADJUST THIS WHEN OTHER PLATFORMS GET EXTENSION SUPPORT (i.e. CONSOLE OR DESKTOP APP)--------
    ----------------------------------------------------------------------------------------------
    --Desklight project will bring extensions onto the desktop app, official launch date still TBD
    , CASE WHEN the_day>='3000-01-01' THEN true ELSE false END AS flag_count_desktop
    --for console, there are no current plans to support extensions
    , false AS flag_count_playstation
    , false AS flag_count_xboxone
    , false AS flag_count_xbox360
    --mobile web and chromecase and other are not slated to have extensions support
    , false AS flag_count_mobile_web
    , false AS flag_count_chromecast
    , false AS flag_count_other
    ----------------------------------------------------------------------------------------------
    ----------------------------------------------------------------------------------------------
  FROM (
    SELECT *
    FROM analysis.dsds_389_extensions_daily_metadata AS base
    WHERE
      base.the_day = '2018-12-13'
  )
)
--join the data
, daily_blessed_extension_per_channel AS (
  SELECT base.the_day, base.channel_id, base.extension_id, base.game_name, base.game_flattened
    , ext_meta.extension_name, ext_meta.extension_url, ext_meta.extension_category_name
    , ext_meta.flag_count_web, ext_meta.flag_count_android, ext_meta.flag_count_ios, ext_meta.flag_count_desktop
    , ext_meta.flag_count_playstation, ext_meta.flag_count_xboxone, ext_meta.flag_count_xbox360
    , ext_meta.flag_count_mobile_web, ext_meta.flag_count_chromecast, ext_meta.flag_count_other
  FROM extension_daily_channel_presence_log_step2 AS base
  LEFT JOIN extensions_metadata_log AS ext_meta ON base.extension_id = ext_meta.extension_id
)



, daily_hours_watched_per_channel_platform_game AS (
  SELECT day AS the_day, channel_id, platform, regexp_replace(lower(game),'([^a-z.])','') as game_flattened, SUM(sum_hw) AS hw
  ---------------------------------------------------------------------
  --POTENTIALLY NEED TO CHANGE NAME OF ROLLUP WHEN SERDAR/SAM UPDATE IT
  ---------------------------------------------------------------------
  FROM rollups.aggtest_viewers
  ---------------------------------------------------------------------
  ---------------------------------------------------------------------
  WHERE
    (SELECT start_date FROM the_constants_time)<=day AND day<(SELECT end_date FROM the_constants_time)
    AND content_type IN ('live stream')
  GROUP BY 1,2,3,4
)


, joined_daily_blessed_hours_watched AS (
  SELECT base.the_day, base.channel_id, base.platform, base.game_flattened, NVL(blessed_game.flag_is_blessed_game, FALSE) AS flag_is_blessed_game
    -----------------------------------------------------------------------
    --ADJUST THIS WHEN OTHER PLATFORMS GET EXTENSION SUPPORT (i.e. CONSOLE)
    -----------------------------------------------------------------------
    , CASE WHEN base.platform='web' AND flag_count_web THEN TRUE
      WHEN base.platform='android' AND flag_count_android THEN TRUE
      WHEN base.platform='ios' AND flag_count_ios THEN TRUE
      WHEN base.platform='desktop' AND flag_count_desktop THEN TRUE
    ELSE FALSE END AS flag_mw_with_blessed_extension
    -----------------------------------------------------------------------
    -----------------------------------------------------------------------
    , base.hw
    , blessed.extension_id, blessed.extension_name, blessed.extension_url, blessed.extension_category_name
    , blessed.flag_count_web, blessed.flag_count_android, blessed.flag_count_ios, blessed.flag_count_desktop
    , blessed.flag_count_playstation, blessed.flag_count_xboxone, blessed.flag_count_xbox360
    , blessed.flag_count_mobile_web, blessed.flag_count_chromecast, blessed.flag_count_other
  FROM daily_hours_watched_per_channel_platform_game AS base
  LEFT JOIN daily_blessed_extension_per_channel AS blessed
    ON base.the_day = blessed.the_day
    AND base.channel_id = blessed.channel_id
    AND base.game_flattened = blessed.game_flattened
  LEFT JOIN analysis.dsds_389_blessed_games_list AS blessed_game ON base.game_flattened = blessed_game.game_flattened
)


, final_data AS (
  SELECT the_day, platform, flag_is_blessed_game, the_game
    , ROUND(hw_with_blessed_extension::FLOAT,2) AS hw_with_blessed_extension
    , ROUND(total_hw::FLOAT,2) AS total_hw
    , ROUND(pct_hw_with_blessed_extension::FLOAT,6) AS pct_hw_with_blessed_extension
  FROM (
    SELECT the_day, platform, flag_is_blessed_game, CASE WHEN flag_is_blessed_game THEN game_flattened ELSE 'other_games_w_no_official_extension' END AS the_game
    , SUM(CASE WHEN flag_mw_with_blessed_extension THEN hw ELSE 0 END) AS hw_with_blessed_extension
    , SUM(hw) AS total_hw
    , SUM(CASE WHEN flag_mw_with_blessed_extension THEN hw ELSE 0 END)::FLOAT/SUM(hw+0.000000000000000000000000000000000000000000000001) AS pct_hw_with_blessed_extension
    FROM joined_daily_blessed_hours_watched

    GROUP BY 1,2,3,4
  )
)




SELECT * FROM final_data --ORDER BY 1,2,3,4
);
