CREATE TABLE dx_sandbox.dsds_409_jax_logs_one_row_only AS


WITH
the_constants AS (
  SELECT '2018-04-01'::DATE AS start_time, '2019-04-01'::DATE AS end_time
  , 67955580::BIGINT AS channel_id --chewiemelodies
)

, jax_logs AS (
  SELECT DATE_TRUNC('minute',"time") AS the_minute, rails_channel_id AS channel_id, rails_meta_game AS game
  FROM tahoe.jax_live_channel
  WHERE
    usher_id IS NOT NULL AND rails_channel_id IS NOT NULL
    AND "date">=(SELECT start_time FROM the_constants)
    AND "date"<(SELECT end_time FROM the_constants)
    --AND rails_channel_id = (SELECT channel_id FROM the_constants) --OPTIONAL
    AND game IS NOT NULL
    AND game NOT IN
      ('Just Chatting', 'Art', 'Retro', 'VRChat', 'Music & Performing Arts', 'Travel & Outdoors', 'Programming'
      , 'testinggame', 'E3 2018', 'Food & Drink', 'Casino', 'Games + Demos', 'Talk Shows & Podcasts', 'Chess'
      , 'Crypto', 'Makers & Crafting', 'Slots', 'Desktop', 'ASMR', 'IRL', 'Talk Shows', 'Creative', 'Music'
      , 'Always On', '', 'irl', 'fortnite', 'league of legends', 'overwatch'
      , 'just chatting', 'Game Development', 'Science & Technology', 'Special Events', 'Poker', 'Auto Chess', 'Doctor Who', 'Twitch Plays')
  GROUP BY 1,2,3
)

, jax_logs_one_row_only AS (
  SELECT * FROM (
    SELECT the_minute, channel_id, game
      , row_number() OVER (PARTITION BY the_minute, channel_id ORDER BY random()) AS random_row_num
    FROM jax_logs
  )
  WHERE random_row_num=1
)

SELECT * FROM jax_logs_one_row_only;
