CREATE TABLE dx_sandbox.dsds_409_per_game_per_minute_concurrents AS

WITH
the_constants AS (
  SELECT '2018-04-01'::DATE AS start_time, '2019-04-01'::DATE AS end_time
  , 67955580::BIGINT AS channel_id --chewiemelodies
)

-- the_minute, channel_id, concurrent_viewer
, concurrent_logs AS (
  SELECT * FROM dx_sandbox.dsds_409_concurrent_logs
)

--the_minute, channel_id, game
, jax_logs AS (
  SELECT * FROM dx_sandbox.dsds_409_jax_logs_one_row_only
)

, joined_logs AS (
  SELECT *
  FROM (
    SELECT base.the_minute, base.channel_id, jl.game, base.concurrent_viewer
    FROM concurrent_logs AS base
    LEFT JOIN jax_logs AS jl
      ON base.channel_id = jl.channel_id
      AND base.the_minute= jl.the_minute
  )
  WHERE game IS NOT NULL
)

--game, mw_live_total, the_rank, the_rank_group
, game_rank AS (
  SELECT * FROM dx_sandbox.dsds_409_game_rank
)

, per_game_per_minute_concurrents AS (
  SELECT base.game, gr.the_rank_group, base.the_minute
    , SUM(concurrent_viewer) AS concurrent_viewer
    , COUNT(DISTINCT channel_id) AS concurrent_streamer
  FROM joined_logs AS base
  LEFT JOIN game_rank AS gr ON base.game = gr.game
  GROUP BY 1,2,3
)

SELECT * FROM per_game_per_minute_concurrents;
