--CREATING THIS HELPER TABLE TO SEPARATE OUT LOGIC IN CASE THE QUERY TAKES TOO LONG TO RUN
CREATE TEMP TABLE the_temp_table (LIKE dx_sandbox.extension_content_matched_metric_blessed_games_list);
INSERT INTO the_temp_table (
WITH
first_party_extension_log AS (
  SELECT * FROM dx_metadata.official_content_matched_extensions
)
, the_blessed_games_list AS (
  SELECT game_flattened::VARCHAR(255), TRUE AS flag_is_blessed_game
  FROM first_party_extension_log
  GROUP BY 1,2
)
SELECT * FROM the_blessed_games_list
);

DELETE FROM dx_sandbox.extension_content_matched_metric_blessed_games_list;
INSERT INTO dx_sandbox.extension_content_matched_metric_blessed_games_list
(SELECT * FROM the_temp_table);
DROP TABLE the_temp_table;



--CREATE A the_temp_table BASED ON THAT SCHEMA
CREATE TEMP TABLE the_temp_table (LIKE dx_rollup.extension_content_matched_metric);



/* CHANGE the_index_date IF YOU WANT TO CHANGE THE RELATIVE DATE */
CREATE TEMP TABLE the_dates_table AS (
  SELECT DATE_TRUNC('day', (SYSDATE - INTERVAL '7 hours'))::DATE AS the_index_date --today's start date
);



--DELETE THE DATA FOR THE DAY YOU ARE GOING TO BE ADDING IN
PREPARE the_delete_function (BIGINT) AS
  DELETE FROM dx_rollup.extension_content_matched_metric
  WHERE the_day = DATEADD(  day, $1, (SELECT the_index_date FROM the_dates_table)  )
;




--THEN WRITE YOUR SQL CODE FOR THE INSERT FUNCTION
PREPARE the_insert_function (BIGINT) AS
INSERT INTO the_temp_table (

  WITH

  the_parameter_input AS (
    SELECT DATEADD(  day, $1, (SELECT the_index_date FROM the_dates_table)  ) AS the_day_to_refresh_data_for
  )

  , the_constants_time AS (
    SELECT start_date, DATEADD(day, 1, start_date) AS end_date
    FROM (SELECT the_day_to_refresh_data_for AS start_date FROM the_parameter_input)
  )

  --for ugc channels, get the "blessed" list of game to extension_id mapping
  --https://docs.google.com/spreadsheets/d/1hk7i3qeL63s4jxAItljN__2dejtzZCpMv4SHk3y6Dqs/edit#gid=738274537
  , first_party_extension_log AS (
    SELECT *, TRUE AS flag_is_ugc_content_matched_extension FROM dx_metadata.official_content_matched_extensions
    -- game_name	        VARCHAR(256)
    -- extension_id	      VARCHAR(256)
    -- extension_name	    VARCHAR(256)
    -- extension_url	    VARCHAR(256)
    -- game_flattened	    VARCHAR(256)
  )
  -- for premium channels, these are the extension_id to count towards content matched mw
  -- https://docs.google.com/spreadsheets/d/1hk7i3qeL63s4jxAItljN__2dejtzZCpMv4SHk3y6Dqs/edit#gid=0
  , blessed_premium_extensions AS (
    SELECT extension_id, extension_name, extension_url, flag_is_content_matched AS flag_is_premium_content_matched_extension
    FROM dx_sandbox.premium_channel_extensions
    WHERE flag_is_content_matched = TRUE
    GROUP BY 1,2,3,4
    -- extension_id	            VARCHAR(256)
    -- extension_name	          VARCHAR(256)
    -- extension_url	          VARCHAR(256)
    -- flag_is_content_matched	BOOL
  )
  --only take records where the extension is activated
  , extension_daily_channel_presence_log AS (
    SELECT base.the_day, base.channel_id, cds.tier, CASE WHEN cds.tier IN ('T5: Premium') THEN 'O&O Channel' ELSE 'UGC Channel' END AS flag_ugc_oo_channel, base.extension_id
    FROM dx_rollup.extension_daily_channel_presence AS base
    LEFT JOIN dx_rollup.channel_daily_status AS cds ON base.channel_id = cds.channel_id AND base.the_day = cds.the_date
    WHERE
      (SELECT start_date FROM the_constants_time)<=the_day AND the_day<(SELECT end_date FROM the_constants_time)
      AND bool_extension_activated = TRUE
  )
  --only include records where the extensions are in the blessed list of extensions for ugc channels, or they are tier 5 (o&o) with the premium extensions
  , extension_daily_channel_presence_log_step2 AS (
    SELECT *
    FROM (
      SELECT base.the_day, base.channel_id, base.tier, base.flag_ugc_oo_channel, base.extension_id, first_p.game_name, first_p.game_flattened, first_p.flag_is_ugc_content_matched_extension, bpe.flag_is_premium_content_matched_extension
      FROM extension_daily_channel_presence_log AS base
      LEFT JOIN first_party_extension_log AS first_p ON base.extension_id = first_p.extension_id
      LEFT JOIN blessed_premium_extensions AS bpe ON base.extension_id = bpe.extension_id
    )
    WHERE
      (flag_is_premium_content_matched_extension AND flag_ugc_oo_channel='O&O Channel') -- it is a premium channel, and it has a premium channel content matched extension
      OR (flag_is_ugc_content_matched_extension AND flag_ugc_oo_channel='UGC Channel') --it is not a premium channel, and it has a ugc channel content matched extension
  )



  --logic to determine if the extension should count various platform mins watched
  , extensions_metadata_log AS (
    SELECT *
      --if any of the conditions of enabled on overlay, panel or component is true, then count web as true, else false
      , CASE WHEN is_overlay_enabled OR is_panel_enabled OR is_component_enabled THEN true ELSE false END AS flag_count_web
      --if is_mobile_enabled is true THEN count android as true, else false
      , CASE WHEN is_mobile_enabled THEN true ELSE false END AS flag_count_android
      --need special logic for ios pending discussion with Danny Chi on extensions team, because ios needs special whitelist
      , false AS flag_count_ios
      ----------------------------------------------------------------------------------------------
      --ADJUST THIS WHEN OTHER PLATFORMS GET EXTENSION SUPPORT (i.e. CONSOLE OR DESKTOP APP)--------
      ----------------------------------------------------------------------------------------------
      --Desklight project will bring extensions onto the desktop app, official launch date still TBD
      , CASE WHEN (SELECT start_date FROM the_constants_time)>='3000-01-01' THEN true ELSE false END AS flag_count_desktop
      --for console, there are no current plans to support extensions
      , false AS flag_count_playstation
      , false AS flag_count_xboxone
      , false AS flag_count_xbox360
      --mobile web and chromecase and other are not slated to have extensions support
      , false AS flag_count_mobile_web
      , false AS flag_count_chromecast
      , false AS flag_count_other
      ----------------------------------------------------------------------------------------------
      ----------------------------------------------------------------------------------------------
    FROM dx_metadata.all_extensions_latest
  )





  --join the data, this has multiple rows per game_flattened since it can be 1 game multiple extensions
  , daily_blessed_extension_per_channel AS (
    SELECT base.the_day, base.channel_id, base.tier, base.flag_ugc_oo_channel
      , base.extension_id, base.game_name, base.game_flattened
      , ext_meta.extension_name
      , ext_meta.extension_url
      , ext_meta.extension_category_name
      , ext_meta.flag_count_web
      , ext_meta.flag_count_android
      , ext_meta.flag_count_ios
      , ext_meta.flag_count_desktop
      , ext_meta.flag_count_playstation
      , ext_meta.flag_count_xboxone
      , ext_meta.flag_count_xbox360
      , ext_meta.flag_count_mobile_web
      , ext_meta.flag_count_chromecast
      , ext_meta.flag_count_other
      , base.flag_is_ugc_content_matched_extension, base.flag_is_premium_content_matched_extension
    FROM extension_daily_channel_presence_log_step2 AS base
    LEFT JOIN extensions_metadata_log AS ext_meta ON base.extension_id = ext_meta.extension_id
  )

  --aggregate daily_blessed_extension_per_channel to be 1 row per the_day, channel_id, game_flattened
  , daily_blessed_extension_per_channel_step2 AS (
    SELECT the_day, channel_id, game_flattened
    , BOOL_OR(flag_count_web) AS flag_count_web
    , BOOL_OR(flag_count_android) AS flag_count_android
    , BOOL_OR(flag_count_ios) AS flag_count_ios
    , BOOL_OR(flag_count_desktop) AS flag_count_desktop
    , BOOL_OR(flag_count_playstation) AS flag_count_playstation
    , BOOL_OR(flag_count_xboxone) AS flag_count_xboxone
    , BOOL_OR(flag_count_xbox360) AS flag_count_xbox360
    , BOOL_OR(flag_count_mobile_web) AS flag_count_mobile_web
    , BOOL_OR(flag_count_chromecast) AS flag_count_chromecast
    , BOOL_OR(flag_count_other) AS flag_count_other
    , BOOL_OR(flag_is_ugc_content_matched_extension) AS flag_is_ugc_content_matched_extension
    , BOOL_OR(flag_is_premium_content_matched_extension) AS flag_is_premium_content_matched_extension
    FROM daily_blessed_extension_per_channel
    GROUP BY 1,2,3
  )




  , daily_hours_watched_per_channel_platform_game AS (
    SELECT base.day AS the_day, base.channel_id, base.platform, regexp_replace(lower(base.game),'([^a-zA-Z0-9.])','') as game_flattened
    , cds.tier, CASE WHEN cds.tier IN ('T5: Premium') THEN 'O&O Channel' ELSE 'UGC Channel' END AS flag_ugc_oo_channel
    , SUM(base.mw::FLOAT/60) AS hw
    ---------------------------------------------------------------------
    --POTENTIALLY NEED TO CHANGE NAME OF ROLLUP WHEN SERDAR/SAM UPDATE IT
    ---------------------------------------------------------------------
    FROM cubes.hours_watched_daily_by_device AS base--FROM rollups.aggtest_viewers AS base
    ---------------------------------------------------------------------
    ---------------------------------------------------------------------
    LEFT JOIN dx_rollup.channel_daily_status AS cds ON base.channel_id = cds.channel_id AND base.day = cds.the_date
    WHERE
      (SELECT start_date FROM the_constants_time)<=base.day AND base.day<(SELECT end_date FROM the_constants_time)
      AND base.content_mode IN ('live stream')--AND base.content_type IN ('live stream')
    GROUP BY 1,2,3,4,5,6
  )



  , joined_daily_blessed_hours_watched_ugc AS (
    SELECT *
    FROM (
      SELECT base.the_day, base.channel_id, base.tier, base.flag_ugc_oo_channel, base.platform, base.game_flattened
        , NVL(blessed_game.flag_is_blessed_game, FALSE) AS flag_is_blessed_game
        -----------------------------------------------------------------------
        --ADJUST THIS WHEN OTHER PLATFORMS GET EXTENSION SUPPORT (i.e. CONSOLE)
        -----------------------------------------------------------------------
        , CASE
          WHEN base.flag_ugc_oo_channel='UGC Channel' AND blessed.flag_is_ugc_content_matched_extension AND base.platform='web' AND flag_count_web THEN TRUE
          WHEN base.flag_ugc_oo_channel='UGC Channel' AND blessed.flag_is_ugc_content_matched_extension AND base.platform='android' AND flag_count_android THEN TRUE
          WHEN base.flag_ugc_oo_channel='UGC Channel' AND blessed.flag_is_ugc_content_matched_extension AND base.platform='ios' AND flag_count_ios THEN TRUE
          WHEN base.flag_ugc_oo_channel='UGC Channel' AND blessed.flag_is_ugc_content_matched_extension AND base.platform='desktop' AND flag_count_desktop THEN TRUE
          WHEN base.flag_ugc_oo_channel='O&O Channel' AND blessed.flag_is_premium_content_matched_extension AND base.platform='web' AND flag_count_web THEN TRUE
          WHEN base.flag_ugc_oo_channel='O&O Channel' AND blessed.flag_is_premium_content_matched_extension AND base.platform='android' AND flag_count_android THEN TRUE
          WHEN base.flag_ugc_oo_channel='O&O Channel' AND blessed.flag_is_premium_content_matched_extension AND base.platform='ios' AND flag_count_ios THEN TRUE
          WHEN base.flag_ugc_oo_channel='O&O Channel' AND blessed.flag_is_premium_content_matched_extension AND base.platform='desktop' AND flag_count_desktop THEN TRUE
        ELSE FALSE END AS flag_mw_with_blessed_extension
        -----------------------------------------------------------------------
        -----------------------------------------------------------------------
        , base.hw
        , blessed.flag_count_web, blessed.flag_count_android, blessed.flag_count_ios, blessed.flag_count_desktop
        , blessed.flag_count_playstation, blessed.flag_count_xboxone, blessed.flag_count_xbox360
        , blessed.flag_count_mobile_web, blessed.flag_count_chromecast, blessed.flag_count_other
      FROM daily_hours_watched_per_channel_platform_game AS base
      LEFT JOIN dx_sandbox.extension_content_matched_metric_blessed_games_list AS blessed_game ON base.game_flattened = blessed_game.game_flattened
      LEFT JOIN daily_blessed_extension_per_channel_step2 AS blessed
        ON base.the_day = blessed.the_day
        AND base.channel_id = blessed.channel_id
        AND base.game_flattened = blessed.game_flattened
    )
    WHERE flag_ugc_oo_channel= 'UGC Channel'
  )

  --ASSUME THAT IF AN O&O CHANNEL HAS THE BLESSED EXTENSION ACTIVE, THEN COUNT IT AS HW WITH EXTENSION (i.e. TWITCH PRESENTS CHANNEL WILL CORRECTLY TURN OFF POKEMON EXTENSION WHEN NOT STREAMING POKEMON)
  --NOTE: flag_is_blessed_game field are not relevant for O&O channels, so set TRUE as default
  , joined_daily_blessed_hours_watched_premium AS (
    SELECT *
    FROM (
      SELECT base.the_day, base.channel_id, base.tier, base.flag_ugc_oo_channel, base.platform, base.game_flattened
        , TRUE AS flag_is_blessed_game
        -----------------------------------------------------------------------
        --ADJUST THIS WHEN OTHER PLATFORMS GET EXTENSION SUPPORT (i.e. CONSOLE)
        -----------------------------------------------------------------------
        , CASE
          WHEN base.flag_ugc_oo_channel='UGC Channel' AND blessed.flag_is_ugc_content_matched_extension AND base.platform='web' AND flag_count_web THEN TRUE
          WHEN base.flag_ugc_oo_channel='UGC Channel' AND blessed.flag_is_ugc_content_matched_extension AND base.platform='android' AND flag_count_android THEN TRUE
          WHEN base.flag_ugc_oo_channel='UGC Channel' AND blessed.flag_is_ugc_content_matched_extension AND base.platform='ios' AND flag_count_ios THEN TRUE
          WHEN base.flag_ugc_oo_channel='UGC Channel' AND blessed.flag_is_ugc_content_matched_extension AND base.platform='desktop' AND flag_count_desktop THEN TRUE
          WHEN base.flag_ugc_oo_channel='O&O Channel' AND blessed.flag_is_premium_content_matched_extension AND base.platform='web' AND flag_count_web THEN TRUE
          WHEN base.flag_ugc_oo_channel='O&O Channel' AND blessed.flag_is_premium_content_matched_extension AND base.platform='android' AND flag_count_android THEN TRUE
          WHEN base.flag_ugc_oo_channel='O&O Channel' AND blessed.flag_is_premium_content_matched_extension AND base.platform='ios' AND flag_count_ios THEN TRUE
          WHEN base.flag_ugc_oo_channel='O&O Channel' AND blessed.flag_is_premium_content_matched_extension AND base.platform='desktop' AND flag_count_desktop THEN TRUE
        ELSE FALSE END AS flag_mw_with_blessed_extension
        -----------------------------------------------------------------------
        -----------------------------------------------------------------------
        , base.hw
        , blessed.flag_count_web, blessed.flag_count_android, blessed.flag_count_ios, blessed.flag_count_desktop
        , blessed.flag_count_playstation, blessed.flag_count_xboxone, blessed.flag_count_xbox360
        , blessed.flag_count_mobile_web, blessed.flag_count_chromecast, blessed.flag_count_other
      FROM daily_hours_watched_per_channel_platform_game AS base
      LEFT JOIN daily_blessed_extension_per_channel_step2 AS blessed
        ON base.the_day = blessed.the_day
        AND base.channel_id = blessed.channel_id
    )
    WHERE flag_ugc_oo_channel= 'O&O Channel'
  )


  , final_data_ugc AS (
    SELECT the_day, channel_id, platform, flag_ugc_oo_channel, flag_is_blessed_game, the_game
      , ROUND(hw_with_blessed_extension::FLOAT,2) AS hw_with_blessed_extension
      , ROUND(total_hw::FLOAT,2) AS total_hw
      , ROUND(pct_hw_with_blessed_extension::FLOAT,6) AS pct_hw_with_blessed_extension
    FROM (
      SELECT the_day, channel_id, platform, flag_ugc_oo_channel, flag_is_blessed_game, CASE WHEN flag_is_blessed_game THEN game_flattened ELSE 'other_games_w_no_official_extension' END AS the_game
      , SUM(CASE WHEN flag_mw_with_blessed_extension THEN hw ELSE 0 END) AS hw_with_blessed_extension
      , SUM(hw) AS total_hw
      , SUM(CASE WHEN flag_mw_with_blessed_extension THEN hw ELSE 0 END)::FLOAT/NULLIF(SUM(hw::FLOAT),0) AS pct_hw_with_blessed_extension
      FROM joined_daily_blessed_hours_watched_ugc
      GROUP BY 1,2,3,4,5,6
    )
  )

  , final_data_premium AS (
    SELECT the_day, channel_id, platform, flag_ugc_oo_channel, flag_is_blessed_game, the_game
      , ROUND(hw_with_blessed_extension::FLOAT,2) AS hw_with_blessed_extension
      , ROUND(total_hw::FLOAT,2) AS total_hw
      , ROUND(pct_hw_with_blessed_extension::FLOAT,6) AS pct_hw_with_blessed_extension
    FROM (
      SELECT the_day, channel_id, platform, flag_ugc_oo_channel, flag_is_blessed_game, CASE WHEN flag_is_blessed_game THEN game_flattened ELSE 'other_games_w_no_official_extension' END AS the_game
      , SUM(CASE WHEN flag_mw_with_blessed_extension THEN hw ELSE 0 END) AS hw_with_blessed_extension
      , SUM(hw) AS total_hw
      , SUM(CASE WHEN flag_mw_with_blessed_extension THEN hw ELSE 0 END)::FLOAT/NULLIF(SUM(hw::FLOAT),0) AS pct_hw_with_blessed_extension
      FROM joined_daily_blessed_hours_watched_premium
      GROUP BY 1,2,3,4,5,6
    )
  )


  , final_data AS (
    SELECT * FROM final_data_ugc
    UNION ALL
    SELECT * FROM final_data_premium
  )


  SELECT * FROM final_data

);









EXECUTE the_delete_function (-1);



EXECUTE the_insert_function (-1);













-- Load TEMP_TABLE into TABLE AFTER DELETING THE DATA
INSERT INTO dx_rollup.extension_content_matched_metric
(SELECT * FROM the_temp_table);


DEALLOCATE the_insert_function;
DEALLOCATE the_delete_function;

