--PRE AGGREGATION TABLES CREATED TO HELP WITH QUERY OPTIMIZATION

--THIS LISTS ALL OF THE GAMES THAT ARE PART OF THE LIST OF CONTENT MATCHED EXTENSIONS
--CREATES TABLE WITH THIS SCHEMA:
-- game_flattened	         VARCHAR(255)
-- flag_is_blessed_game    BOOLEAN

CREATE TEMP TABLE the_temp_table_blessed_games_list (LIKE dx_sandbox.extension_cme_metric_helper_blessed_games);
INSERT INTO the_temp_table_blessed_games_list (
WITH
first_party_extension_log AS (
  SELECT * FROM dx_metadata.official_content_matched_extensions
)
, the_blessed_games_list AS (
  SELECT game_flattened::VARCHAR(255), TRUE::BOOLEAN AS flag_is_blessed_game
  FROM first_party_extension_log
  GROUP BY 1,2
)
SELECT * FROM the_blessed_games_list
);

DELETE FROM dx_sandbox.extension_cme_metric_helper_blessed_games;
INSERT INTO dx_sandbox.extension_cme_metric_helper_blessed_games
(SELECT * FROM the_temp_table_blessed_games_list);
DROP TABLE the_temp_table_blessed_games_list;
