
-- --
-- --
-- -- -- QA DATA
-- --
--
WITH the_data AS (
  SELECT the_day::DATE, COUNT(1) AS rows, COUNT(DISTINCT channel_id) AS channels
    , COUNT(DISTINCT the_game) the_game
    , SUM(hw_with_blessed_extension) hw_with_blessed_extension
    , SUM(total_hw) total_hw
    , COUNT(DISTINCT the_extension_id_array) AS extension_array
  FROM dx_rollup.extension_content_matched_metric
  WHERE the_day>='2019-07-01'
    AND the_day<='2019-07-31'
    AND flag_ugc_oo_channel='UGC Channel'
    --AND flag_ugc_oo_channel='O&O Channel'
  GROUP BY 1 ORDER BY 1
)

SELECT
the_day, f_numeral_format(rows, 'number',0) AS rows
, f_numeral_format(channels, 'number',0) AS channels
, f_numeral_format(the_game, 'number',0) AS the_game
, f_numeral_format(hw_with_blessed_extension, 'number',0) AS hw_with_blessed_extension
, f_numeral_format(total_hw, 'number',0) AS total_hw
, f_numeral_format(extension_array, 'number',0) AS extension_array
FROM the_data
;



WITH the_data AS (
  SELECT the_day::DATE, COUNT(1) AS rows, COUNT(DISTINCT channel_id) AS channels
  , COUNT(DISTINCT the_game) the_game
  , SUM(hw_with_blessed_extension) hw_with_blessed_extension, SUM(total_hw) total_hw
  FROM dx_rollup.extension_content_matched_metric
  WHERE the_day>='2019-07-01'
    AND the_day<='2019-07-31'
    AND flag_ugc_oo_channel='UGC Channel'
    --AND flag_ugc_oo_channel='O&O Channel'
  GROUP BY 1 ORDER BY 1
)
SELECT
the_day, f_numeral_format(rows, 'number',0) AS rows
, f_numeral_format(channels, 'number',0) AS channels
, f_numeral_format(the_game, 'number',0) AS the_game
, f_numeral_format(hw_with_blessed_extension, 'number',0) AS hw_with_blessed_extension
, f_numeral_format(total_hw, 'number',0) AS total_hw

FROM the_data
;


SELECT the_extension_id_array, the_extension_name_array, COUNT(DISTINCT channel_id) AS channels, COUNT(1) AS rows
FROM dx_rollup.extension_content_matched_metric
WHERE the_day>='2019-07-01'
  AND the_day<='2019-07-31'
  --AND flag_ugc_oo_channel='UGC Channel'
  --AND flag_ugc_oo_channel='O&O Channel'
  AND the_extension_id_array IS NOT NULL
GROUP BY 1,2 ORDER BY 2;
