--GET SHEIK TABLE NAME FROM CUBES OR TAHOE
WITH
the_constants AS (
  --SELECT 'cubes.affiliate_partner_channel_status_timeline'::VARCHAR(MAX) AS full_table_name
  SELECT 'tahoe.channel_concurrents'::VARCHAR(MAX) AS full_table_name
  --SELECT 'dbsnapshots.users'::VARCHAR(MAX) AS full_table_name
  --SELECT 'metadata.atlas_f_organizer_channel'::VARCHAR(MAX) AS full_table_name
  --SELECT 'metadata.png_whitelist'::VARCHAR(MAX) AS full_table_name
  --SELECT ''::VARCHAR(MAX) AS full_table_name
)
, the_constants_parsed AS (
  SELECT
    split_part(full_table_name,'.',1) as schema_name
    , split_part(full_table_name,'.',2) as table_name
  FROM the_constants
)
, the_view_statement AS (
  SELECT definition
  FROM pg_views
  WHERE schemaname = (SELECT schema_name FROM the_constants_parsed) and viewname = (SELECT table_name FROM the_constants_parsed)
)

--chr(10) is newline character
--https://stackoverflow.com/questions/32367106/redshift-how-to-remove-all-newline-characters-in-a-field
, the_view_statement_parsed AS (
  SELECT
    replace(
      replace(
        split_part(
          split_part(split_part(definition,'FROM',2),'WITH NO SCHEMA BINDING;',1)
          , 'WHERE', 1
        )
      , chr(10),'')
    , '\"','') AS the_real_table
  FROM the_view_statement
)

, final_data_partitioned_table AS (
  SELECT *
    , 'select max(values) AS updated_day from svv_external_partitions where schemaname = \''||TRIM(schema_name)||
    '\' and tablename = \''||TRIM(table_name)||'\';' AS query_to_run_to_check_updated_day
  FROM (
    SELECT
      (SELECT full_table_name FROM the_constants) AS your_table
      , the_real_table
      , split_part(the_real_table,'.',1) as schema_name
      , split_part(the_real_table,'.',2) as table_name
    FROM the_view_statement_parsed
  )
)

, final_data_repalcement_table AS (
  SELECT *
    , 'select location from svv_external_tables where schemaname = \''||TRIM(schema_name)||
    '\' and tablename = \''||TRIM(table_name)||'\';' AS query_to_run_to_check_updated_day

    -- , 'select right(split_part(split_part(location,\''||split_part(your_table,'.',2)||
    -- '\',2),\'T\',1),8) AS updated_day from svv_external_tables where schemaname = \''||TRIM(schema_name)||
    -- '\' and tablename = \''||TRIM(table_name)||'\';' AS query_to_run_to_check_updated_day

    -- , 'select to_date(right(split_part(split_part(location,\''||split_part(your_table,'.',2)||
    -- '\',2),\'T\',1),8), \'yyyymmdd\') AS updated_day from svv_external_tables where schemaname = \''||TRIM(schema_name)||
    -- '\' and tablename = \''||TRIM(table_name)||'\';' AS query_to_run_to_check_updated_day
  FROM (
    SELECT
      (SELECT full_table_name FROM the_constants) AS your_table
      , the_real_table
      , split_part(the_real_table,'.',1) as schema_name
      , split_part(the_real_table,'.',2) as table_name
    FROM the_view_statement_parsed
  )
)

, final_data AS (
  SELECT * FROM final_data_partitioned_table
  UNION SELECT * FROM final_data_repalcement_table
)

SELECT your_table, the_real_table, query_to_run_to_check_updated_day FROM final_data;









-- select location from svv_external_tables where schemaname = 'sheik' and tablename = 'affiliate_partner_channel_status_timeline_v0';

-- select right(split_part(split_part(location,'affiliate_partner_channel_status_timeline',2),'T',1),8)
-- from svv_external_tables where schemaname = 'sheik' and tablename = 'affiliate_partner_channel_status_timeline_v0';

-- select max(values) AS updated_day from svv_external_partitions where schemaname = 'tahoe_data' and tablename = 'channel_concurrents_v3';
