-- tahoe.curse_app_pageview, tahoe.pageview

--THEN CREATE A the_temp_table BASED ON THAT SCHEMA
CREATE TEMP TABLE the_temp_table (LIKE dx_rollup.daily_mods_user_list);
CREATE TABLE IF NOT EXISTS dx_airflow_test.daily_mods_user_list (LIKE dx_rollup.daily_mods_user_list);


PREPARE the_insert_function (BIGINT) AS
INSERT INTO the_temp_table (

with

the_dates as (
  SELECT DATEADD(day, $1, DATE_TRUNC('day', (SYSDATE - INTERVAL '7 hours'))) as end_day
)

, laguna_ids AS(
  SELECT DISTINCT date as the_day, user_id, 'laguna' as flag_desklight_laguna
  FROM tahoe.curse_app_pageview
  WHERE split_part(path, '/', 2) IN ('addons',
  'minecraft')
  AND date = (select end_day from the_dates)
)

, desklight_ids AS (
  SELECT DISTINCT date as the_day, user_id, 'desklight' as flag_desklight_laguna
  FROM tahoe.pageview
  WHERE platform = 'desktop'
  AND location LIKE 'desklight/mods%'
  AND location != 'desklight/mods/games-available'
  AND date = (select end_day from the_dates)
)

, final as (
  select * from laguna_ids
  union all
  select * from desklight_ids
)

select * from final
);


PREPARE the_delete_function (BIGINT) AS
DELETE FROM dx_airflow_test.daily_mods_user_list
WHERE dx_airflow_test.daily_mods_user_list.the_day = DATEADD(day, $1, DATE_TRUNC('day', (SYSDATE - INTERVAL '7 hours')))
;

--RUN THE STUFF
EXECUTE the_delete_function (-2);
EXECUTE the_delete_function (-1);

EXECUTE the_insert_function (-2);
EXECUTE the_insert_function (-1);

-- Load TEMP_TABLE into TABLE AFTER DELETING THE DATA
INSERT INTO dx_airflow_test.daily_mods_user_list
(SELECT * FROM the_temp_table);

-- DEALLOCATE THE INSERT FUNCTION
DEALLOCATE the_insert_function;
DEALLOCATE the_delete_function;
