/**REATE TABLE IF NOT EXISTS dx_rollup.extension_mw_by_extension (
the_day                                TIMESTAMP WITHOUT TIME ZONE sortkey
,channel_id                            VARCHAR(32) distkey
,extension_id                          VARCHAR(32)
,extension_mw_non_frontpage            BIGINT
);
**/

CREATE TEMP TABLE the_temp_table (LIKE dx_rollup.extension_mw_by_extension);
CREATE TABLE IF NOT EXISTS dx_sandbox.extension_mw_by_extension (LIKE dx_rollup.extension_mw_by_extension);

PREPARE the_insert_function (BIGINT) AS
INSERT INTO the_temp_table(

  -- get the day to insert
  WITH
  the_parameter_constants AS (
    SELECT
    DATEADD(day, $1, DATE_TRUNC('day', (SYSDATE - INTERVAL '7 hours'))) as start_day
    --$1::timestamp as start_day
  ),

  mw_per_channel_data AS (
    SELECT
    day AS the_day,
    channel_id,
    SUM(mw_live_non_frontpage) AS mw_live_non_frontpage
    FROM cubes.daily_minutes_watched_by_channel
    WHERE date_trunc('day', day) = (select start_day from the_parameter_constants)
    GROUP BY 1,2
  )

  ,channel_extension_data AS (
    SELECT
    the_day,
    channel_id,
    extension_id,
    1 as has_extension
    FROM dx_sandbox.extension_daily_channel_presence
    WHERE bool_extension_activated = TRUE
    and date_trunc('day', the_day) = (select start_day from the_parameter_constants)
    GROUP BY 1,2,3,4
  )

  SELECT
  base.the_day,
  base.channel_id,
  ced.extension_id,
  SUM(case when has_extension = 1 then mw_live_non_frontpage else 0 end) as extension_mw_non_frontpage
  FROM mw_per_channel_data AS base
  JOIN channel_extension_data AS ced
    ON base.the_day = ced.the_day AND base.channel_id = ced.channel_id
  GROUP BY 1,2,3

);

--DELETE THE DATA FOR THE DAY YOU ARE GOING TO BE ADDING IN
PREPARE the_delete_function (BIGINT) AS
DELETE FROM dx_sandbox.extension_mw_by_extension
WHERE date_trunc('day', dx_sandbox.extension_mw_by_extension.the_day) = DATEADD(day, $1, DATE_TRUNC('day', (SYSDATE - INTERVAL '7 hours')))
;


--RUN THE INSERT FUNCTIONS BY ITERATING OVER DIFFERENT VALUES

EXECUTE the_delete_function (-4);
EXECUTE the_delete_function (-3);
EXECUTE the_delete_function (-2);
EXECUTE the_delete_function (-1);

EXECUTE the_insert_function (-4);
EXECUTE the_insert_function (-3);
EXECUTE the_insert_function (-2);
EXECUTE the_insert_function (-1);



-- Load TEMP_TABLE into TABLE AFTER DELETING THE DATA
INSERT INTO dx_sandbox.extension_mw_by_extension
(SELECT * FROM the_temp_table);

-- DEALLOCATE THE INSERT FUNCTION
DEALLOCATE the_insert_function;
DEALLOCATE the_delete_function;

