--CHECK ORDER OF THE FIELDS!!!

-- SCHEMA OF  dx_rollup.extension_content_matched_metric
-- the_day	timestamp
-- channel_id	bigint
-- the_extension_id_array varchar(max)
-- the_extension_name_array varchar(max)
-- the_game	varchar(255)
-- platform	varchar(255)
-- flag_ugc_oo_channel	varchar(255)
-- hw_with_blessed_extension	double precision
-- total_hw	double precision
-- pct_hw_with_blessed_extension	double precision


-- CHANGE the_index_date IF YOU WANT TO CHANGE THE RELATIVE DATE
CREATE TEMP TABLE the_dates_table AS (
  SELECT DATE_TRUNC('day', (SYSDATE - INTERVAL '7 hours'))::DATE AS the_index_date --today's start date
);




--DELETE THE DATA FOR THE DAY YOU ARE GOING TO BE ADDING IN
PREPARE the_delete_function_extension_content_matched_metric_final (BIGINT) AS
DELETE FROM dx_rollup.extension_content_matched_metric
WHERE the_day = DATEADD(  day, $1, (SELECT the_index_date FROM the_dates_table)  )
;






--THEN CREATE A the_temp_table BASED ON THAT SCHEMA
CREATE TEMP TABLE the_temp_table (LIKE dx_rollup.extension_content_matched_metric);

--THEN WRITE YOUR SQL CODE FOR THE INSERT FUNCTION
PREPARE the_insert_function_extension_content_matched_metric_final (BIGINT) AS
INSERT INTO the_temp_table (

  WITH

  the_parameter_input AS (
    SELECT DATEADD(  day, $1, (SELECT the_index_date FROM the_dates_table)  ) AS the_day_to_refresh_data_for
  )

  , the_constants_time AS (
    SELECT start_date, DATEADD(day, 1, start_date) AS end_date
    FROM (SELECT the_day_to_refresh_data_for AS start_date FROM the_parameter_input)
  )


  , final_data AS (
    SELECT * FROM dx_sandbox.extension_content_matched_metric_partial_ugc WHERE (SELECT start_date FROM the_constants_time)<=the_day AND the_day<(SELECT end_date FROM the_constants_time)
    UNION
    SELECT * FROM dx_sandbox.extension_content_matched_metric_partial_premium WHERE (SELECT start_date FROM the_constants_time)<=the_day AND the_day<(SELECT end_date FROM the_constants_time)

  )


  SELECT * FROM final_data

);




EXECUTE the_insert_function_extension_content_matched_metric_final (-2);
EXECUTE the_delete_function_extension_content_matched_metric_final (-2);
INSERT INTO dx_rollup.extension_content_matched_metric    (SELECT * FROM the_temp_table);
DELETE FROM the_temp_table;


EXECUTE the_insert_function_extension_content_matched_metric_final (-1);
EXECUTE the_delete_function_extension_content_matched_metric_final (-1);
INSERT INTO dx_rollup.extension_content_matched_metric    (SELECT * FROM the_temp_table);
DELETE FROM the_temp_table;






----------------------------------------------------------------------------------
-- REMOVE DATA FROM dx_sandbox tables that were used to build this final rollup --
----------------------------------------------------------------------------------
DELETE FROM dx_sandbox.extension_content_matched_metric_partial_ugc;
DELETE FROM dx_sandbox.extension_content_matched_metric_partial_premium;
DELETE FROM dx_sandbox.extension_cme_metric_helper_daily_hours_watched_per_channel_platform_game;
DELETE FROM dx_sandbox.extension_cme_metric_helper_daily_blessed_extension_per_channel;








--CLEAN UP
DROP TABLE the_temp_table;
DEALLOCATE the_insert_function_extension_content_matched_metric_final;
DEALLOCATE the_delete_function_extension_content_matched_metric_final;
