-- tahoe.extension_use_bits_complete, tahoe.subscription_payment, tahoe.prime_extension_action

-- CREATE TABLE dx_rollup.extension_revenue_metric (
--     the_day                     TIMESTAMP WITHOUT TIME ZONE sortkey
--     , rev_source                VARCHAR
--     , extension_id              VARCHAR
--     , extension_name            VARCHAR
--     , rev_run_rate              FLOAT
-- );

--THEN CREATE A the_temp_table BASED ON THAT SCHEMA
CREATE TEMP TABLE the_temp_table (LIKE dx_rollup.extension_revenue_metric);

PREPARE the_insert_function_extension_revenue_metric (BIGINT) AS
INSERT INTO the_temp_table (

 with

    the_dates as (
      SELECT DATEADD(day, $1, DATE_TRUNC('day', (SYSDATE - INTERVAL '7 hours'))) as end_day
    )

-- calculate revenue run rate through bits extensions for the past 45 days

    , bits as (
    select base.extension_id, ext.extension_name,
    round(sum(case when base.amount is null then 0 else (-1*base.amount*365)::float/4500 end ) ,2) as rev_run_rate
    from tahoe.extension_use_bits_complete as base
    left join dx_metadata.all_extensions_latest as ext
    on base.extension_id = ext.extension_id
    where base.date >= ((select end_day from the_dates) - interval '45 days' ) and base.date < (select end_day from the_dates)
    and ext.is_bits_enabled
    group by 1, 2
  )

-- calculate revenue run rate through subs extensions for the past 45 days

  , subs as (
    select base.extension_id, ext.extension_name,
    round(sum((gross_amount-isnull(taxes,0))/ 100.0)*(365/45),2)  as rev_run_rate
    from tahoe.subscription_payment as base
    join dx_metadata.all_extensions_latest as ext
    on base.extension_id = ext.extension_id
    where base.date >= ((select end_day from the_dates) - interval '45 days')and base.date < (select end_day from the_dates)
    and base.extension_id is not null
    and base.extension_id != 'd1dp7kdgsq3yg4ddyyel9mz5jebvoo'
    and payment_provider!='samus' AND product_type!='turbo'
    group by 1, 2
  )

  , prime_subs as (
    select 'd4uvtfdr04uq6raoenvj7m86gdk16v' as extension_id, ext.extension_name,
    round(2.50*365::float/45::float*sum(s.subs), 2) as rev_run_rate
    from dx_metadata.all_extensions_latest as ext,
          (SELECT count(*) as subs
            FROM tahoe.prime_extension_action
            where action = 'subscribe'
            and date >= ((select end_day from the_dates) - interval '45 days' )
            and date < (select end_day from the_dates)
          ) as s
    where ext.extension_id = 'd4uvtfdr04uq6raoenvj7m86gdk16v'
    group by 1, 2
  )



-- calculate revenue run rate through extension item sales for the past 45 days

-- tally the confirm buy click events to backend extension item sales data which can appear up to 2 hours after the click

  -- , confirm_buy_clicks as (
  --   SELECT "time", extension_id, user_id, channel_id, asin
  --   FROM tahoe.extension_confirm_buy
  --   WHERE
  --   date >= ((select end_day from the_dates) - interval '45 days' ) and date < (select end_day from the_dates)
  -- )
  --
  -- , item_sales AS (
  --   SELECT
  --   l.extension_id, ext.extension_name,
  --   round(sum(case when base.purchase_value is null then 0 else base.purchase_value end)*(365/45),2) as rev_run_rate
  --   FROM tahoe.extension_item_entitled as base
  --   join confirm_buy_clicks  as l
  --   on base.user_id = l.user_id
  --   and base.time >= l.time and base.time <= (l.time + interval '2 hours')
  --   and base.asin = l.asin
  --   and base.channel_id = l.channel_id
  --   left join metadata.all_extensions_latest as ext
  --   on l.extension_id = ext.extension_id
  --   WHERE
  --   base.date >=((select end_day from the_dates) - interval '45 days' ) and base.date < (select end_day from the_dates)
  --   and
  --   base.channel_id is not null
  --   group by 1, 2
  -- )

-- calculate the revenue run rate for merch through extensions for the past 45 days

-- , merch as ( )

-- consolidate all of the data into one table

 , final as (
   select (select end_day from the_dates) AS the_day, 'bits' AS rev_source, * from bits
   union all
   select (select end_day from the_dates) AS the_day, 'subs' AS rev_source, * from subs
   union all
   select (select end_day from the_dates) as the_day, 'prime_subs' as rev_source, * from prime_subs
   -- union all
   -- select (select end_day from the_dates) AS the_day, 'digital_items' AS rev_source, * from item_sales
   -- union all
   -- select * from merch
  )

-- display the whole table
  select * from final
);

PREPARE the_delete_function_extension_revenue_metric (BIGINT) AS
DELETE FROM dx_rollup.extension_revenue_metric
WHERE dx_rollup.extension_revenue_metric.the_day = DATEADD(day, $1, DATE_TRUNC('day', (SYSDATE - INTERVAL '7 hours')))
;



--RUN THE STUFF
EXECUTE the_insert_function_extension_revenue_metric (-2);
EXECUTE the_delete_function_extension_revenue_metric (-2);
INSERT INTO dx_rollup.extension_revenue_metric (SELECT * FROM the_temp_table);
DELETE FROM the_temp_table;


EXECUTE the_insert_function_extension_revenue_metric (-1);
EXECUTE the_delete_function_extension_revenue_metric (-1);
INSERT INTO dx_rollup.extension_revenue_metric (SELECT * FROM the_temp_table);
DELETE FROM the_temp_table;



-- DEALLOCATE THE INSERT FUNCTION
DEALLOCATE the_insert_function_extension_revenue_metric;
DEALLOCATE the_delete_function_extension_revenue_metric;
