--cubes.extension_mobile_viewer_funnel_daily

-- CREATE TABLE dx_rollup.extension_mobile_interaction_metric (
--     the_day                     TIMESTAMP WITHOUT TIME ZONE sortkey
--     , extension_id              VARCHAR distkey
--     , platform                  VARCHAR
--     , unique_devices_click      INT
--     , unique_devices_view       INT
--     , mobile_interaction_rate   FLOAT
-- );

--THEN CREATE A the_temp_table BASED ON THAT SCHEMA
CREATE TEMP TABLE the_temp_table (LIKE dx_rollup.extension_mobile_interaction_metric);

PREPARE the_insert_function_extension_mobile_interaction_metric (bigint) AS
INSERT INTO the_temp_table (

-- generate number series to iterate over extension_list
with

the_dates as (
     SELECT DATEADD(day, $1, DATE_TRUNC('day', (SYSDATE - INTERVAL '7 hours'))) as end_day
     , DATEADD(day, $1, DATE_TRUNC('day', (SYSDATE - INTERVAL '7 hours'))) - interval '30 days' as start_day
   )

   , views as (
   select the_day, b.start_day, b.end_day, extension_id, unique_devices_android as views, 'android' as platform
   from cubes.extension_mobile_viewer_funnel_daily as a
   join the_dates as b
   on a.the_day >= b.start_day and a.the_day <= b.end_day
   where action = 'view'
   UNION
   select the_day,  b.start_day, b.end_day, extension_id, unique_devices_ios as views, 'ios' as platform
   from cubes.extension_mobile_viewer_funnel_daily as a
   join the_dates as b
   on a.the_day >= b.start_day and a.the_day <= b.end_day
   where  action = 'view'
   order by 1, 2, 3, 4
   )


   , clicks as (
   select the_day,  b.start_day, b.end_day, extension_id, unique_devices_android as clicks, 'android' as platform
   from cubes.extension_mobile_viewer_funnel_daily as a
   join the_dates as b
   on a.the_day >= b.start_day and a.the_day <= b.end_day
   where  action = 'click'
   UNION
   select the_day,  b.start_day, b.end_day, extension_id, unique_devices_ios as clicks, 'ios' as platform
   from cubes.extension_mobile_viewer_funnel_daily as a
   join the_dates as b
   on a.the_day >= b.start_day and a.the_day <= b.end_day
   where action = 'click'
   order by 1, 2, 3, 4
   )

   , final as (
   select a.end_day as the_day,
     a.extension_id,
     a.platform,
     sum(case when a.views is null then 0 else a.views end) as unique_devices_view,
     sum(case when b.clicks is null then 0 else b.clicks end) as unique_devices_click
   from views a
   join clicks b
   on a.the_day = b.the_day and a.extension_id = b.extension_id and a.platform = b.platform
   group by 1, 2, 3
   order by 1, 2, 3, 4
 )

, mobile_interaction_rate as (
  select
  *,
  case when unique_devices_view = 0 then null
  when unique_devices_click = 0 then 0 else
  unique_devices_click::float/unique_devices_view end as mobile_interaction_rate
  from final
)

select *
from mobile_interaction_rate
);

PREPARE the_delete_function_extension_mobile_interaction_metric (bigint) AS
DELETE FROM dx_rollup.extension_mobile_interaction_metric
WHERE dx_rollup.extension_mobile_interaction_metric.the_day = DATEADD(day, $1, DATE_TRUNC('day', (SYSDATE - INTERVAL '7 hours')))
;


--RUN THE STUFF

EXECUTE the_insert_function_extension_mobile_interaction_metric (-2);
EXECUTE the_delete_function_extension_mobile_interaction_metric (-2);
INSERT INTO dx_rollup.extension_mobile_interaction_metric (SELECT * FROM the_temp_table);
DELETE FROM the_temp_table;

EXECUTE the_insert_function_extension_mobile_interaction_metric (-1);
EXECUTE the_delete_function_extension_mobile_interaction_metric (-1);
INSERT INTO dx_rollup.extension_mobile_interaction_metric (SELECT * FROM the_temp_table);
DELETE FROM the_temp_table;



-- DEALLOCATE THE INSERT FUNCTION
DEALLOCATE the_insert_function_extension_mobile_interaction_metric;
DEALLOCATE the_delete_function_extension_mobile_interaction_metric;
