-- pull monthly oauth numbers for a subset of gaming apps

WITH
the_timeframe AS (
SELECT '2016-01-01' AS range_start, '2017-09-01' AS range_end
)

, app_include_list AS (
SELECT 'mlpjzuoqffzsj3obfbtwhlxeuepuvh' AS client_id
UNION ALL SELECT 't11hnc4bu1xj2yljd1t4dbruut4srkf' AS client_id
UNION ALL SELECT 'fnkzwj509yyr3u76ltk57nzhkhdd8g' AS client_id
UNION ALL SELECT 'mfieqnayt3vog4ucp023xjmdcoh35nu' AS client_id
UNION ALL SELECT 'pdw11y2y3bdtadcyknd791u6mqrqry' AS client_id
UNION ALL SELECT 'ik4kgnclcg9gv59ft7voz7ho5zzyuo2' AS client_id
UNION ALL SELECT 'saactj7j6kcf5ogqcv4n6zsgx32sy41' AS client_id
UNION ALL SELECT '8uxbhupm2ehjrxqohmnho5cxisx2rxo' AS client_id
UNION ALL SELECT 'rg5jwqeyulmyy5s5zsu7juu2l3q1ue' AS client_id
UNION ALL SELECT 'nmt37qblda36pvonovdkbopzfzw3wlq' AS client_id
UNION ALL SELECT 't8w2jadpw06vir58z12fg54rfuf66yw' AS client_id
UNION ALL SELECT 'dw1segz99n0yo3y4lngcph092b232v1' AS client_id
UNION ALL SELECT 'r1vlp9pn0fzavyojluufon1hmwf777t' AS client_id
UNION ALL SELECT '52bi3askk5pcwenzrymhsu1hkh0fbyi' AS client_id
UNION ALL SELECT 'bda5i0ujkd22lvf9bhf1r0bu0ynvlue' AS client_id
UNION ALL SELECT 'ayt99vsu56rd21c5sik9xnf4sobk27c' AS client_id
)

, monthly_oauth_logs AS (
SELECT client_id, DATE_TRUNC('month', time) AS the_month, COUNT(DISTINCT user_id) AS num_users_request_oauth
FROM logs.oauth_authorize
WHERE
"time" >= (SELECT range_start FROM the_timeframe) AND "time"< (SELECT range_end FROM the_timeframe)
AND client_id IN (SELECT client_id FROM app_include_list)
GROUP BY 1,2
)

SELECT * FROM
(
SELECT mol.client_id, REPLACE(soc.name, ',', '') AS app_name, mol.the_month, mol.num_users_request_oauth
FROM monthly_oauth_logs AS mol
LEFT JOIN analysis.sitedb_oauth2_clients AS soc ON mol.client_id = soc.client_id
-- WHERE soc.is_first_party IS FALSE
-- AND soc.oauth2_client_owner_id IS NOT NULL
)
ORDER BY app_name, the_month
