-- This is a template for unit test
-- Must return 1 row only per unit test check
-- so create multiple sql files for different tests

-- Put the sql file in    /home/airflow/files_testing     in coconut_box
-- the name of the sql file can be anything


-------------------------------
-- SCHEMA OF UNIT TEST TABLE --
-------------------------------
-- the_day (DATE)
-- slack_ldap (varchar)
-- flag_send_when_pass (bool)
-- flag_send_when_fail (bool)
-- logic_description (varchar)
-- bool_pass_fail (bool)
-- logic_pass_fail (custom varchar formatted for slack)     :white_check_mark: PASS        :x: FAIL
-- tables_used (varchar)
-------------------------------





WITH

--------------------------------------------------------------
-- UPDATE SOME CONSTANT VALUES  (START)                     --
-- NOTE: search for the string --->   change the value here --
--------------------------------------------------------------

------------------------------------------------------------------------------
-- THIS IS YOUR SLACK LDAP (NOTE: NOT YOUR CUSTOM SLACK NAME BUT YOUR LDAP) --
------------------------------------------------------------------------------
the_constants_slack_ldap AS (SELECT
  'yanghung' --change the value here
  ::VARCHAR(25) --leave this here unchanged since we are casting the data type explicitly
AS slack_ldap)



-------------------------------------------------------------------------------
-- TRUE IF YOU WANT TO SEND A MESSAGE WHEN THE CHECK PASSES, OTHERWISE FALSE --
-------------------------------------------------------------------------------
, the_constants_flag_send_when_pass AS (SELECT
  TRUE --change the value here, either   TRUE   or   FALSE
  ::BOOLEAN --leave this here unchanged since we are casting the data type explicitly
AS flag_send_when_pass)


------------------------------------------------------------------------------
-- TRUE IF YOU WANT TO SEND A MESSAGE WHEN THE CHECK FAILS, OTHERWISE FALSE --
------------------------------------------------------------------------------
, the_constants_flag_send_when_fail AS (SELECT
  TRUE --change the value here, either   TRUE   or   FALSE
  ::BOOLEAN --leave this here unchanged since we are casting the data type explicitly
AS flag_send_when_fail)


-------------------------------------------------------
-- THIS IS THE NAME OF THE TABLE(S) YOU ARE CHECKING --
-------------------------------------------------------
, the_constants_tables_used AS (SELECT
  'dx_metadata.released_extensions_latest' --change the value here
  ::VARCHAR(500) --leave this here unchanged since we are casting the data type explicitly
AS tables_used)


---------------------------------------------------------------
-- THIS IS A HUMAN DESCRIPTION OF THE LOGIC YOU ARE CHECKING --
---------------------------------------------------------------
, the_constants_logic_description AS (SELECT
  'Get the number of released extensions in the extensions store' --change the value here
  ::VARCHAR(1000) --leave this here unchanged since we are casting the data type explicitly
AS logic_description)




---------------------------------------
-- UPDATE SOME CONSTANT VALUES (END) --
----------------------------------------









------------------------------------------
-- UPDATE YOUR LOGIC CHECK HERE (START) --
------------------------------------------
, the_data AS (
  --extension_content_matched_metric_by_day
  SELECT COUNT(DISTINCT extension_id) AS num_extensions
  FROM dx_metadata.released_extensions_latest AS base
)

--------------------------------------------------------------------------------
-- WE MUST RETURN A STRING VALUE OF THE DATA CHECK STRING TO DISPLAY ON SLACK --
--------------------------------------------------------------------------------
, final_data AS (
  SELECT
    'There are '||num_extensions||' released extensions'
    AS the_result
  FROM the_data
)



----------------------------------------
-- UPDATE YOUR LOGIC CHECK HERE (END) --
----------------------------------------









-----------------------------------------------------------------------------------
-- YOU DONT NEED TO CHANGE THESE SINCE THEY REFERENCE YOUR CHANGES IN CODE ABOVE --
-----------------------------------------------------------------------------------
, final_unit_test AS (
  SELECT
    (SELECT DATE_TRUNC('day', (SYSDATE - INTERVAL '7 hours'))::DATE) AS the_day
    , (SELECT slack_ldap FROM the_constants_slack_ldap) AS slack_ldap
    , (SELECT flag_send_when_fail FROM the_constants_flag_send_when_fail) AS flag_send_when_fail
    , (SELECT flag_send_when_pass FROM the_constants_flag_send_when_pass) AS flag_send_when_pass
    , (SELECT logic_description FROM the_constants_logic_description) AS logic_description
    , TRUE::BOOLEAN AS bool_pass_fail --set this to always true since we want to display data
    , the_result AS logic_pass_fail_slack_string
    , (SELECT tables_used FROM the_constants_tables_used) AS tables_used


  FROM final_data
)
SELECT * FROM final_unit_test;
