-- check that we have data for recent 7 days
WITH

--------------------------------------------------------------
-- UPDATE SOME CONSTANT VALUES  (START)                     --
-- NOTE: search for the string --->   change the value here --
--------------------------------------------------------------

------------------------------------------------------------------------------
-- THIS IS YOUR SLACK LDAP (NOTE: NOT YOUR CUSTOM SLACK NAME BUT YOUR LDAP) --
------------------------------------------------------------------------------
the_constants_slack_ldap AS (SELECT
  'yanghung' --change the value here
  ::VARCHAR(25) --leave this here unchanged since we are casting the data type explicitly
AS slack_ldap)



-------------------------------------------------------------------------------
-- TRUE IF YOU WANT TO SEND A MESSAGE WHEN THE CHECK PASSES, OTHERWISE FALSE --
-------------------------------------------------------------------------------
, the_constants_flag_send_when_pass AS (SELECT
  TRUE --change the value here, either   TRUE   or   FALSE
  ::BOOLEAN --leave this here unchanged since we are casting the data type explicitly
AS flag_send_when_pass)


------------------------------------------------------------------------------
-- TRUE IF YOU WANT TO SEND A MESSAGE WHEN THE CHECK FAILS, OTHERWISE FALSE --
------------------------------------------------------------------------------
, the_constants_flag_send_when_fail AS (SELECT
  TRUE --change the value here, either   TRUE   or   FALSE
  ::BOOLEAN --leave this here unchanged since we are casting the data type explicitly
AS flag_send_when_fail)


-------------------------------------------------------
-- THIS IS THE NAME OF THE TABLE(S) YOU ARE CHECKING --
-------------------------------------------------------
, the_constants_tables_used AS (SELECT
  'dx_rollup.extension_content_matched_metric' --change the value here
  ::VARCHAR(500) --leave this here unchanged since we are casting the data type explicitly
AS tables_used)


---------------------------------------------------------------
-- THIS IS A HUMAN DESCRIPTION OF THE LOGIC YOU ARE CHECKING --
---------------------------------------------------------------
, the_constants_logic_description AS (SELECT
  'Has data for the most recent 7 days [Note: Fail means that one of the recent 7 days of data is missing]' --change the value here
  ::VARCHAR(1000) --leave this here unchanged since we are casting the data type explicitly
AS logic_description)




---------------------------------------
-- UPDATE SOME CONSTANT VALUES (END) --
----------------------------------------








------------------------------------------
-- UPDATE YOUR LOGIC CHECK HERE (START) --
------------------------------------------
, the_data AS (
  --extension_content_matched_metric_by_day
  SELECT the_day
    , COUNT(1) AS rows
  FROM dx_rollup.extension_content_matched_metric AS base
  WHERE
    the_day>=(SELECT MIN(the_day) FROM dx_metadata.rolling_7_days)
    AND the_day<=(SELECT MAX(the_day) FROM dx_metadata.rolling_7_days)
  GROUP BY 1
)
, join_data AS (
  SELECT base.the_day, the_data.rows
    , CASE
        WHEN the_data.rows >0 THEN TRUE
        ELSE FALSE
      END AS flag_rows_gt_0
  FROM dx_metadata.rolling_7_days AS base
  LEFT JOIN the_data ON base.the_day = the_data.the_day
)

, final_data AS (
  SELECT
    BOOL_AND(flag_rows_gt_0) AS flag_individual_boolean
  FROM join_data
)


----------------------------------------------------------------------------------
-- WE MUST RETURN 1 BOOLEAN VALUE OF TRUE/FALSE HERE AND NAME IT bool_pass_fail --
----------------------------------------------------------------------------------
, logic_final AS (
  -- BOOL_AND is the intersect of each individual TRUE/FALSE
  SELECT BOOL_AND(flag_individual_boolean) AS bool_pass_fail -- you can keep this line as long as you kept col name "flag_individual_boolean"
  FROM final_data -- update your table name here
)



----------------------------------------
-- UPDATE YOUR LOGIC CHECK HERE (END) --
----------------------------------------










-----------------------------------------------------------------------------------
-- YOU DONT NEED TO CHANGE THESE SINCE THEY REFERENCE YOUR CHANGES IN CODE ABOVE --
-----------------------------------------------------------------------------------
, final_unit_test AS (
  SELECT
    (SELECT DATE_TRUNC('day', (SYSDATE - INTERVAL '7 hours'))::DATE) AS the_day
    , (SELECT slack_ldap FROM the_constants_slack_ldap) AS slack_ldap
    , (SELECT flag_send_when_fail FROM the_constants_flag_send_when_fail) AS flag_send_when_fail
    , (SELECT flag_send_when_pass FROM the_constants_flag_send_when_pass) AS flag_send_when_pass
    , (SELECT logic_description FROM the_constants_logic_description) AS logic_description
    , bool_pass_fail
    , CASE WHEN bool_pass_fail = TRUE THEN ':white_check_mark: PASS'::VARCHAR(25) ELSE ':x: FAIL'::VARCHAR(25) END AS logic_pass_fail_slack_string
    , (SELECT tables_used FROM the_constants_tables_used) AS tables_used


  FROM logic_final
)
SELECT * FROM final_unit_test;
