-- This is a template for unit test

WITH

--------------------------------------------------------------
-- UPDATE SOME CONSTANT VALUES  (START)                     --
-- NOTE: search for the string --->   change the value here --
--------------------------------------------------------------

------------------------------------------------------------------------------
-- THIS IS YOUR SLACK LDAP (NOTE: NOT YOUR CUSTOM SLACK NAME BUT YOUR LDAP) --
------------------------------------------------------------------------------
the_constants_slack_ldap AS (SELECT
  'yanghung'
  ::VARCHAR(50) --change the value here
AS slack_ldap)



-------------------------------------------------------------------------------
-- TRUE IF YOU WANT TO SEND A MESSAGE WHEN THE CHECK PASSES, OTHERWISE FALSE --
-------------------------------------------------------------------------------
, the_constants_flag_send_when_pass AS (SELECT
  TRUE
  ::BOOLEAN --change the value here
AS flag_send_when_pass)


------------------------------------------------------------------------------
-- TRUE IF YOU WANT TO SEND A MESSAGE WHEN THE CHECK FAILS, OTHERWISE FALSE --
------------------------------------------------------------------------------
, the_constants_flag_send_when_fail AS (SELECT
  TRUE
  ::BOOLEAN --change the value here
AS flag_send_when_fail)


-------------------------------------------------------
-- THIS IS THE NAME OF THE TABLE(S) YOU ARE CHECKING --
-------------------------------------------------------
, the_constants_tables_used AS (SELECT
  'dx_rollup.extension_content_matched_metric'
  ::VARCHAR(500) --change the value here
AS tables_used)


---------------------------------------------------------------
-- THIS IS A HUMAN DESCRIPTION OF THE LOGIC YOU ARE CHECKING --
---------------------------------------------------------------
, the_constants_logic_description AS (SELECT
  'Check to see if rows inserted for yesterday is too few (<=1.5 SD From 30 day average rows inserted) [Note: Fail means too few rows]'
  ::VARCHAR(1000) --change the value here
AS logic_description)




---------------------------------------
-- UPDATE SOME CONSTANT VALUES (END) --
----------------------------------------









------------------------------------------
-- UPDATE YOUR LOGIC CHECK HERE (START) --
------------------------------------------
-- get latest 30 days of rows generated
, rolling_30_day_data as (
 SELECT the_day as the_day, COUNT(1) as num_rows
 FROM dx_rollup.extension_content_matched_metric
 WHERE
   the_day>=(SELECT MIN(the_day) FROM dx_metadata.rolling_30_days)
   AND the_day<=(SELECT MAX(the_day) FROM dx_metadata.rolling_30_days)
 GROUP BY 1
)
-- get recent day of rows generated
, latest_day_data AS (
 SELECT the_day as the_day, COUNT(1) as num_rows
 FROM dx_rollup.extension_content_matched_metric
 WHERE
   the_day=(SELECT (SYSDATE - INTERVAL '7 hours')::DATE - INTERVAL '1 days')
 GROUP BY 1
)
-- calculate average and std dev of rows created over the latest 30 days
, stats as (
 SELECT
   STDDEV(num_rows) as sd_rows
   , AVG(num_rows) as avg_rows
 FROM rolling_30_day_data
)
-- calculate the recent day's SD from mean
, stats_final as (
 select a.the_day, a.num_rows, (a.num_rows - b.avg_rows)/b.sd_rows as SD_from_mean
 FROM latest_day_data a ,stats b
 group by 1,2,3
)
-- final logic case statement
, final_data AS (
  SELECT
   CASE
     WHEN SD_from_mean<=-1.5 THEN FALSE -- if >=1.5 SD from mean, return false since it didn't pass test
     ELSE TRUE
   END AS flag_individual_boolean
  FROM stats_final
)


----------------------------------------------------------------------------------
-- WE MUST RETURN 1 BOOLEAN VALUE OF TRUE/FALSE HERE AND NAME IT bool_pass_fail --
----------------------------------------------------------------------------------
, logic_final AS (
  -- BOOL_AND is the intersect of each individual TRUE/FALSE
  SELECT BOOL_AND(flag_individual_boolean) AS bool_pass_fail -- you can keep this line as long as you kept col name "flag_individual_boolean"
  FROM final_data -- update your table name here
)



----------------------------------------
-- UPDATE YOUR LOGIC CHECK HERE (END) --
----------------------------------------










-----------------------------------------------------------------------------------
-- YOU DONT NEED TO CHANGE THESE SINCE THEY REFERENCE YOUR CHANGES IN CODE ABOVE --
-----------------------------------------------------------------------------------
, final_unit_test AS (
  SELECT
    (SELECT DATE_TRUNC('day', (SYSDATE - INTERVAL '7 hours'))::DATE) AS the_day
    , (SELECT slack_ldap FROM the_constants_slack_ldap) AS slack_ldap
    , (SELECT flag_send_when_fail FROM the_constants_flag_send_when_fail) AS flag_send_when_fail
    , (SELECT flag_send_when_pass FROM the_constants_flag_send_when_pass) AS flag_send_when_pass
    , (SELECT logic_description FROM the_constants_logic_description) AS logic_description
    , bool_pass_fail
    , CASE WHEN bool_pass_fail = TRUE THEN ':white_check_mark: PASS'::VARCHAR(25) ELSE ':x: FAIL'::VARCHAR(25) END AS logic_pass_fail_slack_string
    , (SELECT tables_used FROM the_constants_tables_used) AS tables_used


  FROM logic_final
)
SELECT * FROM final_unit_test;
