DROP TABLE IF EXISTS the_temp_table; -- just in case there's a duplicate named table called "the_temp_table" since we often reuse this name
CREATE TEMP TABLE the_temp_table (LIKE dx_sandbox.extensions_metadata_helper_metadata_main);

INSERT INTO the_temp_table (


  WITH

  extensions_ios as (
    SELECT
      RTRIM(LTRIM(member, '"c:'),'"') AS extension_id
      , CASE
        WHEN JSON_EXTRACT_PATH_TEXT(JSON_EXTRACT_ARRAY_ELEMENT_TEXT(log,0), 'Log.val.Activated') = 'true' THEN TRUE
        ELSE FALSE
      END AS flag_is_ios_enabled
    FROM dbsnapshots.extensions_whitelist_membership
    WHERE member LIKE '"c:%"' AND action = 'display_on_ios'
  )

  , extensions_metadata_main AS (
    SELECT base.id AS extension_id, version AS extension_version

  -- basic metadata
    , JSON_EXTRACT_PATH_TEXT(details, 'Name') as extension_name
    , JSON_EXTRACT_ARRAY_ELEMENT_TEXT(JSON_EXTRACT_PATH_TEXT(details, 'Categories'), 0) AS category_id
    , JSON_EXTRACT_PATH_TEXT(details, 'AuthorName') as author_name
    , JSON_EXTRACT_PATH_TEXT(details, 'SupportEmail') as author_email
    , 'https://www.twitch.tv/ext/' + base.id as extension_url

  -- monetization related boolean flags
    , JSON_EXTRACT_PATH_TEXT(details, 'BitsEnabled') as is_bits_enabled

  -- viewer side boolean flags
    , JSON_EXTRACT_PATH_TEXT(details, 'HasChatSupport') as is_chat_enabled
    , JSON_EXTRACT_PATH_TEXT(viewerbehavior, 'RequestIdentityLink') as is_viewer_identity_required

  --- various anchor enabled boolean flags
    , CASE
        WHEN JSON_EXTRACT_PATH_TEXT(content, 'Views','VideoOverlay') = '' or JSON_EXTRACT_PATH_TEXT(content, 'Views','VideoOverlay','ViewerPath') = ''
          THEN False
        WHEN JSON_EXTRACT_PATH_TEXT(content, 'Views','VideoOverlay','ViewerPath') LIKE '%.html'
          THEN True
        ELSE False
      END AS is_overlay_enabled

    , CASE
        WHEN JSON_EXTRACT_PATH_TEXT(content, 'Views','Panel') = '' or JSON_EXTRACT_PATH_TEXT(content, 'Views','Panel','ViewerPath') = ''
          THEN False
        WHEN JSON_EXTRACT_PATH_TEXT(content, 'Views','Panel','ViewerPath') LIKE '%.html'
          THEN True
        ELSE False
      END AS is_panel_enabled

    , CASE
        WHEN JSON_EXTRACT_PATH_TEXT(content, 'Views','Component') = ''  or JSON_EXTRACT_PATH_TEXT(content, 'Views','Component','ViewerPath') = ''
          THEN False
        WHEN JSON_EXTRACT_PATH_TEXT(content, 'Views','Component','ViewerPath') LIKE '%.html'
          THEN True
        ELSE False
      END AS is_component_enabled


  -- ios enabled logic is a bit different than other anchor point boolean logic
      , CASE
          WHEN JSON_EXTRACT_PATH_TEXT(content, 'Views','Mobile') = '' or JSON_EXTRACT_PATH_TEXT(content, 'Views','Mobile','ViewerPath') = ''
            THEN False
          WHEN JSON_EXTRACT_PATH_TEXT(content, 'Views','Mobile','ViewerPath') LIKE '%.html'
            THEN True
          ELSE False
        END AS is_android_enabled

      , CASE
          WHEN JSON_EXTRACT_PATH_TEXT(content, 'Views','Mobile') = '' or JSON_EXTRACT_PATH_TEXT(content, 'Views','Mobile','ViewerPath') = ''
            THEN False
          WHEN JSON_EXTRACT_PATH_TEXT(content, 'Views','Mobile','ViewerPath') LIKE '%.html' AND extensions_ios.flag_is_ios_enabled = TRUE
            THEN True
          ELSE False
        END AS is_ios_enabled

  --- channel whitelist metadata
    , CASE
        WHEN ChannelWhitelist = '' OR ChannelWhitelist IS NULL OR JSON_EXTRACT_ARRAY_ELEMENT_TEXT(ChannelWhitelist,0) = ''
          THEN False
        ELSE True
      END AS is_whitelisted_extension
    , CASE
        WHEN ChannelWhitelist = '' OR ChannelWhitelist IS NULL OR JSON_EXTRACT_ARRAY_ELEMENT_TEXT(ChannelWhitelist,0) = ''
          THEN NULL
        ELSE ChannelWhitelist
      END AS whitelist_channels

    FROM dbsnapshots.extensions_extension_versions AS base
    LEFT JOIN extensions_ios ON base.id = extensions_ios.extension_id
    WHERE is_valid_json(base.details) --this is the main json blob
  )

  -- rearrange some of the columns, do some renaming to keep consistency with old released_extensions_latest tables etc.
  , final_data AS (
    SELECT
      (SELECT      DATEADD('day', -1,  DATE_TRUNC('day', (SYSDATE - INTERVAL '7 hours'))  )      )::DATE AS the_day
      , extension_id::VARCHAR(32)
      , extension_version::VARCHAR(50)
      , extension_name::VARCHAR(500)
      , category_id::VARCHAR(50) AS extension_category_id
      , cat.name::VARCHAR(500) AS extension_category_name
      , author_name::VARCHAR(500) AS extension_author_name
      , author_email::VARCHAR(500) AS extension_support_email
      , extension_url::VARCHAR(500)
      , DECODE(LOWER(is_bits_enabled),
               'false', '0', 'true', '1')::integer::boolean AS is_bits_enabled -- hacky solution to cast string to boolean see ---> https://stackoverflow.com/a/47560708
      , DECODE(LOWER(is_chat_enabled),
               'false', '0', 'true', '1')::integer::boolean AS is_chat_enabled -- hacky solution to cast string to boolean see ---> https://stackoverflow.com/a/47560708
      , is_overlay_enabled::BOOLEAN
      , is_component_enabled::BOOLEAN
      , is_panel_enabled::BOOLEAN
      , is_android_enabled::BOOLEAN AS is_mobile_enabled --keep this flag to keep consistency with old released_extensions_latest naming
      , is_android_enabled::BOOLEAN
      , is_ios_enabled::BOOLEAN
      , DECODE(LOWER(is_viewer_identity_required),
               'false', '0', 'true', '1')::integer::boolean AS is_viewer_identity_required -- hacky solution to cast string to boolean see ---> https://stackoverflow.com/a/47560708
      , is_whitelisted_extension::BOOLEAN
      , whitelist_channels::VARCHAR(65535)

    FROM extensions_metadata_main AS base
    LEFT JOIN dx_csv.extensions_category_mapping AS cat ON base.category_id = cat.id
  )

  SELECT * FROM final_data



);




DELETE FROM dx_sandbox.extensions_metadata_helper_metadata_main
WHERE the_day = DATEADD('day', -1,  DATE_TRUNC('day', (SYSDATE - INTERVAL '7 hours'))  )
;



INSERT INTO dx_sandbox.extensions_metadata_helper_metadata_main (
  SELECT * FROM the_temp_table
);
