// run this in command line
// node process_extension_category_json.js ./extension_category.json>>extension_category.csv

// Gets the .sql code to upload the released extensions

var fs = require('fs');
// var moment = require('moment');
var args = process.argv.slice(2); // Normalize arguments list see:  https://stackoverflow.com/questions/4351521/how-do-i-pass-command-line-arguments
var filename = args[0]; // The name of the json file you want to parse

var filename_extension = filename.slice(filename.length-4, filename.length);



if (filename_extension=='json') {
  var the_json = JSON.parse(fs.readFileSync(filename, 'utf8'))['categories'];
  var the_json_length = the_json.length;

  for (var i=0; i<the_json_length; i++) {
    const id = the_json[i]['id'];
    const type = the_json[i]['type'];
    const order = the_json[i]['order'];
    const sort_key = the_json[i]['sort_key'];
    const readonly = the_json[i]['readonly'];
    const visible = the_json[i]['visible'];
    const deleted = the_json[i]['deleted'];
    const name = the_json[i]['name'];
    const description = the_json[i]['description'];
    console.log(
      id
      +'|'+type
      +'|'+order
      +'|'+sort_key
      +'|'+readonly
      +'|'+visible
      +'|'+deleted
      +'|'+name
      +'|'+description
    );

  }
}
